/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.MemoryBankNV;
import com.dalsemi.onewire.container.MemoryBankNVCRC;
import com.dalsemi.onewire.container.MemoryBankScratch;
import com.dalsemi.onewire.container.MemoryBankScratchSHA;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.utils.CRC16;
import java.util.Enumeration;
import java.util.Vector;

public class OneWireContainer18
extends OneWireContainer {
    private MemoryBankScratch scratch;
    private MemoryBankNVCRC memory;
    private MemoryBankNVCRC memoryPlus;
    private int block_wait_count = 20;
    private boolean resume = false;
    private boolean doSpeedEnable = true;
    private byte[] byte_buffer = new byte[60];
    protected byte[] FF = new byte[60];
    private byte[] private_address = new byte[8];
    private byte TA1;
    private byte TA2;
    private byte ES;
    public static final byte READ_MEMORY = -16;
    public static final byte WRITE_SCRATCHPAD = 15;
    public static final byte MATCH_SCRATCHPAD = 60;
    public static final byte ERASE_SCRATCHPAD = -61;
    public static final byte READ_SCRATCHPAD = -86;
    public static final byte READ_AUTHENTICATED_PAGE = -91;
    public static final byte COPY_SCRATCHPAD = 85;
    public static final byte COMPUTE_SHA = 51;
    public static final byte COMPUTE_FIRST_SECRET = 15;
    public static final byte COMPUTE_NEXT_SECRET = -16;
    public static final byte VALIDATE_DATA_PAGE = 60;
    public static final byte SIGN_DATA_PAGE = -61;
    public static final byte COMPUTE_CHALLENGE = -52;
    public static final byte AUTH_HOST = -86;
    public static final byte RESUME = -91;
    private byte[] bind_code_temp = new byte[32];
    private byte[] bind_code_alt_temp = new byte[32];
    private byte[] bind_data_temp = new byte[32];

    public OneWireContainer18() {
        int n = 0;
        while (n < this.FF.length) {
            this.FF[n] = -1;
            ++n;
        }
        this.initMem();
    }

    public OneWireContainer18(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
        int n = 0;
        while (n < this.FF.length) {
            this.FF[n] = -1;
            ++n;
        }
        this.initMem();
    }

    public OneWireContainer18(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
        int n = 0;
        while (n < this.FF.length) {
            this.FF[n] = -1;
            ++n;
        }
        this.initMem();
    }

    public OneWireContainer18(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
        int n = 0;
        while (n < this.FF.length) {
            this.FF[n] = -1;
            ++n;
        }
        this.initMem();
    }

    public void setupContainer(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super.setupContainer(dSPortAdapter, byArray);
        OneWireContainer18 oneWireContainer18 = this;
        synchronized (oneWireContainer18) {
            System.arraycopy(byArray, 0, this.private_address, 0, 8);
            this.address = this.private_address;
        }
    }

    public String getName() {
        return "DS1963S";
    }

    public String getAlternateNames() {
        return "SHA-1 iButton";
    }

    public String getDescription() {
        return "4096 bits of read/write nonvolatile memory. Memory is partitioned into sixteen pages of 256 bits each. Has overdrive mode.  One-chip 512-bit SHA-1 engine and secret storage.";
    }

    public int getMaxSpeed() {
        return 2;
    }

    public Enumeration getMemoryBanks() {
        Vector<PagedMemoryBank> vector = new Vector<PagedMemoryBank>(4);
        vector.addElement(this.scratch);
        vector.addElement(this.memory);
        vector.addElement(this.memoryPlus);
        MemoryBankNV memoryBankNV = new MemoryBankNV(this, this.scratch);
        memoryBankNV.numberPages = 3;
        memoryBankNV.size = 96;
        memoryBankNV.bankDescription = "Write cycle counters and PRNG counter";
        memoryBankNV.startPhysicalAddress = 608;
        memoryBankNV.readOnly = true;
        memoryBankNV.pageAutoCRC = false;
        memoryBankNV.generalPurposeMemory = false;
        memoryBankNV.readWrite = false;
        vector.addElement(memoryBankNV);
        return vector.elements();
    }

    private void initMem() {
        this.scratch = new MemoryBankScratchSHA(this);
        this.memory = new MemoryBankNVCRC(this, this.scratch);
        this.memory.numberPages = 8;
        this.memory.size = 256;
        this.memory.extraInfoLength = 8;
        this.memory.readContinuePossible = false;
        this.memory.numVerifyBytes = 8;
        this.memoryPlus = new MemoryBankNVCRC(this, this.scratch);
        this.memoryPlus.numberPages = 8;
        this.memoryPlus.size = 256;
        this.memoryPlus.bankDescription = "Memory with write cycle counter";
        this.memoryPlus.startPhysicalAddress = 256;
        this.memoryPlus.extraInfo = true;
        this.memoryPlus.extraInfoDescription = "Write cycle counter";
        this.memoryPlus.extraInfoLength = 8;
        this.memoryPlus.readContinuePossible = false;
        this.memoryPlus.numVerifyBytes = 8;
    }

    public synchronized void setSpeedCheck(boolean bl) {
        this.doSpeedEnable = bl;
    }

    public synchronized void useResume(boolean bl) {
        this.resume = bl;
    }

    public synchronized boolean eraseScratchPad(int n) throws OneWireIOException, OneWireException {
        if (this.doSpeedEnable && !this.resume) {
            this.doSpeed();
        }
        if (!this.resume) {
            this.adapter.select(this.address);
        } else {
            this.adapter.reset();
            this.adapter.putByte(-91);
        }
        byte[] byArray = this.byte_buffer;
        byArray[0] = -61;
        byArray[1] = (byte)(n << 5);
        byArray[2] = (byte)(n >> 3);
        System.arraycopy(this.FF, 0, byArray, 3, 3);
        this.adapter.dataBlock(byArray, 0, 6);
        if (byArray[5] == -1) {
            return this.waitForSuccessfulFinish();
        }
        return true;
    }

    public synchronized boolean waitForSuccessfulFinish() throws OneWireIOException, OneWireException {
        int n = 0;
        while (this.adapter.getByte() == 255) {
            if (++n != this.block_wait_count) continue;
            return false;
        }
        return true;
    }

    public void readMemoryPage(int n, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        this.readMemoryPage(n, (byte)-16, 32, byArray, n2);
    }

    private synchronized void readMemoryPage(int n, byte by, int n2, byte[] byArray, int n3) throws OneWireIOException, OneWireException {
        if (this.doSpeedEnable && !this.resume) {
            this.doSpeed();
        }
        if (!this.resume) {
            this.adapter.select(this.address);
        } else {
            this.adapter.reset();
            this.adapter.putByte(-91);
        }
        byte[] byArray2 = this.byte_buffer;
        int n4 = n << 5;
        byArray2[0] = by;
        byArray2[1] = (byte)n4;
        byArray2[2] = (byte)(n4 >> 8);
        System.arraycopy(this.FF, 0, byArray2, 3, n2);
        this.adapter.dataBlock(byArray2, 0, 3 + n2);
        System.arraycopy(byArray2, 3, byArray, n3, n2);
    }

    public boolean readAuthenticatedPage(int n, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        this.readMemoryPage(n, (byte)-91, 42, byArray, n2);
        int n3 = CRC16.compute(-91);
        n3 = CRC16.compute((byte)(n << 5), n3);
        n3 = CRC16.compute((byte)(n >>> 3), n3);
        if (CRC16.compute(byArray, n2, 42, n3) != 45057) {
            return false;
        }
        return this.waitForSuccessfulFinish();
    }

    public synchronized boolean writeScratchPad(int n, int n2, byte[] byArray, int n3, int n4) throws OneWireIOException, OneWireException {
        if (this.doSpeedEnable && !this.resume) {
            this.doSpeed();
        }
        if (!this.resume) {
            this.adapter.select(this.address);
        } else {
            this.adapter.reset();
            this.adapter.putByte(-91);
        }
        int n5 = (n << 5) + n2;
        byte[] byArray2 = this.byte_buffer;
        byArray2[0] = 15;
        byArray2[1] = (byte)n5;
        byArray2[2] = (byte)(n5 >> 8);
        int n6 = 32 - (n5 & 0x1F);
        if (n4 > n6) {
            n4 = n6;
        }
        System.arraycopy(byArray, n3, byArray2, 3, n4);
        byArray2[3 + n4] = -1;
        byArray2[4 + n4] = -1;
        this.adapter.dataBlock(byArray2, 0, (n5 + n4 & 0x1F) == 0 ? n4 + 5 : n4 + 3);
        if ((n5 + n4 & 0x1F) != 0) {
            return true;
        }
        return CRC16.compute(byArray2, 0, n4 + 5, 0) == 45057;
    }

    public synchronized boolean matchScratchPad(byte[] byArray) throws OneWireIOException, OneWireException {
        if (this.doSpeedEnable && !this.resume) {
            this.doSpeed();
        }
        if (!this.resume) {
            this.adapter.select(this.address);
        } else {
            this.adapter.reset();
            this.adapter.putByte(-91);
        }
        byte[] byArray2 = this.byte_buffer;
        byArray2[0] = 60;
        System.arraycopy(byArray, 0, byArray2, 1, 20);
        byArray2[21] = -1;
        byArray2[22] = -1;
        byArray2[23] = -1;
        this.adapter.dataBlock(byArray2, 0, 24);
        if (CRC16.compute(byArray2, 0, 23, 0) != 45057) {
            return false;
        }
        return byArray2[23] != -1;
    }

    public synchronized int readScratchPad(byte[] byArray, int n) throws OneWireIOException, OneWireException {
        if (this.doSpeedEnable && !this.resume) {
            this.doSpeed();
        }
        if (!this.resume) {
            this.adapter.select(this.address);
        } else {
            this.adapter.reset();
            this.adapter.putByte(-91);
        }
        byte[] byArray2 = this.byte_buffer;
        byArray2[0] = -86;
        System.arraycopy(this.FF, 0, byArray2, 1, 37);
        this.adapter.dataBlock(byArray2, 0, 38);
        this.TA1 = byArray2[1];
        this.TA2 = byArray2[2];
        this.ES = byArray2[3];
        int n2 = 32 - (this.TA1 & 0x1F);
        if (CRC16.compute(byArray2, 0, 6 + n2, 0) != 45057) {
            return -1;
        }
        if (byArray != null) {
            System.arraycopy(byArray2, 4, byArray, n, n2);
        }
        return n2;
    }

    public synchronized boolean copyScratchPad() throws OneWireIOException, OneWireException {
        if (this.doSpeedEnable && !this.resume) {
            this.doSpeed();
        }
        if (!this.resume) {
            this.adapter.select(this.address);
        } else {
            this.adapter.reset();
            this.adapter.putByte(-91);
        }
        byte[] byArray = this.byte_buffer;
        byArray[0] = 85;
        byArray[1] = this.TA1;
        byArray[2] = this.TA2;
        byArray[3] = this.ES;
        System.arraycopy(this.FF, 0, byArray, 4, 5);
        this.adapter.dataBlock(byArray, 0, 9);
        if (byArray[8] == -1) {
            return this.waitForSuccessfulFinish();
        }
        return true;
    }

    public synchronized boolean installMasterSecret(int n, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        if (byArray.length == 0) {
            return false;
        }
        byte[] byArray2 = null;
        byte[] byArray3 = this.byte_buffer;
        int n3 = byArray.length % 47;
        if (n3 == 0) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[byArray.length + (47 - n3)];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        int n4 = (n2 &= 7) > 3 ? 17 : 16;
        int n5 = (n2 & 3) << 3;
        int n6 = 0;
        byte[] byArray4 = new byte[32];
        while (n6 < byArray2.length) {
            if (!this.eraseScratchPad(n)) {
                return false;
            }
            if (!this.writeScratchPad(n, 0, byArray2, n6, 32)) {
                return false;
            }
            if (this.readScratchPad(byArray3, 0) < 0) {
                return false;
            }
            if (!this.copyScratchPad()) {
                return false;
            }
            System.arraycopy(byArray2, n6 + 32, byArray4, 8, 15);
            if (!this.writeScratchPad(n, 0, byArray4, 0, 32)) {
                return false;
            }
            if (!this.SHAFunction(n6 == 0 ? (byte)15 : -16)) {
                return false;
            }
            if (!this.write_read_copy_quick(n4, n5)) {
                return false;
            }
            n6 += 47;
        }
        this.eraseScratchPad(n);
        this.readScratchPad(byArray3, 0);
        this.copyScratchPad();
        return true;
    }

    public synchronized boolean bindSecretToiButton(int n, byte[] byArray, byte[] byArray2, int n2) throws OneWireIOException, OneWireException {
        if (byArray.length != 32) {
            System.arraycopy(byArray, 0, this.bind_data_temp, 0, byArray.length > 32 ? 32 : byArray.length);
            byArray = this.bind_data_temp;
        }
        if (byArray2.length != 15) {
            if (byArray2.length == 7) {
                System.arraycopy(byArray2, 0, this.bind_code_alt_temp, 0, 4);
                this.bind_code_alt_temp[4] = (byte)n;
                System.arraycopy(this.address, 0, this.bind_code_alt_temp, 5, 7);
                System.arraycopy(byArray2, 4, this.bind_code_alt_temp, 12, 3);
            } else {
                System.arraycopy(byArray2, 0, this.bind_code_alt_temp, 0, byArray2.length > 15 ? 15 : byArray2.length);
            }
            byArray2 = this.bind_code_alt_temp;
        }
        System.arraycopy(byArray2, 0, this.bind_code_temp, 8, 15);
        byArray2 = this.bind_code_temp;
        if (!this.writeDataPage(n, byArray)) {
            return false;
        }
        this.resume = true;
        if (!this.writeScratchPad(n, 0, byArray2, 0, 32)) {
            this.resume = false;
            return false;
        }
        if (!this.SHAFunction((byte)-16)) {
            this.resume = false;
            return false;
        }
        this.resume = false;
        int n3 = (n2 &= 7) > 3 ? 17 : 16;
        int n4 = (n2 & 3) << 3;
        return this.write_read_copy_quick(n3, n4);
    }

    private synchronized boolean write_read_copy_quick(int n, int n2) throws OneWireIOException, OneWireException {
        int n3 = (n << 5) + n2;
        byte[] byArray = this.byte_buffer;
        byArray[0] = -91;
        byArray[1] = 15;
        byArray[2] = (byte)n3;
        byArray[3] = (byte)(n3 >> 8);
        int n4 = 32 - n2;
        this.adapter.reset();
        System.arraycopy(this.FF, 0, byArray, 4, n4 + 2);
        this.adapter.dataBlock(byArray, 0, n4 + 6);
        if (CRC16.compute(byArray, 1, n4 + 5, 0) != 45057) {
            return false;
        }
        byArray[1] = -86;
        System.arraycopy(this.FF, 0, byArray, 2, 8);
        this.adapter.reset();
        this.adapter.dataBlock(byArray, 0, 5);
        byArray[1] = 85;
        this.adapter.reset();
        this.adapter.dataBlock(byArray, 0, 8);
        if (byArray[7] == -1) {
            return this.waitForSuccessfulFinish();
        }
        return true;
    }

    public synchronized boolean writeDataPage(int n, byte[] byArray) throws OneWireIOException, OneWireException {
        if (this.doSpeedEnable && !this.resume) {
            this.doSpeed();
        }
        if (!this.resume) {
            this.adapter.select(this.address);
        } else {
            this.adapter.reset();
            this.adapter.putByte(-91);
        }
        byte[] byArray2 = this.byte_buffer;
        byArray2[1] = -61;
        byArray2[2] = 0;
        byArray2[3] = 0;
        System.arraycopy(this.FF, 0, byArray2, 4, 3);
        this.adapter.dataBlock(byArray2, 1, 6);
        if (byArray2[6] == -1 && !this.waitForSuccessfulFinish()) {
            return false;
        }
        int n2 = n << 5;
        byArray2[0] = -91;
        byArray2[1] = 15;
        byArray2[2] = (byte)n2;
        byArray2[3] = (byte)(n2 >> 8);
        System.arraycopy(byArray, 0, byArray2, 4, 32);
        byArray2[36] = -1;
        byArray2[37] = -1;
        this.adapter.reset();
        this.adapter.dataBlock(byArray2, 0, 38);
        if (CRC16.compute(byArray2, 1, 37, 0) != 45057) {
            return false;
        }
        this.adapter.reset();
        byArray2[1] = -86;
        System.arraycopy(this.FF, 0, byArray2, 2, 37);
        this.adapter.dataBlock(byArray2, 0, 39);
        int n3 = 32 - (byArray2[2] & 0x1F);
        if (CRC16.compute(byArray2, 1, 6 + n3, 0) != 45057) {
            return false;
        }
        this.adapter.reset();
        byArray2[1] = 85;
        System.arraycopy(this.FF, 0, byArray2, 5, 3);
        this.adapter.dataBlock(byArray2, 0, 8);
        if (byArray2[7] == -1) {
            return this.waitForSuccessfulFinish();
        }
        return true;
    }

    public boolean SHAFunction(byte by) throws OneWireIOException, OneWireException {
        return this.SHAFunction(by, this.TA1 & 0xFF | this.TA2 << 8);
    }

    public synchronized boolean SHAFunction(byte by, int n) throws OneWireIOException, OneWireException {
        if (this.doSpeedEnable && !this.resume) {
            this.doSpeed();
        }
        if (!this.resume) {
            this.adapter.select(this.address);
        } else {
            this.adapter.reset();
            this.adapter.putByte(-91);
        }
        byte[] byArray = this.byte_buffer;
        byArray[0] = 51;
        byArray[1] = (byte)n;
        byArray[2] = (byte)(n >> 8);
        byArray[3] = by;
        System.arraycopy(this.FF, 0, byArray, 4, 5);
        this.adapter.dataBlock(byArray, 0, 9);
        if (CRC16.compute(byArray, 0, 6, 0) != 45057) {
            return false;
        }
        if (byArray[8] == -1) {
            return this.waitForSuccessfulFinish();
        }
        return true;
    }
}

