/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.CommandAPDU;
import com.dalsemi.onewire.container.JibComm;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.ResponseAPDU;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class OneWireContainer16
extends OneWireContainer {
    static final byte CLA = -48;
    static final byte INS = -107;
    public static final int PASSWORD_LENGTH_SIZE = 1;
    public static final int PASSWORD_SIZE = 8;
    public static final int AID_LENGTH_SIZE = 1;
    public static final int AID_SIZE = 16;
    public static final int AID_LENGTH_OFFSET = 9;
    public static final int AID_NAME_OFFSET = 10;
    public static final int APPLET_FILE_HEADER_SIZE = 26;
    public static int APDU_PACKET_LENGTH = 64;
    private String password;
    private CommandAPDU capdu = null;
    private ResponseAPDU rapdu = null;
    private JibComm jibComm;
    private int runTime = 0;

    public OneWireContainer16() {
    }

    public OneWireContainer16(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
    }

    public OneWireContainer16(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
    }

    public OneWireContainer16(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
    }

    public String getName() {
        return "DS195X";
    }

    public String getAlternateNames() {
        return "Java iButton, Cryptographic iButton";
    }

    public String getDescription() {
        return "JavaCard 2.0 compliant device.";
    }

    public void setupContainer(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super.setupContainer(dSPortAdapter, byArray);
        this.setupJibComm(this.adapter, this.address);
    }

    public void setupContainer(DSPortAdapter dSPortAdapter, long l) {
        super.setupContainer(dSPortAdapter, l);
        this.setupJibComm(this.adapter, this.address);
    }

    public void setupContainer(DSPortAdapter dSPortAdapter, String string) {
        super.setupContainer(dSPortAdapter, string);
        this.setupJibComm(this.adapter, this.address);
    }

    public void setupJibComm(DSPortAdapter dSPortAdapter, byte[] byArray) {
        this.speed = 2;
        this.speedFallBackOK = false;
        this.jibComm = new JibComm(dSPortAdapter, byArray);
    }

    public int getMaxSpeed() {
        return 2;
    }

    public CommandAPDU getCommandAPDUInfo() {
        return this.capdu;
    }

    public ResponseAPDU getResponseAPDUInfo() {
        return this.rapdu;
    }

    public int getRunTime() {
        return this.runTime;
    }

    public void setRunTime(int n) throws IllegalArgumentException {
        if (this.runTime > 15 || this.runTime < 0) {
            throw new IllegalArgumentException("Run Time value should be between 0 and 15.");
        }
        this.runTime = n;
    }

    public boolean setLoadPacketSize(int n) {
        if (n < 64 || n > 112) {
            return false;
        }
        APDU_PACKET_LENGTH = n;
        return true;
    }

    public int getLoadPacketSize() {
        return APDU_PACKET_LENGTH;
    }

    public void setPIN(String string) {
        this.password = string;
    }

    public ResponseAPDU getFreeRAM() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 1);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getRandomBytes(int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        if (n > 119) {
            n = 119;
        }
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        this.capdu = new CommandAPDU(-48, -107, 1, 13, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getFirmwareVersionString() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 0);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getLastError() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 15);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getErrorReportingMode() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 9);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU setErrorReportingMode(int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        this.capdu = new CommandAPDU(-48, -107, 0, 9, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getAIDByNumber(int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.capdu = new CommandAPDU(-48, -107, 1, 14, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        if (this.rapdu.getSW() == 33875) {
            return this.rapdu;
        }
        int n2 = this.rapdu.getData().length;
        byArray = new byte[n2 + 4];
        System.arraycopy(this.rapdu.getData(), 0, byArray, 0, n2);
        byArray[n2] = this.rapdu.getSW1();
        byArray[n2 + 1] = this.rapdu.getSW2();
        byArray[n2 + 2] = -112;
        byArray[n2 + 3] = 0;
        return new ResponseAPDU(byArray);
    }

    public ResponseAPDU deleteSelectedApplet() throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[1 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
        } else {
            byArray = new byte[2];
            byArray[0] = 0;
        }
        this.capdu = new CommandAPDU(-48, -107, 3, 0, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU deleteAppletByNumber(int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        this.capdu = new CommandAPDU(-48, -107, 3, 1, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU deleteAppletByAID(String string) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length() + string.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)string.length();
            System.arraycopy(string.getBytes(), 0, byArray, this.password.length() + 2, string.length());
        } else {
            byArray = new byte[2 + string.length()];
            byArray[0] = 0;
            byArray[1] = (byte)string.length();
            System.arraycopy(string.getBytes(), 0, byArray, 2, string.length());
        }
        this.capdu = new CommandAPDU(-48, -107, 3, 2, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU loadApplet(String string, String string2, String string3) throws OneWireException, OneWireIOException, IllegalArgumentException, FileNotFoundException, IOException {
        File file = new File(string2, string);
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        long l2 = fileInputStream.available();
        byte[] byArray = new byte[26 + (int)l];
        if (this.password != null) {
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
        }
        int n = 0;
        while (n < 16) {
            if (n >= string3.length()) break;
            byArray[n + 10] = (byte)string3.charAt(n);
            ++n;
        }
        byArray[9] = 16;
        if (l <= l2) {
            fileInputStream.read(byArray, 26, (int)l);
        } else {
            long l3 = 0L;
            byte[] byArray2 = new byte[(int)l2];
            while (l3 < l) {
                fileInputStream.read(byArray2);
                System.arraycopy(byArray2, 0, byArray, (int)(l3 + 26L), byArray2.length);
                l3 += l2;
            }
        }
        fileInputStream.close();
        int n2 = 0;
        boolean bl = true;
        ResponseAPDU responseAPDU = null;
        byte[] byArray3 = new byte[APDU_PACKET_LENGTH];
        while ((long)n2 < l + 26L - (long)APDU_PACKET_LENGTH) {
            int n3 = 0;
            while (n3 < APDU_PACKET_LENGTH && n3 < byArray.length) {
                byArray3[n3] = byArray[n3 + n2];
                ++n3;
            }
            n2 += APDU_PACKET_LENGTH;
            if (bl) {
                this.capdu = new CommandAPDU(-48, -90, 1, 0, byArray3);
                bl = false;
            } else {
                this.capdu = new CommandAPDU(-48, -90, 2, 0, byArray3);
            }
            responseAPDU = this.sendAPDU(this.capdu, this.runTime);
            if ((long)n2 >= l + 26L || responseAPDU.getSW() == 25345) continue;
            n2 = (int)(l + 26L + 1L);
        }
        if ((long)n2 < l + 26L) {
            byArray3 = new byte[(int)(l + 26L - (long)n2)];
            int n4 = 0;
            while ((long)n4 < l + 26L - (long)n2) {
                byArray3[n4] = byArray[n4 + n2];
                ++n4;
            }
            if (bl) {
                this.capdu = new CommandAPDU(-48, -90, 1, 0, byArray3);
                bl = false;
            } else {
                this.capdu = new CommandAPDU(-48, -90, 2, 0, byArray3);
            }
            responseAPDU = this.sendAPDU(this.capdu, this.runTime);
        }
        return responseAPDU;
    }

    public ResponseAPDU masterErase() throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[1 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
        } else {
            byArray = new byte[]{0};
        }
        this.capdu = new CommandAPDU(-48, -107, 0, 0, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getPORCount() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 2, 0);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getRealTimeClock() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 12);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getATR() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 11);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getEphemeralGCMode() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 2);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getAppletGCMode() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 3);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getCommandPINMode() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 4);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getLoadPINMode() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 5);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getRestoreMode() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 6);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getExceptionMode() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 7);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU getCommitBufferSize() throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = new CommandAPDU(-48, -107, 1, 10);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU setCommonPIN(String string) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[string.length() + this.password.length() + 2];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)string.length();
            System.arraycopy(string.getBytes(), 0, byArray, this.password.length() + 2, string.length());
        } else {
            byArray = new byte[2 + string.length()];
            byArray[0] = 0;
            byArray[1] = (byte)string.length();
            System.arraycopy(string.getBytes(), 0, byArray, 2, string.length());
        }
        this.capdu = new CommandAPDU(-48, -107, 0, 1, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU setEphemeralGCMode(int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        this.capdu = new CommandAPDU(-48, -107, 0, 2, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU setAppletGCMode(int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        this.capdu = new CommandAPDU(-48, -107, 0, 3, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU setCommandPINMode(int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        this.capdu = new CommandAPDU(-48, -107, 0, 4, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU setLoadPINMode(int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        this.capdu = new CommandAPDU(-48, -107, 0, 5, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU setRestoreMode(int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        this.capdu = new CommandAPDU(-48, -107, 0, 6, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU setExceptionMode(int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[2 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)n;
        } else {
            byArray = new byte[]{0, (byte)n};
        }
        this.capdu = new CommandAPDU(-48, -107, 0, 7, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU setCommitBufferSize(int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        byte[] byArray;
        if (this.password != null) {
            byArray = new byte[3 + this.password.length()];
            byArray[0] = (byte)this.password.length();
            System.arraycopy(this.password.getBytes(), 0, byArray, 1, this.password.length());
            byArray[this.password.length() + 1] = (byte)(n & 0xFF);
            byArray[this.password.length() + 2] = (byte)(n >>> 8);
        } else {
            byArray = new byte[]{0, (byte)(n & 0xFF), (byte)(n >>> 8)};
        }
        this.capdu = new CommandAPDU(-48, -107, 0, 10, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU select(String string) throws OneWireException, OneWireIOException, IllegalArgumentException {
        if (string.length() > 16) {
            throw new IllegalArgumentException("AID length should not exceed 16");
        }
        byte[] byArray = new byte[16];
        System.arraycopy(string.getBytes(), 0, byArray, 0, string.length());
        this.capdu = new CommandAPDU(0, -92, 4, 0, byArray);
        this.rapdu = this.sendAPDU(this.capdu, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU process(CommandAPDU commandAPDU) throws OneWireException, OneWireIOException, IllegalArgumentException {
        this.capdu = commandAPDU;
        this.rapdu = this.sendAPDU(commandAPDU, this.runTime);
        return this.rapdu;
    }

    public ResponseAPDU sendAPDU(CommandAPDU commandAPDU, int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        if (n > 15 || n < 0) {
            throw new IllegalArgumentException("Run Time value should be between 0 and 15.");
        }
        int n2 = commandAPDU.getLength();
        byte[] byArray = new byte[n2 + 3];
        byArray[0] = (byte)(2 + n2);
        byArray[1] = -119;
        byArray[2] = 0;
        System.arraycopy(commandAPDU.getBytes(), 0, byArray, 3, n2);
        this.doSpeed();
        this.rapdu = new ResponseAPDU(this.jibComm.transferJibData(byArray, n));
        return this.rapdu;
    }
}

