/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.MemoryBankEPROM;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.SwitchContainer;
import com.dalsemi.onewire.utils.CRC16;
import java.util.Enumeration;
import java.util.Vector;

public class OneWireContainer12
extends OneWireContainer
implements SwitchContainer {
    public static final byte SOURCE_ACTIVITY_LATCH = 2;
    public static final byte SOURCE_FLIP_FLOP = 4;
    public static final byte SOURCE_PIO = 6;
    public static final byte POLARITY_ZERO = 0;
    public static final byte POLARITY_ONE = 1;
    public static final byte CHANNEL_NONE = 0;
    public static final byte DONT_CHANGE = -1;
    public static final byte CHANNEL_A_ONLY = 4;
    public static final byte CHANNEL_B_ONLY = 8;
    public static final byte CHANNEL_BOTH = 12;
    public static final byte CRC_DISABLE = 0;
    public static final byte CRC_EVERY_BYTE = 1;
    public static final byte CRC_EVERY_8_BYTES = 2;
    public static final byte CRC_EVERY_32_BYTES = 3;
    private static final byte WRITE_STATUS_COMMAND = 85;
    private static final byte CHANNEL_ACCESS_COMMAND = -11;
    private byte[] buffer = new byte[7];
    private boolean clearactivity = false;
    private boolean doSpeedEnable = true;

    public OneWireContainer12() {
    }

    public OneWireContainer12(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
    }

    public OneWireContainer12(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
    }

    public OneWireContainer12(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
    }

    public String getName() {
        return "DS2406";
    }

    public String getAlternateNames() {
        return "Dual Addressable Switch, DS2407";
    }

    public String getDescription() {
        return "1-Wire Dual Addressable Switch.  PIO pin channel A sink capability of typical 50mA at 0.4V with soft turn-on; optional channel B typical 10 mA at 0.4V.  1024 bits of Electrically Programmable Read Only Memory (EPROM) partitioned into four 256 bit pages.  7 bytes of user-programmable status memory to control the device.";
    }

    public Enumeration getMemoryBanks() {
        Vector<MemoryBankEPROM> vector = new Vector<MemoryBankEPROM>(2);
        MemoryBankEPROM memoryBankEPROM = new MemoryBankEPROM(this);
        memoryBankEPROM.numberPages = 4;
        memoryBankEPROM.size = 128;
        vector.addElement(memoryBankEPROM);
        MemoryBankEPROM memoryBankEPROM2 = new MemoryBankEPROM(this);
        memoryBankEPROM2.bankDescription = "Write protect pages, Page redirection, Switch control";
        memoryBankEPROM2.numberPages = 1;
        memoryBankEPROM2.size = 8;
        memoryBankEPROM2.pageLength = 8;
        memoryBankEPROM2.generalPurposeMemory = false;
        memoryBankEPROM2.extraInfo = false;
        memoryBankEPROM2.extraInfoLength = 0;
        memoryBankEPROM2.extraInfoDescription = null;
        memoryBankEPROM2.crcAfterAddress = false;
        memoryBankEPROM2.READ_PAGE_WITH_CRC = (byte)-86;
        memoryBankEPROM2.WRITE_MEMORY_COMMAND = (byte)85;
        vector.addElement(memoryBankEPROM2);
        memoryBankEPROM.mbLock = memoryBankEPROM2;
        memoryBankEPROM.lockPage = true;
        memoryBankEPROM.mbRedirect = memoryBankEPROM2;
        memoryBankEPROM.redirectOffset = 1;
        memoryBankEPROM.redirectPage = true;
        return vector.elements();
    }

    public boolean isPowerSupplied(byte[] byArray) {
        return (byArray[0] & 0x80) == 128;
    }

    public int getNumberChannels(byte[] byArray) {
        return (byArray[0] & 0x40) == 64 ? 2 : 1;
    }

    public boolean isHighSideSwitch() {
        return false;
    }

    public boolean hasActivitySensing() {
        return true;
    }

    public boolean hasLevelSensing() {
        return true;
    }

    public boolean hasSmartOn() {
        return false;
    }

    public boolean onlySingleChannelOn() {
        return false;
    }

    public boolean getLevel(int n, byte[] byArray) {
        if (n == 0) {
            return (byArray[0] & 4) == 4;
        }
        return (byArray[0] & 8) == 8;
    }

    public boolean getLatchState(int n, byte[] byArray) {
        if (n == 0) {
            return (byArray[1] & 0x20) != 32;
        }
        return (byArray[1] & 0x40) != 64;
    }

    public boolean getSensedActivity(int n, byte[] byArray) {
        if (n == 0) {
            return (byArray[0] & 0x10) == 16;
        }
        return (byArray[0] & 0x20) == 32;
    }

    public void clearActivity() {
        OneWireContainer12 oneWireContainer12 = this;
        synchronized (oneWireContainer12) {
            this.clearactivity = true;
        }
    }

    public void setLatchState(int n, boolean bl, boolean bl2, byte[] byArray) {
        if (n == 0) {
            byArray[1] = (byte)(byArray[1] & 0xFFFFFFDF);
            if (!bl) {
                byArray[1] = (byte)(byArray[1] | 0x20);
            }
        } else {
            byArray[1] = (byte)(byArray[1] & 0xFFFFFFBF);
            if (!bl) {
                byArray[1] = (byte)(byArray[1] | 0x40);
            }
        }
    }

    public byte[] readDevice() throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[2];
        OneWireContainer12 oneWireContainer12 = this;
        synchronized (oneWireContainer12) {
            if (this.doSpeedEnable) {
                this.doSpeed();
            }
            if (this.adapter.select(this.address)) {
                this.buffer[0] = -11;
                if (this.clearactivity) {
                    this.buffer[1] = -43;
                    this.clearactivity = false;
                } else {
                    this.buffer[1] = 85;
                }
                this.buffer[2] = -1;
                int n = 3;
                while (n < 7) {
                    this.buffer[n] = -1;
                    ++n;
                }
                this.adapter.dataBlock(this.buffer, 0, 7);
                if (CRC16.compute(this.buffer, 0, 7, 0) == 45057) {
                    byArray[0] = this.buffer[3];
                    this.buffer[0] = -86;
                    this.buffer[1] = 7;
                    this.buffer[2] = 0;
                    int n2 = 3;
                    while (n2 < 6) {
                        this.buffer[n2] = -1;
                        ++n2;
                    }
                    this.adapter.reset();
                    this.adapter.select(this.address);
                    this.adapter.dataBlock(this.buffer, 0, 6);
                    if (CRC16.compute(this.buffer, 0, 6, 0) == 45057) {
                        byArray[1] = this.buffer[3];
                        byte[] byArray2 = byArray;
                        return byArray2;
                    }
                }
            }
        }
        throw new OneWireIOException("OneWireContainer12-device not present");
    }

    public void writeDevice(byte[] byArray) throws OneWireIOException, OneWireException {
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        if (this.adapter.select(this.address)) {
            OneWireContainer12 oneWireContainer12 = this;
            synchronized (oneWireContainer12) {
                this.buffer[0] = 85;
                this.buffer[1] = 7;
                this.buffer[2] = 0;
                this.buffer[3] = byArray[1];
                this.buffer[4] = -1;
                this.buffer[5] = -1;
                this.adapter.dataBlock(this.buffer, 0, 6);
                if (CRC16.compute(this.buffer, 0, 6, 0) == 45057) {
                    return;
                }
            }
        }
        throw new OneWireException("OneWireContainer12-device not present");
    }

    public synchronized void setSpeedCheck(boolean bl) {
        this.doSpeedEnable = bl;
    }

    public void setSearchConditions(byte by, byte by2, byte by3, byte[] byArray) {
        byte by4 = 0;
        if (by != -1) {
            by4 = (byte)(by << 1);
        }
        if (by2 != -1) {
            by4 = (byte)(by4 | by2);
        }
        if (by3 != -1) {
            by4 = (byte)(by4 | by3);
        }
        byArray[1] = (byte)(byArray[1] & 0xE0);
        byArray[1] = (byte)(byArray[1] | by4);
    }

    public byte[] channelAccess(byte[] byArray, boolean bl, boolean bl2, int n, int n2, boolean bl3, boolean bl4) throws OneWireException, OneWireIOException {
        n &= 3;
        if ((n2 &= 0xC) == 0) {
            n2 = 4;
        }
        if (bl4 && n2 != 12) {
            bl4 = false;
        }
        if (this.doSpeedEnable) {
            this.doSpeed();
        }
        if (this.adapter.select(this.address)) {
            int n3 = byArray.length;
            if (bl) {
                n3 <<= 1;
            }
            switch (n) {
                case 1: {
                    n3 *= 3;
                    break;
                }
                case 2: {
                    n3 += n3 >> 3 << 1;
                    break;
                }
                case 3: {
                    n3 += n3 >> 5 << 1;
                }
            }
            byte[] byArray2 = new byte[n3 + 3 + 1];
            byArray2[0] = -11;
            int n4 = CRC16.compute(245);
            byArray2[1] = (byte)(n | n2 | (bl3 ? 128 : 0) | (bl4 ? 16 : 0) | (bl ? 32 : 0) | (bl2 ? 64 : 0));
            byArray2[2] = -1;
            n4 = CRC16.compute(byArray2, 1, 2, n4);
            int n5 = 3;
            while (n5 < byArray2.length) {
                byArray2[n5] = -1;
                ++n5;
            }
            int n6 = 4;
            int n7 = byArray2[1] & 0x63;
            if ((n7 = (n7 >> 3 | n7) & 0xF) < 8 || n7 > 11) {
                n5 = 0;
                while (n5 < byArray.length) {
                    if (n7 > 11) {
                        n6 += this.fixJ(n5 * 2 + 1, n7);
                    }
                    byArray2[n6] = byArray[n5];
                    if (n7 < 4) {
                        n6 += this.fixJ(n5 + 1, n7);
                    } else {
                        if (n7 < 8) {
                            n6 += this.fixJ(n5 * 2 + 1, n7);
                        }
                        n6 += this.fixJ(n5 * 2 + 2, n7);
                    }
                    ++n5;
                }
            }
            this.adapter.dataBlock(byArray2, 0, byArray2.length);
            n4 = CRC16.compute(byArray2[3], n4);
            n6 = 0;
            int n8 = 0;
            boolean bl5 = false;
            byte[] byArray3 = new byte[byArray.length];
            n5 = 4;
            while (n5 < byArray2.length) {
                if (n != 0) {
                    if (bl5) {
                        n4 = CRC16.compute(byArray2[n5]);
                        bl5 = false;
                    } else {
                        n4 = CRC16.compute(byArray2[n5], n4);
                    }
                }
                if (!bl && bl2 || bl && bl2 && (n6 & 1) == 0 || bl && !bl2 && (n6 & 1) == 1) {
                    byArray3[n8] = byArray2[n5];
                    ++n8;
                }
                if (this.fixJ(++n6, n7) > 1 && n != 0) {
                    n4 = CRC16.compute(byArray2, n5 + 1, 2, n4);
                    n5 += 2;
                    if (n4 != 45057) {
                        throw new OneWireIOException("Invalid CRC");
                    }
                    bl5 = true;
                }
                ++n5;
            }
            return byArray3;
        }
        throw new OneWireIOException("OneWireContainer12-device not present");
    }

    private int fixJ(int n, int n2) {
        switch (n2 & 3) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
        }
        if ((n & 8 + 24 * (n2 & 1) - 1) == 0) {
            return 3;
        }
        return 1;
    }
}

