/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.TemperatureContainer;
import com.dalsemi.onewire.utils.CRC8;

public class OneWireContainer10
extends OneWireContainer
implements TemperatureContainer {
    private boolean normalResolution = true;
    public static final double RESOLUTION_NORMAL = 0.5;
    public static final double RESOLUTION_MAXIMUM = 0.1;
    private static final byte CONVERT_TEMPERATURE_COMMAND = 68;
    private static final byte READ_SCRATCHPAD_COMMAND = -66;
    private static final byte WRITE_SCRATCHPAD_COMMAND = 78;
    private static final byte COPY_SCRATCHPAD_COMMAND = 72;
    private static final byte RECALL_EEPROM_COMMAND = -72;

    public OneWireContainer10() {
    }

    public OneWireContainer10(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
    }

    public OneWireContainer10(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
    }

    public OneWireContainer10(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
    }

    public String getName() {
        return "DS1920";
    }

    public String getAlternateNames() {
        return "DS1820";
    }

    public String getDescription() {
        return "Digital thermometer measures temperatures from -55C to 100C in typically 0.2 seconds.  +/- 0.5C Accuracy between 0C and 70C. 0.5C standard resolution, higher resolution through interpolation.Contains high and low temperature set points forgeneration of alarm.";
    }

    public boolean hasTemperatureAlarms() {
        return true;
    }

    public boolean hasSelectableTemperatureResolution() {
        return true;
    }

    public double[] getTemperatureResolutions() {
        double[] dArray = new double[]{0.5, 0.1};
        return dArray;
    }

    public double getTemperatureAlarmResolution() {
        return 1.0;
    }

    public double getMaxTemperature() {
        return 100.0;
    }

    public double getMinTemperature() {
        return -55.0;
    }

    public void doTemperatureConvert(byte[] byArray) throws OneWireIOException, OneWireException {
        this.doSpeed();
        if (this.adapter.select(this.address)) {
            this.adapter.setPowerDuration(5);
            this.adapter.startPowerDelivery(2);
            this.adapter.putByte(68);
            try {
                Thread.sleep(750L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.adapter.setPowerNormal();
            if (this.adapter.getByte() != 255) {
                throw new OneWireIOException("OneWireContainer10-temperature conversion not complete");
            }
        } else {
            throw new OneWireIOException("OneWireContainer10-device not present");
        }
        byte by = byArray[4];
        this.adapter.select(this.address);
        this.readScratch(byArray);
        byArray[4] = by;
    }

    public double getTemperature(byte[] byArray) throws OneWireIOException {
        if ((byArray[1] & 0xFF) != 0 && (byArray[1] & 0xFF) != 255) {
            throw new OneWireIOException("Invalid temperature data!");
        }
        short s = (short)(byArray[0] & 0xFF | byArray[1] << 8);
        if (byArray[4] == 1) {
            s = (short)(s >> 1);
            double d = s;
            double d2 = byArray[6] & 0xFF;
            double d3 = byArray[7] & 0xFF;
            d = d - 0.25 + (d3 - d2) / d3;
            return d;
        }
        return (double)s / 2.0;
    }

    public double getTemperatureAlarm(int n, byte[] byArray) {
        return byArray[n == 0 ? 3 : 2];
    }

    public double getTemperatureResolution(byte[] byArray) {
        if (byArray[4] == 0) {
            return 0.5;
        }
        return 0.1;
    }

    public void setTemperatureAlarm(int n, double d, byte[] byArray) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid alarm type.");
        }
        if (d > 100.0 || d < -55.0) {
            throw new IllegalArgumentException("Value for alarm not in accepted range.  Must be -55 C <-> +100 C.");
        }
        byArray[n == 0 ? 3 : 2] = (byte)d;
    }

    public void setTemperatureResolution(double d, byte[] byArray) {
        OneWireContainer10 oneWireContainer10 = this;
        synchronized (oneWireContainer10) {
            this.normalResolution = d == 0.5;
            byArray[4] = this.normalResolution ? (byte)0 : 1;
        }
    }

    public byte[] readDevice() throws OneWireIOException, OneWireException {
        byte[] byArray;
        byte[] byArray2 = new byte[8];
        this.doSpeed();
        if (this.adapter.select(this.address)) {
            byArray = new byte[10];
            byArray[0] = -66;
            int n = 1;
            while (n < 10) {
                byArray[n] = -1;
                ++n;
            }
            this.adapter.dataBlock(byArray, 0, byArray.length);
            if (CRC8.compute(byArray, 1, 9) != 0) {
                throw new OneWireIOException("OneWireContainer10-Error reading CRC8 from device.");
            }
        } else {
            throw new OneWireIOException("OneWireContainer10-Device not found on 1-Wire Network");
        }
        System.arraycopy(byArray, 1, byArray2, 0, 8);
        byArray2[4] = this.normalResolution ? (byte)0 : 1;
        return byArray2;
    }

    public void writeDevice(byte[] byArray) throws OneWireIOException, OneWireException {
        this.doSpeed();
        byte[] byArray2 = new byte[]{byArray[2], byArray[3]};
        this.writeScratchpad(byArray2);
        this.copyScratchpad();
    }

    public static double convertToFahrenheit(double d) {
        return d * 9.0 / 5.0 + 32.0;
    }

    public static double convertToCelsius(double d) {
        return (d - 32.0) * 5.0 / 9.0;
    }

    private void readScratch(byte[] byArray) throws OneWireIOException, OneWireException {
        byte[] byArray2;
        if (this.adapter.select(this.address)) {
            byArray2 = new byte[10];
            byArray2[0] = -66;
            int n = 1;
            while (n < 10) {
                byArray2[n] = -1;
                ++n;
            }
            this.adapter.dataBlock(byArray2, 0, byArray2.length);
            if (CRC8.compute(byArray2, 1, 9) != 0) {
                throw new OneWireIOException("OneWireContainer10-Error reading CRC8 from device.");
            }
        } else {
            throw new OneWireIOException("OneWireContainer10-Device not found on 1-Wire Network");
        }
        System.arraycopy(byArray2, 1, byArray, 0, 8);
    }

    private void writeScratchpad(byte[] byArray) throws OneWireIOException, OneWireException, IllegalArgumentException {
        byte[] byArray2 = new byte[3];
        byte[] byArray3 = new byte[8];
        if (byArray.length != 2) {
            throw new IllegalArgumentException("Bad data.  Data must consist of only TWO bytes.");
        }
        byArray2[0] = 78;
        byArray2[1] = byArray[0];
        byArray2[2] = byArray[1];
        if (!this.adapter.select(this.address)) {
            throw new OneWireIOException("OneWireContainer10 - Device not found");
        }
        this.adapter.dataBlock(byArray2, 0, 3);
        byArray3 = new byte[8];
        this.readScratch(byArray3);
        if (byArray3[2] != byArray[0] || byArray3[3] != byArray[1]) {
            throw new OneWireIOException("OneWireContainer10 - data read back incorrect");
        }
    }

    private void copyScratchpad() throws OneWireIOException, OneWireException {
        if (this.adapter.select(this.address)) {
            this.adapter.putByte(72);
            this.adapter.setPowerDuration(5);
            this.adapter.startPowerDelivery(0);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } else {
            throw new OneWireIOException("OneWireContainer10 - device not found");
        }
        this.adapter.setPowerNormal();
    }
}

