/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.SwitchContainer;

public class OneWireContainer05
extends OneWireContainer
implements SwitchContainer {
    public OneWireContainer05() {
    }

    public OneWireContainer05(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
    }

    public OneWireContainer05(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
    }

    public OneWireContainer05(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
    }

    public String getName() {
        return "DS2405";
    }

    public String getAlternateNames() {
        return "Addressable Switch";
    }

    public String getDescription() {
        return "Addressable Switch with controlled open drain PIO pin. PIO pin sink capability is greater than 4mA at 0.4V.";
    }

    public int getNumberChannels(byte[] byArray) {
        return 1;
    }

    public boolean isHighSideSwitch() {
        return false;
    }

    public boolean hasActivitySensing() {
        return false;
    }

    public boolean hasLevelSensing() {
        return true;
    }

    public boolean hasSmartOn() {
        return false;
    }

    public boolean onlySingleChannelOn() {
        return true;
    }

    public boolean getLevel(int n, byte[] byArray) {
        return (byArray[0] & 2) == 2;
    }

    public boolean getLatchState(int n, byte[] byArray) {
        return (byArray[0] & 1) == 1;
    }

    public boolean getSensedActivity(int n, byte[] byArray) throws OneWireException {
        throw new OneWireException("Sense Activity not supported");
    }

    public void clearActivity() throws OneWireException {
        throw new OneWireException("Sense Activity not supported");
    }

    public void setLatchState(int n, boolean bl, boolean bl2, byte[] byArray) {
        byArray[0] = bl ? (byte)(byArray[0] | 1) : (byte)(byArray[0] & 0xFE);
    }

    public byte[] readDevice() throws OneWireIOException, OneWireException {
        this.doSpeed();
        byte[] byArray = new byte[]{0};
        if (this.isPresent()) {
            if (this.isAlarming()) {
                byArray[0] = 1;
            }
        } else {
            throw new OneWireIOException("Device not present");
        }
        if (this.isPresent()) {
            if (this.adapter.getByte() != 0) {
                byArray[0] = (byte)(byArray[0] | 2);
            }
        } else {
            throw new OneWireIOException("Device not present");
        }
        return byArray;
    }

    public void writeDevice(byte[] byArray) throws OneWireIOException, OneWireException {
        this.doSpeed();
        boolean bl = (byArray[0] & 1) == 1;
        boolean bl2 = this.isAlarming();
        if (bl2 == bl) {
            return;
        }
        if (this.adapter.select(this.address) && (bl2 = this.isAlarming()) == bl) {
            return;
        }
        throw new OneWireIOException("Failure to change DS2405 latch state");
    }
}

