/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.ClockContainer;
import com.dalsemi.onewire.container.MemoryBankNV;
import com.dalsemi.onewire.container.MemoryBankScratch;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.utils.Bit;
import java.util.Enumeration;
import java.util.Vector;

public class OneWireContainer04
extends OneWireContainer
implements ClockContainer {
    protected static final int BITMAP_OFFSET = 32;
    protected static final int STATUS_OFFSET = 0;
    protected static final int CONTROL_OFFSET = 1;
    protected static final int RTC_OFFSET = 2;
    protected static final int INTERVAL_OFFSET = 7;
    protected static final int COUNTER_OFFSET = 12;
    protected static final int RTC_ALARM_OFFSET = 16;
    protected static final int INTERVAL_ALARM_OFFSET = 21;
    protected static final int COUNTER_ALARM_OFFSET = 26;
    private MemoryBankScratch scratch;
    private MemoryBankNV clock;

    public OneWireContainer04() {
        this.initClock();
    }

    public OneWireContainer04(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
        this.initClock();
    }

    public OneWireContainer04(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
        this.initClock();
    }

    public OneWireContainer04(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
        this.initClock();
    }

    public String getName() {
        return "DS1994";
    }

    public String getAlternateNames() {
        return "DS2404, Time-in-a-can, DS1427";
    }

    public String getDescription() {
        return "4096 bit read/write nonvolatile memory partitioned into sixteen pages of 256 bits each and a real time clock/calendar in binary format.";
    }

    public Enumeration getMemoryBanks() {
        Vector<PagedMemoryBank> vector = new Vector<PagedMemoryBank>(3);
        vector.addElement(this.scratch);
        vector.addElement(new MemoryBankNV(this, this.scratch));
        vector.addElement(this.clock);
        return vector.elements();
    }

    public boolean hasClockAlarm() {
        return true;
    }

    public boolean canDisableClock() {
        return true;
    }

    public long getClockResolution() {
        return 4L;
    }

    public byte[] readDevice() throws OneWireIOException, OneWireException {
        byte[][] byArray = new byte[2][36];
        int n = 0;
        int n2 = 0;
        int n3 = 32;
        while (n3 < 36) {
            byArray[0][n3] = 0;
            byArray[1][n3] = 0;
            ++n3;
        }
        boolean bl = this.isAlarming();
        do {
            if (bl && n2 != 0) {
                this.clock.read(1, false, byArray[n], 1, 31);
            } else {
                this.clock.read(0, false, byArray[n], 0, 32);
            }
            if (n2++ != 0) {
                n3 = 1;
                while (n3 < 32) {
                    if (n3 != 2 && n3 != 7 && byArray[0][n3] != byArray[1][n3]) break;
                    ++n3;
                }
                if (n3 == 32) {
                    return byArray[n];
                }
            }
            int n4 = n = n == 0 ? 1 : 0;
        } while (n2 < 5);
        throw new OneWireIOException("Failed to read the clock register page");
    }

    public void writeDevice(byte[] byArray) throws OneWireIOException, OneWireException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (n3 < 32) {
            if (Bit.arrayReadBit(n3, 32, byArray) == 1 && n3 != 1) {
                if (bl) {
                    ++n2;
                } else {
                    bl = true;
                    n = n3;
                    n2 = 1;
                }
                if (n3 == 31) {
                    this.clock.write(n, byArray, n, n2);
                }
            } else if (bl) {
                this.clock.write(n, byArray, n, n2);
                bl = false;
            }
            ++n3;
        }
        if (Bit.arrayReadBit(1, 32, byArray) == 1) {
            this.clock.write(1, byArray, 1, 1);
            if ((byArray[1] & 7) != 0) {
                n3 = 0;
                while (n3 < 2) {
                    this.scratch.writeScratchpad(this.clock.getStartPhysicalAddress() + 1, byArray, 1, 1);
                    ++n3;
                }
            }
        }
        n3 = 32;
        while (n3 < byArray.length) {
            byArray[n3] = 0;
            ++n3;
        }
    }

    public long getClock(byte[] byArray) {
        return OneWireContainer04.byteArrayToLong(byArray, 2, 5) * 1000L / 256L;
    }

    public long getClockAlarm(byte[] byArray) throws OneWireException {
        return OneWireContainer04.byteArrayToLong(byArray, 16, 5) * 1000L / 256L;
    }

    public boolean isClockAlarming(byte[] byArray) {
        return Bit.arrayReadBit(0, 0, byArray) == 1;
    }

    public boolean isClockAlarmEnabled(byte[] byArray) {
        return Bit.arrayReadBit(3, 0, byArray) == 0;
    }

    public boolean isClockRunning(byte[] byArray) {
        return Bit.arrayReadBit(4, 1, byArray) == 1;
    }

    public long getIntervalTimer(byte[] byArray) {
        return OneWireContainer04.byteArrayToLong(byArray, 7, 5) * 1000L / 256L;
    }

    public long getCycleCounter(byte[] byArray) {
        return OneWireContainer04.byteArrayToLong(byArray, 12, 4);
    }

    public long getIntervalTimerAlarm(byte[] byArray) {
        return OneWireContainer04.byteArrayToLong(byArray, 21, 5) * 1000L / 256L;
    }

    public long getCycleCounterAlarm(byte[] byArray) {
        return OneWireContainer04.byteArrayToLong(byArray, 26, 4);
    }

    public boolean isIntervalTimerAlarming(byte[] byArray) {
        return Bit.arrayReadBit(1, 0, byArray) == 1;
    }

    public boolean isCycleCounterAlarming(byte[] byArray) {
        return Bit.arrayReadBit(2, 0, byArray) == 1;
    }

    public boolean isIntervalTimerAlarmEnabled(byte[] byArray) {
        return Bit.arrayReadBit(4, 0, byArray) == 0;
    }

    public boolean isCycleCounterAlarmEnabled(byte[] byArray) {
        return Bit.arrayReadBit(5, 0, byArray) == 0;
    }

    public boolean isClockWriteProtected(byte[] byArray) {
        return Bit.arrayReadBit(0, 1, byArray) == 1;
    }

    public boolean isIntervalTimerWriteProtected(byte[] byArray) {
        return Bit.arrayReadBit(1, 1, byArray) == 1;
    }

    public boolean isCycleCounterWriteProtected(byte[] byArray) {
        return Bit.arrayReadBit(2, 1, byArray) == 1;
    }

    public boolean canReadAfterExpire(byte[] byArray) {
        return Bit.arrayReadBit(3, 1, byArray) == 1;
    }

    public boolean isIntervalTimerAutomatic(byte[] byArray) {
        return Bit.arrayReadBit(5, 1, byArray) == 1;
    }

    public boolean isIntervalTimerStopped(byte[] byArray) {
        return Bit.arrayReadBit(6, 1, byArray) == 1;
    }

    public boolean isAutomaticDelayLong(byte[] byArray) {
        return Bit.arrayReadBit(7, 1, byArray) == 1;
    }

    public void setClock(long l, byte[] byArray) {
        OneWireContainer04.longToByteArray(byArray, 2, 5, l * 256L / 1000L);
        int n = 0;
        while (n < 5) {
            Bit.arrayWriteBit(1, 2 + n, 32, byArray);
            ++n;
        }
    }

    public void setClockAlarm(long l, byte[] byArray) throws OneWireException {
        OneWireContainer04.longToByteArray(byArray, 16, 5, l * 256L / 1000L);
        int n = 0;
        while (n < 5) {
            Bit.arrayWriteBit(1, 16 + n, 32, byArray);
            ++n;
        }
    }

    public void setClockRunEnable(boolean bl, byte[] byArray) throws OneWireException {
        Bit.arrayWriteBit(bl ? 1 : 0, 4, 1, byArray);
        Bit.arrayWriteBit(1, 1, 32, byArray);
    }

    public void setClockAlarmEnable(boolean bl, byte[] byArray) throws OneWireException {
        Bit.arrayWriteBit(bl ? 0 : 1, 3, 0, byArray);
        Bit.arrayWriteBit(1, 0, 32, byArray);
    }

    public void setIntervalTimer(long l, byte[] byArray) {
        OneWireContainer04.longToByteArray(byArray, 7, 5, l * 256L / 1000L);
        int n = 0;
        while (n < 5) {
            Bit.arrayWriteBit(1, 7 + n, 32, byArray);
            ++n;
        }
    }

    public void setCycleCounter(long l, byte[] byArray) {
        OneWireContainer04.longToByteArray(byArray, 12, 4, l);
        int n = 0;
        while (n < 4) {
            Bit.arrayWriteBit(1, 12 + n, 32, byArray);
            ++n;
        }
    }

    public void setIntervalTimerAlarm(long l, byte[] byArray) {
        OneWireContainer04.longToByteArray(byArray, 21, 5, l * 256L / 1000L);
        int n = 0;
        while (n < 5) {
            Bit.arrayWriteBit(1, 21 + n, 32, byArray);
            ++n;
        }
    }

    public void setCycleCounterAlarm(long l, byte[] byArray) {
        OneWireContainer04.longToByteArray(byArray, 26, 4, l);
        int n = 0;
        while (n < 4) {
            Bit.arrayWriteBit(1, 26 + n, 32, byArray);
            ++n;
        }
    }

    public void writeProtectClock(byte[] byArray) {
        Bit.arrayWriteBit(1, 0, 1, byArray);
        Bit.arrayWriteBit(1, 1, 32, byArray);
    }

    public void writeProtectIntervalTimer(byte[] byArray) {
        Bit.arrayWriteBit(1, 1, 1, byArray);
        Bit.arrayWriteBit(1, 1, 32, byArray);
    }

    public void writeProtectCycleCounter(byte[] byArray) {
        Bit.arrayWriteBit(1, 2, 1, byArray);
        Bit.arrayWriteBit(1, 1, 32, byArray);
    }

    public void setReadAfterExpire(boolean bl, byte[] byArray) {
        Bit.arrayWriteBit(bl ? 1 : 0, 3, 1, byArray);
        Bit.arrayWriteBit(1, 1, 32, byArray);
    }

    public void setIntervalTimerAutomatic(boolean bl, byte[] byArray) {
        Bit.arrayWriteBit(bl ? 1 : 0, 5, 1, byArray);
        Bit.arrayWriteBit(1, 1, 32, byArray);
    }

    public void setIntervalTimerRunState(boolean bl, byte[] byArray) {
        Bit.arrayWriteBit(bl ? 1 : 0, 6, 1, byArray);
        Bit.arrayWriteBit(1, 1, 32, byArray);
    }

    public void setAutomaticDelayLong(boolean bl, byte[] byArray) {
        Bit.arrayWriteBit(bl ? 1 : 0, 7, 1, byArray);
        Bit.arrayWriteBit(1, 1, 32, byArray);
    }

    public void setIntervalTimerAlarmEnable(boolean bl, byte[] byArray) {
        Bit.arrayWriteBit(bl ? 0 : 1, 4, 0, byArray);
        Bit.arrayWriteBit(1, 0, 32, byArray);
    }

    public void setCycleCounterAlarmEnable(boolean bl, byte[] byArray) {
        Bit.arrayWriteBit(bl ? 0 : 1, 5, 0, byArray);
        Bit.arrayWriteBit(1, 0, 32, byArray);
    }

    private void initClock() {
        this.scratch = new MemoryBankScratch(this);
        this.clock = new MemoryBankNV(this, this.scratch);
        this.clock.numberPages = 1;
        this.clock.startPhysicalAddress = 512;
        this.clock.size = 32;
        this.clock.generalPurposeMemory = false;
        this.clock.maxPacketDataLength = 0;
        this.clock.bankDescription = "Clock/alarm registers";
    }

    private static long byteArrayToLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            l <<= 8;
            l |= (long)(byArray[n + n3] & 0xFF);
            --n3;
        }
        return l;
    }

    private static void longToByteArray(byte[] byArray, int n, int n2, long l) throws IllegalArgumentException {
        int n3 = 0;
        while (n3 < n2) {
            byArray[n + n3] = (byte)l;
            l >>>= 8;
            ++n3;
        }
        if (l > 0L) {
            throw new IllegalArgumentException("Argument is larger then " + n2 + " bytes");
        }
    }
}

