/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;

public class OneWireContainer02
extends OneWireContainer {
    private static final byte WRITE_SCRATCHPAD_COMMAND = -106;
    private static final byte READ_SCRATCHPAD_COMMAND = 105;
    private static final byte COPY_SCRATCHPAD_COMMAND = 60;
    private static final byte WRITE_PASSWORD_COMMAND = 90;
    private static final byte WRITE_SUBKEY_COMMAND = -103;
    private static final byte READ_SUBKEY_COMMAND = 102;
    private static byte[][] blockCodes = null;
    private byte[] buffer = new byte[82];

    public OneWireContainer02() {
    }

    public OneWireContainer02(DSPortAdapter dSPortAdapter, byte[] byArray) {
        super(dSPortAdapter, byArray);
    }

    public OneWireContainer02(DSPortAdapter dSPortAdapter, long l) {
        super(dSPortAdapter, l);
    }

    public OneWireContainer02(DSPortAdapter dSPortAdapter, String string) {
        super(dSPortAdapter, string);
    }

    public String getName() {
        return "DS1991";
    }

    public String getAlternateNames() {
        return "DS1425";
    }

    public String getDescription() {
        return "2048 bits of nonvolatile read/write memory organized as three secure keys of 384 bits each and a 512 bit scratch pad. Each key has its own 64 bit password and 64 bit ID field.  Secure memory cannot be deciphered without matching 64 bit password.";
    }

    public void writeScratchpad(int n, byte[] byArray) throws OneWireIOException, OneWireException, IllegalArgumentException {
        if (n > 63) {
            throw new IllegalArgumentException("Address out of range: 0x00 to 0x3F");
        }
        int n2 = 63 - n + 1;
        if (n2 < byArray.length) {
            throw new IllegalArgumentException("Data is too long for scratchpad.");
        }
        this.buffer[0] = -106;
        this.buffer[1] = (byte)(n | 0xC0);
        this.buffer[2] = ~this.buffer[1];
        System.arraycopy(byArray, 0, this.buffer, 3, byArray.length);
        if (!this.adapter.select(this.address)) {
            throw new OneWireIOException("MultiKey iButton " + this.getAddressAsString() + " not found on 1-Wire Network");
        }
        this.adapter.dataBlock(this.buffer, 0, 3 + byArray.length);
    }

    public byte[] readScratchpad() throws OneWireIOException, OneWireException {
        this.buffer[0] = 105;
        this.buffer[1] = -64;
        this.buffer[2] = 63;
        int n = 3;
        while (n < 67) {
            this.buffer[n] = -1;
            ++n;
        }
        if (this.adapter.select(this.address)) {
            this.adapter.dataBlock(this.buffer, 0, 67);
            byte[] byArray = new byte[64];
            System.arraycopy(this.buffer, 3, byArray, 0, 64);
            return byArray;
        }
        throw new OneWireIOException("MultiKey iButton " + this.getAddressAsString() + " not found on 1-Wire Network");
    }

    public void copyScratchpad(int n, byte[] byArray, int n2) throws OneWireIOException, OneWireException, IllegalArgumentException {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Key out of range: 0 to 2.");
        }
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Password must contain exactly 8 characters");
        }
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("Block id out of range: 0 to 8.");
        }
        this.buffer[0] = 60;
        this.buffer[1] = (byte)(n << 6);
        this.buffer[2] = ~this.buffer[1];
        System.arraycopy(blockCodes[n2], 0, this.buffer, 3, 8);
        System.arraycopy(byArray, 0, this.buffer, 11, 8);
        if (!this.adapter.select(this.address)) {
            throw new OneWireIOException("MultiKey iButton " + this.getAddressAsString() + " not found on 1-Wire Network");
        }
        this.adapter.dataBlock(this.buffer, 0, 19);
    }

    public byte[] readSubkey(int n, byte[] byArray) throws OneWireIOException, OneWireException, IllegalArgumentException {
        byte[] byArray2 = new byte[64];
        this.readSubkey(byArray2, n, byArray);
        return byArray2;
    }

    public void readSubkey(byte[] byArray, int n, byte[] byArray2) throws OneWireIOException, OneWireException, IllegalArgumentException {
        if (n > 3) {
            throw new IllegalArgumentException("Key out of range: 0 to 2.");
        }
        if (byArray2.length != 8) {
            throw new IllegalArgumentException("Password must contain exactly 8 characters.");
        }
        if (byArray.length != 64) {
            throw new IllegalArgumentException("Data must be size 64.");
        }
        this.buffer[0] = 102;
        this.buffer[1] = (byte)(n << 6 | 0x10);
        this.buffer[2] = ~this.buffer[1];
        int n2 = 3;
        while (n2 < 67) {
            this.buffer[n2] = -1;
            ++n2;
        }
        System.arraycopy(byArray2, 0, this.buffer, 11, 8);
        if (!this.adapter.select(this.address)) {
            throw new OneWireIOException("MultiKey iButton " + this.getAddressAsString() + " not found on 1-Wire Network");
        }
        this.adapter.dataBlock(this.buffer, 0, 67);
        this.adapter.reset();
        System.arraycopy(this.buffer, 3, byArray, 0, 64);
    }

    public void writePassword(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws OneWireIOException, OneWireException, IllegalArgumentException {
        if (n > 3) {
            throw new IllegalArgumentException("Key value out of range: 0 to 2.");
        }
        if (byArray3.length != 8) {
            throw new IllegalArgumentException("Password must contain exactly 8 characters.");
        }
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Old name must contain exactly 8 characters.");
        }
        if (byArray2.length != 8) {
            throw new IllegalArgumentException("New name must contain exactly 8 characters.");
        }
        this.buffer[0] = 90;
        this.buffer[1] = (byte)(n << 6);
        this.buffer[2] = ~this.buffer[1];
        int n2 = 3;
        while (n2 < 11) {
            this.buffer[n2] = -1;
            ++n2;
        }
        System.arraycopy(byArray, 0, this.buffer, 11, 8);
        System.arraycopy(byArray2, 0, this.buffer, 19, 8);
        System.arraycopy(byArray3, 0, this.buffer, 27, 8);
        if (!this.adapter.select(this.address)) {
            throw new OneWireIOException("MultiKey iButton " + this.getAddressAsString() + " not found on 1-Wire Network");
        }
        this.adapter.dataBlock(this.buffer, 0, 35);
        this.adapter.reset();
    }

    public void writeSubkey(int n, int n2, byte[] byArray, byte[] byArray2) throws OneWireIOException, OneWireException, IllegalArgumentException {
        if (n > 3) {
            throw new IllegalArgumentException("Key out of range: 0 to 2.");
        }
        if (n2 < 0 || n2 > 63) {
            throw new IllegalArgumentException("Address must be between 0x00 and 0x3F");
        }
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Password must contain exactly 8 characters.");
        }
        if (byArray2.length > 63 - n2 + 1) {
            throw new IllegalArgumentException("Data length out of bounds.");
        }
        this.buffer[0] = -103;
        this.buffer[1] = (byte)(n << 6 | n2);
        this.buffer[2] = ~this.buffer[1];
        int n3 = 3;
        while (n3 < 11) {
            this.buffer[n3] = -1;
            ++n3;
        }
        System.arraycopy(byArray, 0, this.buffer, 11, 8);
        System.arraycopy(byArray2, 0, this.buffer, 19, byArray2.length);
        if (!this.adapter.select(this.address)) {
            throw new OneWireIOException("MultiKey iButton " + this.getAddressAsString() + " not found on 1-Wire Network");
        }
        this.adapter.dataBlock(this.buffer, 0, 19 + byArray2.length);
        this.adapter.reset();
    }

    private static void initBlockCodes(byte[][] byArray) {
        byArray[8][0] = 86;
        byArray[8][1] = 86;
        byArray[8][2] = 127;
        byArray[8][3] = 81;
        byArray[8][4] = 87;
        byArray[8][5] = 93;
        byArray[8][6] = 90;
        byArray[8][7] = 127;
        byArray[0][0] = -102;
        byArray[0][1] = -102;
        byArray[0][2] = -77;
        byArray[0][3] = -99;
        byArray[0][4] = 100;
        byArray[0][5] = 110;
        byArray[0][6] = 105;
        byArray[0][7] = 76;
        byArray[1][0] = -102;
        byArray[1][1] = -102;
        byArray[1][2] = 76;
        byArray[1][3] = 98;
        byArray[1][4] = -101;
        byArray[1][5] = -111;
        byArray[1][6] = 105;
        byArray[1][7] = 76;
        byArray[2][0] = -102;
        byArray[2][1] = 101;
        byArray[2][2] = -77;
        byArray[2][3] = 98;
        byArray[2][4] = -101;
        byArray[2][5] = 110;
        byArray[2][6] = -106;
        byArray[2][7] = 76;
        byArray[3][0] = 106;
        byArray[3][1] = 106;
        byArray[3][2] = 67;
        byArray[3][3] = 109;
        byArray[3][4] = 107;
        byArray[3][5] = 97;
        byArray[3][6] = 102;
        byArray[3][7] = 67;
        byArray[4][0] = -107;
        byArray[4][1] = -107;
        byArray[4][2] = -68;
        byArray[4][3] = -110;
        byArray[4][4] = -108;
        byArray[4][5] = -98;
        byArray[4][6] = -103;
        byArray[4][7] = -68;
        byArray[5][0] = 101;
        byArray[5][1] = -102;
        byArray[5][2] = 76;
        byArray[5][3] = -99;
        byArray[5][4] = 100;
        byArray[5][5] = -111;
        byArray[5][6] = 105;
        byArray[5][7] = -77;
        byArray[6][0] = 101;
        byArray[6][1] = 101;
        byArray[6][2] = -77;
        byArray[6][3] = -99;
        byArray[6][4] = 100;
        byArray[6][5] = 110;
        byArray[6][6] = -106;
        byArray[6][7] = -77;
        byArray[7][0] = 101;
        byArray[7][1] = 101;
        byArray[7][2] = 76;
        byArray[7][3] = 98;
        byArray[7][4] = -101;
        byArray[7][5] = -111;
        byArray[7][6] = -106;
        byArray[7][7] = -77;
    }

    static {
        blockCodes = new byte[9][8];
        OneWireContainer02.initBlockCodes(blockCodes);
    }
}

