/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.utils.Address;
import java.util.Enumeration;
import java.util.Vector;

public class OneWireContainer {
    protected DSPortAdapter adapter;
    protected byte[] address;
    private byte[] addressCopy;
    protected int speed;
    protected boolean speedFallBackOK;

    public OneWireContainer() {
    }

    public OneWireContainer(DSPortAdapter dSPortAdapter, byte[] byArray) {
        this.setupContainer(dSPortAdapter, byArray);
    }

    public OneWireContainer(DSPortAdapter dSPortAdapter, long l) {
        this.setupContainer(dSPortAdapter, l);
    }

    public OneWireContainer(DSPortAdapter dSPortAdapter, String string) {
        this.setupContainer(dSPortAdapter, string);
    }

    public void setupContainer(DSPortAdapter dSPortAdapter, byte[] byArray) {
        this.adapter = dSPortAdapter;
        OneWireContainer oneWireContainer = this;
        synchronized (oneWireContainer) {
            this.address = new byte[8];
            this.addressCopy = new byte[8];
            System.arraycopy(byArray, 0, this.address, 0, 8);
        }
        this.speed = 0;
        this.speedFallBackOK = false;
    }

    public void setupContainer(DSPortAdapter dSPortAdapter, long l) {
        this.adapter = dSPortAdapter;
        OneWireContainer oneWireContainer = this;
        synchronized (oneWireContainer) {
            this.address = Address.toByteArray(l);
            this.addressCopy = new byte[8];
        }
        this.speed = 0;
        this.speedFallBackOK = false;
    }

    public void setupContainer(DSPortAdapter dSPortAdapter, String string) {
        this.adapter = dSPortAdapter;
        OneWireContainer oneWireContainer = this;
        synchronized (oneWireContainer) {
            this.address = Address.toByteArray(string);
            this.addressCopy = new byte[8];
        }
        this.speed = 0;
        this.speedFallBackOK = false;
    }

    public DSPortAdapter getAdapter() {
        return this.adapter;
    }

    public String getName() {
        OneWireContainer oneWireContainer = this;
        synchronized (oneWireContainer) {
            String string = "Device type: " + ((this.address[0] & 0xFF) < 16 ? "0" + Integer.toHexString(this.address[0] & 0xFF) : Integer.toHexString(this.address[0] & 0xFF));
            return string;
        }
    }

    public String getAlternateNames() {
        return "";
    }

    public String getDescription() {
        return "No description available.";
    }

    public void setSpeed(int n, boolean bl) {
        this.speed = n;
        this.speedFallBackOK = bl;
    }

    public int getMaxSpeed() {
        return 0;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public String getAddressAsString() {
        return Address.toString(this.address);
    }

    public long getAddressAsLong() {
        return Address.toLong(this.address);
    }

    public Enumeration getMemoryBanks() {
        return new Vector(0).elements();
    }

    public boolean isPresent() throws OneWireIOException, OneWireException {
        OneWireContainer oneWireContainer = this;
        synchronized (oneWireContainer) {
            boolean bl = this.adapter.isPresent(this.address);
            return bl;
        }
    }

    public boolean isAlarming() throws OneWireIOException, OneWireException {
        OneWireContainer oneWireContainer = this;
        synchronized (oneWireContainer) {
            boolean bl = this.adapter.isAlarming(this.address);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doSpeed() throws OneWireIOException, OneWireException {
        if (this.speed == this.adapter.getSpeed() && this.adapter.isPresent(this.address)) {
            return;
        }
        if (this.speed == 2) {
            this.adapter.setSpeed(0);
            this.adapter.reset();
            this.adapter.putByte(105);
            this.adapter.setSpeed(2);
            OneWireContainer oneWireContainer = this;
            synchronized (oneWireContainer) {
                System.arraycopy(this.address, 0, this.addressCopy, 0, 8);
                this.adapter.dataBlock(this.addressCopy, 0, 8);
            }
            if (this.adapter.isPresent(this.address)) return;
            if (!this.speedFallBackOK) throw new OneWireIOException("Failed to get device to selected speed (overdrive)");
            this.adapter.setSpeed(0);
            return;
        }
        if (this.speed != 0) {
            if (this.speed != 1) throw new OneWireException("Speed selected (hyperdrive) is not supported by this method");
        }
        this.adapter.setSpeed(this.speed);
    }
}

