/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.MemoryBankScratchCRC;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.CRC16;

class MemoryBankScratchSHA
extends MemoryBankScratchCRC {
    public static final byte ERASE_SCRATCHPAD_COMMAND = -61;

    public MemoryBankScratchSHA(OneWireContainer oneWireContainer) {
        super(oneWireContainer);
        this.bankDescription = "Scratchpad with CRC and auto-hide";
    }

    public void writeScratchpad(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        boolean bl = false;
        byte[] byArray2 = new byte[37];
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byArray2[0] = -61;
        System.arraycopy(this.ffBlock, 0, byArray2, 1, 8);
        this.ib.adapter.dataBlock(byArray2, 0, 9);
        if ((byte)(byArray2[8] & 0xF0) != -96 && (byte)(byArray2[8] & 0xF0) != 80) {
            this.forceVerify();
            throw new OneWireIOException("Erase scratchpad complete not found");
        }
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byArray2[0] = 15;
        byArray2[1] = (byte)(n & 0xFF);
        byArray2[2] = (byte)((n & 0xFFFF) >>> 8 & 0xFF);
        System.arraycopy(byArray, n2, byArray2, 3, n3);
        if ((n + n3) % this.pageLength == 0) {
            System.arraycopy(this.ffBlock, 0, byArray2, n3 + 3, 2);
            bl = true;
        }
        this.ib.adapter.dataBlock(byArray2, 0, n3 + 3 + (bl ? 2 : 0));
        if (bl && CRC16.compute(byArray2, 0, n3 + 5, 0) != 45057) {
            this.forceVerify();
            throw new OneWireIOException("Invalid CRC16 read from device");
        }
    }
}

