/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.MemoryBankScratch;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.CRC16;

class MemoryBankScratchEx
extends MemoryBankScratch {
    public MemoryBankScratchEx(OneWireContainer oneWireContainer) {
        super(oneWireContainer);
        this.bankDescription = "Scratchpad Ex";
        this.COPY_SCRATCHPAD_COMMAND = (byte)90;
    }

    public void writeScratchpad(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        boolean bl = false;
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byte[] byArray2 = new byte[37];
        byArray2[0] = 15;
        byArray2[1] = (byte)(n & 0xFF);
        byArray2[2] = (byte)((n & 0xFFFF) >>> 8 & 0xFF);
        System.arraycopy(byArray, n2, byArray2, 3, n3);
        if ((n + n3) % this.pageLength == 0) {
            System.arraycopy(this.ffBlock, 0, byArray2, n3 + 3, 2);
            bl = true;
        }
        this.ib.adapter.dataBlock(byArray2, 0, n3 + 3 + (bl ? 2 : 0));
        if (bl && CRC16.compute(byArray2, 0, n3 + 5, 0) != 45057) {
            this.forceVerify();
            throw new OneWireIOException("Invalid CRC16 read from device");
        }
    }

    public void copyScratchpad(int n, int n2) throws OneWireIOException, OneWireException {
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byte[] byArray = new byte[6];
        byArray[0] = this.COPY_SCRATCHPAD_COMMAND;
        byArray[1] = (byte)(n & 0xFF);
        byArray[2] = (byte)((n & 0xFFFF) >>> 8 & 0xFF);
        byArray[3] = (byte)(n + n2 - 1 & 0x1F);
        System.arraycopy(this.ffBlock, 0, byArray, 4, 2);
        this.ib.adapter.dataBlock(byArray, 0, byArray.length);
        if ((byte)(byArray[byArray.length - 1] & 0xF0) != -96 && (byte)(byArray[byArray.length - 1] & 0xF0) != 80) {
            this.forceVerify();
            throw new OneWireIOException("Copy scratchpad complete not found");
        }
    }
}

