/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.MemoryBankScratch;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.CRC16;

class MemoryBankScratchEE
extends MemoryBankScratch {
    public MemoryBankScratchEE(OneWireContainer oneWireContainer) {
        super(oneWireContainer);
    }

    public void writeScratchpad(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        boolean bl = false;
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byte[] byArray2 = new byte[37];
        byArray2[0] = 15;
        byArray2[1] = (byte)(n & 0xFF);
        byArray2[2] = (byte)((n & 0xFFFF) >>> 8 & 0xFF);
        System.arraycopy(byArray, n2, byArray2, 3, n3);
        if ((n + n3) % this.pageLength == 0) {
            System.arraycopy(this.ffBlock, 0, byArray2, n3 + 3, 2);
            bl = true;
        }
        this.ib.adapter.dataBlock(byArray2, 0, n3 + 3 + (bl ? 2 : 0));
        if (bl && CRC16.compute(byArray2, 0, n3 + 5, 0) != 45057) {
            this.forceVerify();
            throw new OneWireIOException("Invalid CRC16 read from device");
        }
    }

    public void copyScratchpad(int n, int n2) throws OneWireIOException, OneWireException {
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byte[] byArray = new byte[]{this.COPY_SCRATCHPAD_COMMAND, (byte)(n & 0xFF), (byte)((n & 0xFFFF) >>> 8 & 0xFF)};
        this.ib.adapter.dataBlock(byArray, 0, 3);
        try {
            this.ib.adapter.setPowerDuration(5);
            this.ib.adapter.startPowerDelivery(2);
            this.ib.adapter.putByte((byte)(n + n2 - 1 & 0x1F));
            Thread.sleep(5L);
            this.ib.adapter.setPowerNormal();
            byte by = (byte)this.ib.adapter.getByte();
            if ((byte)(by & 0xF0) != -96 && (byte)(by & 0xF0) != 80) {
                this.forceVerify();
                throw new OneWireIOException("Copy scratchpad complete not found");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

