/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.MemoryBankScratchEx;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.CRC16;

class MemoryBankScratchCRC
extends MemoryBankScratchEx {
    public MemoryBankScratchCRC(OneWireContainer oneWireContainer) {
        super(oneWireContainer);
        this.bankDescription = "Scratchpad with CRC";
        this.pageAutoCRC = true;
        this.COPY_SCRATCHPAD_COMMAND = (byte)85;
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[this.extraInfoLength];
        this.readPageCRC(n, bl, byArray, n2, byArray2);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        if (!this.pageAutoCRC) {
            throw new OneWireException("Read page with CRC not supported in this memory bank");
        }
        if (!bl) {
            this.checkSpeed();
        }
        if (n > this.numberPages) {
            throw new OneWireException("Read exceeds memory bank end");
        }
        this.readScratchpad(byArray, n2, this.pageLength, byArray2);
    }

    public void readScratchpad(byte[] byArray, int n, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byte[] byArray3 = new byte[this.extraInfoLength + this.pageLength + 3];
        byArray3[0] = -86;
        System.arraycopy(this.ffBlock, 0, byArray3, 1, byArray3.length - 1);
        this.ib.adapter.dataBlock(byArray3, 0, byArray3.length);
        int n3 = byArray3[1];
        n3 = (n3 | byArray3[2] << 8 & 0xFF00) & 0xFFFF;
        int n4 = 35 - (n3 & 0x1F) + this.extraInfoLength;
        if (CRC16.compute(byArray3, 0, n4, 0) != 45057) {
            this.forceVerify();
            throw new OneWireIOException("Invalid CRC16 read from device");
        }
        if (byArray2 != null) {
            System.arraycopy(byArray3, 1, byArray2, 0, this.extraInfoLength);
        }
        System.arraycopy(byArray3, this.extraInfoLength + 1, byArray, 0, this.pageLength);
    }
}

