/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.container.ScratchPad;
import com.dalsemi.onewire.utils.CRC16;

class MemoryBankScratch
implements PagedMemoryBank,
ScratchPad {
    public static final byte WRITE_SCRATCHPAD_COMMAND = 15;
    public static final byte READ_SCRATCHPAD_COMMAND = -86;
    protected OneWireContainer ib;
    protected byte[] ffBlock;
    protected byte COPY_SCRATCHPAD_COMMAND;
    protected boolean doSetSpeed;
    protected int size;
    protected String bankDescription;
    protected boolean generalPurposeMemory;
    protected boolean readWrite;
    protected boolean writeOnce;
    protected boolean readOnly;
    protected boolean nonVolatile;
    protected boolean programPulse;
    protected boolean powerDelivery;
    protected int startPhysicalAddress;
    protected boolean writeVerification;
    protected int numberPages;
    protected int pageLength;
    protected int maxPacketDataLength;
    protected boolean pageAutoCRC;
    protected boolean extraInfo;
    protected int extraInfoLength;
    protected String extraInfoDescription;

    public MemoryBankScratch(OneWireContainer oneWireContainer) {
        this.ib = oneWireContainer;
        this.bankDescription = "Scratchpad";
        this.generalPurposeMemory = false;
        this.startPhysicalAddress = 0;
        this.size = 32;
        this.readWrite = true;
        this.writeOnce = false;
        this.readOnly = false;
        this.nonVolatile = false;
        this.programPulse = false;
        this.powerDelivery = false;
        this.writeVerification = true;
        this.numberPages = 1;
        this.pageLength = 32;
        this.maxPacketDataLength = 29;
        this.pageAutoCRC = false;
        this.extraInfo = true;
        this.extraInfoLength = 3;
        this.extraInfoDescription = "Target address, offset";
        this.ffBlock = new byte[50];
        int n = 0;
        while (n < 50) {
            this.ffBlock[n] = -1;
            ++n;
        }
        this.COPY_SCRATCHPAD_COMMAND = (byte)85;
        this.doSetSpeed = true;
    }

    public String getBankDescription() {
        return this.bankDescription;
    }

    public boolean isGeneralPurposeMemory() {
        return this.generalPurposeMemory;
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    public boolean isWriteOnce() {
        return this.writeOnce;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isNonVolatile() {
        return this.nonVolatile;
    }

    public boolean needsProgramPulse() {
        return this.programPulse;
    }

    public boolean needsPowerDelivery() {
        return this.powerDelivery;
    }

    public int getStartPhysicalAddress() {
        return this.startPhysicalAddress;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumberPages() {
        return this.numberPages;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getMaxPacketDataLength() {
        return this.maxPacketDataLength;
    }

    public boolean hasPageAutoCRC() {
        return this.pageAutoCRC;
    }

    public boolean haveExtraInfo() {
        return this.extraInfo;
    }

    public boolean hasExtraInfo() {
        return this.extraInfo;
    }

    public int getExtraInfoLength() {
        return this.extraInfoLength;
    }

    public String getExtraInfoDescription() {
        return this.extraInfoDescription;
    }

    public void setWriteVerification(boolean bl) {
        this.writeVerification = bl;
    }

    public void read(int n, boolean bl, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n + n3 > this.size) {
            throw new OneWireException("Read exceeds memory bank end");
        }
        this.checkSpeed();
        this.readScratchpad(byArray, n2, n3, null);
    }

    public void write(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 == 0) {
            return;
        }
        this.checkSpeed();
        if (n + n3 > this.size) {
            throw new OneWireException("Write exceeds memory bank end");
        }
        this.writeScratchpad(this.startPhysicalAddress + n, byArray, n2, n3);
        byte[] byArray2 = new byte[this.pageLength];
        byte[] byArray3 = new byte[this.extraInfoLength];
        this.readScratchpad(byArray2, 0, 32, byArray3);
        int n4 = 0;
        while (n4 < n3) {
            if (byArray2[n4] != byArray[n4 + n2]) {
                this.forceVerify();
                throw new OneWireIOException("Read back verify had incorrect data");
            }
            ++n4;
        }
        if (((byArray3[0] & 0xFF | byArray3[1] << 8 & 0xFF00) & 0xFFFF) != this.startPhysicalAddress + n) {
            this.forceVerify();
            throw new OneWireIOException("Read back address had incorrect data");
        }
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        if (n != 0) {
            throw new OneWireException("Page read exceeds memory bank end");
        }
        this.checkSpeed();
        this.readScratchpad(byArray, n2, this.pageLength, null);
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        if (n != 0) {
            throw new OneWireException("Page read exceeds memory bank end");
        }
        this.checkSpeed();
        this.readScratchpad(byArray, n2, this.pageLength, byArray2);
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[this.pageLength];
        this.checkSpeed();
        this.readScratchpad(byArray2, 0, this.pageLength, null);
        if (byArray2[0] > this.maxPacketDataLength) {
            this.forceVerify();
            throw new OneWireIOException("Invalid length in packet");
        }
        if (CRC16.compute(byArray2, 0, byArray2[0] + 3, n) == 45057) {
            System.arraycopy(byArray2, 1, byArray, n2, byArray2[0]);
            return byArray2[0];
        }
        this.forceVerify();
        throw new OneWireIOException("Invalid CRC16 in packet read");
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        byte[] byArray3 = new byte[this.pageLength];
        this.checkSpeed();
        this.readScratchpad(byArray3, 0, this.pageLength, byArray2);
        if (byArray3[0] > this.maxPacketDataLength) {
            this.forceVerify();
            throw new OneWireIOException("Invalid length in packet");
        }
        if (CRC16.compute(byArray3, 0, byArray3[0] + 3, n) == 45057) {
            System.arraycopy(byArray3, 1, byArray, n2, byArray3[0]);
            return byArray3[0];
        }
        this.forceVerify();
        throw new OneWireIOException("Invalid CRC16 in packet read");
    }

    public void writePagePacket(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 > this.maxPacketDataLength) {
            throw new OneWireException("Length of packet requested exceeds page size");
        }
        if (!this.generalPurposeMemory) {
            throw new OneWireException("Current bank is not general purpose memory");
        }
        byte[] byArray2 = new byte[n3 + 3];
        byArray2[0] = (byte)n3;
        System.arraycopy(byArray, n2, byArray2, 1, n3);
        int n4 = CRC16.compute(byArray2, 0, n3 + 1, n);
        byArray2[n3 + 1] = (byte)(~n4 & 0xFF);
        byArray2[n3 + 2] = (byte)((~n4 & 0xFFFF) >>> 8 & 0xFF);
        this.write(n * this.pageLength, byArray2, 0, n3 + 3);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with CRC not supported by this memory bank");
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with CRC and extra-info not supported by this memory bank");
    }

    public void readScratchpad(byte[] byArray, int n, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byte[] byArray3 = new byte[1 + this.extraInfoLength];
        byArray3[0] = -86;
        System.arraycopy(this.ffBlock, 0, byArray3, 1, this.extraInfoLength);
        this.ib.adapter.dataBlock(byArray3, 0, 1 + this.extraInfoLength);
        if (byArray2 != null) {
            System.arraycopy(byArray3, 1, byArray2, 0, this.extraInfoLength);
        }
        System.arraycopy(this.ffBlock, 0, byArray, n, n2);
        this.ib.adapter.dataBlock(byArray, 0, n2);
    }

    public void writeScratchpad(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byte[] byArray2 = new byte[3 + n3];
        byArray2[0] = 15;
        byArray2[1] = (byte)(n & 0xFF);
        byArray2[2] = (byte)((n & 0xFFFF) >>> 8 & 0xFF);
        System.arraycopy(byArray, n2, byArray2, 3, n3);
        this.ib.adapter.dataBlock(byArray2, 0, n3 + 3);
    }

    public void copyScratchpad(int n, int n2) throws OneWireIOException, OneWireException {
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byte[] byArray = new byte[]{this.COPY_SCRATCHPAD_COMMAND, (byte)(n & 0xFF), (byte)((n & 0xFFFF) >>> 8 & 0xFF), (byte)(n + n2 - 1 & 0x1F), -1};
        this.ib.adapter.dataBlock(byArray, 0, 5);
        if ((byArray[4] & 0xF0) != 0) {
            this.forceVerify();
            throw new OneWireIOException("Copy scratchpad complete not found");
        }
    }

    public void checkSpeed() throws OneWireIOException, OneWireException {
        MemoryBankScratch memoryBankScratch = this;
        synchronized (memoryBankScratch) {
            if (this.doSetSpeed) {
                this.ib.doSpeed();
                this.doSetSpeed = false;
            }
        }
    }

    public void forceVerify() {
        MemoryBankScratch memoryBankScratch = this;
        synchronized (memoryBankScratch) {
            this.doSetSpeed = true;
        }
    }
}

