/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer33;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.utils.CRC16;

class MemoryBankSHAEE
implements PagedMemoryBank {
    public static final byte READ_MEMORY = -16;
    public static final byte WRITE_SCRATCHPAD = 15;
    public static final byte READ_SCRATCHPAD = -86;
    public static final byte LOAD_FIRST_SECRET = 90;
    public static final byte COPY_SCRATCHPAD = 85;
    public static final byte READ_AUTH_PAGE = -91;
    public static final byte NEXT_SECRET = 51;
    protected boolean checked;
    protected int size;
    protected String bankDescription;
    protected boolean generalPurposeMemory;
    protected boolean readWrite;
    protected boolean writeOnce;
    protected boolean readOnly;
    protected int startPhysicalAddress;
    protected boolean writeVerification;
    protected int numberPages;
    protected int pageLength;
    protected boolean extraInfo;
    protected int extraInfoLength;
    protected int maxPacketDataLength;
    protected boolean pageCRC;
    protected OneWireContainer33 ib;
    protected byte[] ffBlock;
    protected byte[] zeroBlock;
    protected boolean doSetSpeed;

    public MemoryBankSHAEE(OneWireContainer33 oneWireContainer33) {
        MemoryBankSHAEE memoryBankSHAEE = this;
        synchronized (memoryBankSHAEE) {
            this.ib = oneWireContainer33;
            this.ffBlock = new byte[50];
            this.zeroBlock = new byte[6];
            int n = 0;
            while (n < 50) {
                this.ffBlock[n] = -1;
                ++n;
            }
            n = 0;
            while (n < 6) {
                this.zeroBlock[n] = 0;
                ++n;
            }
            this.doSetSpeed = true;
        }
    }

    public String getBankDescription() {
        return this.bankDescription;
    }

    public boolean isGeneralPurposeMemory() {
        return this.generalPurposeMemory;
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    public boolean isWriteOnce() {
        return this.writeOnce;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isNonVolatile() {
        return true;
    }

    public boolean needsProgramPulse() {
        return false;
    }

    public boolean needsPowerDelivery() {
        return false;
    }

    public int getStartPhysicalAddress() {
        return this.startPhysicalAddress;
    }

    public int getSize() {
        return this.size;
    }

    public void setWriteVerification(boolean bl) {
        this.writeVerification = bl;
    }

    public int getNumberPages() {
        return this.numberPages;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public boolean hasPageAutoCRC() {
        return this.pageCRC;
    }

    public boolean haveExtraInfo() {
        return this.extraInfo;
    }

    public boolean hasExtraInfo() {
        return this.extraInfo;
    }

    public int getExtraInfoLength() {
        return this.extraInfoLength;
    }

    public String getExtraInfoDescription() {
        return "The MAC for the SHA Engine";
    }

    public int getMaxPacketDataLength() {
        return this.maxPacketDataLength;
    }

    public void read(int n, boolean bl, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        int n4;
        if (!bl && this.ib.adapterSet()) {
            this.checkSpeed();
        }
        if (n + n3 > this.pageLength * this.numberPages) {
            throw new OneWireException("Read exceeds memory bank end.");
        }
        if (!bl) {
            if (!this.ib.adapter.select(this.ib.address)) {
                throw new OneWireIOException("Device select failed.");
            }
            n4 = n + this.startPhysicalAddress;
            byte[] byArray2 = new byte[]{-16, (byte)(n4 & 0xFF), (byte)((n4 & 0xFFFF) >>> 8 & 0xFF)};
            this.ib.adapter.dataBlock(byArray2, 0, 3);
        }
        n4 = n3 / this.pageLength;
        int n5 = n3 % this.pageLength;
        int n6 = 0;
        while (n6 < n4) {
            System.arraycopy(this.ffBlock, 0, byArray, n2 + n6 * this.pageLength, this.pageLength);
            ++n6;
        }
        System.arraycopy(this.ffBlock, 0, byArray, n2 + n4 * this.pageLength, n5);
        this.ib.adapter.dataBlock(byArray, n2, n3);
    }

    public void write(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        boolean bl = false;
        if (!this.checked) {
            this.checked = this.ib.checkStatus();
        }
        if (n3 == 0) {
            return;
        }
        this.checkSpeed();
        if (!this.ib.isContainerSecretSet()) {
            throw new OneWireException("Secret is not set.");
        }
        if (n + n3 > this.size) {
            throw new OneWireException("Write exceeds memory bank end");
        }
        if (this.isReadOnly()) {
            throw new OneWireException("Trying to write read-only memory bank");
        }
        int n4 = 0;
        int n5 = 0;
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[this.getExtraInfoLength()];
        byte[] byArray4 = new byte[64];
        byte[] byArray5 = new byte[32];
        int n6 = this.startPhysicalAddress + n;
        int n7 = 8;
        this.read(n / this.pageLength * this.pageLength, false, byArray5, 0, this.pageLength);
        do {
            int n8;
            n5 = n3 - n4 > (n8 = n7 - (n6 + n4) % n7) ? n4 + n8 : n3;
            if (n >= this.pageLength) {
                System.arraycopy(byArray5, (n4 + n) / 8 * 8 - 32, byArray2, 0, 8);
            } else {
                System.arraycopy(byArray5, (n4 + n) / 8 * 8, byArray2, 0, 8);
            }
            if (n5 - n4 == 8) {
                System.arraycopy(byArray, n2 + n4, byArray2, 0, 8);
            } else if ((n + n5) % 8 == 0) {
                System.arraycopy(byArray, n2 + n4, byArray2, (n + n4) % 8, 8 - (n + n4) % 8);
            } else {
                System.arraycopy(byArray, n2 + n4, byArray2, (n + n4) % 8, (n + n5) % 8 - (n + n4) % 8);
            }
            if (!this.writeSpad(n6 + n4 + n8 - 8, byArray2, 0, 8)) {
                throw new OneWireIOException("Invalid CRC16 in write");
            }
            this.copySpad(n6 + n4 + n8 - 8, byArray3, byArray5);
            if (n >= this.pageLength) {
                System.arraycopy(byArray2, 0, byArray5, (n4 + n) / 8 * 8 - 32, 8);
            } else {
                System.arraycopy(byArray2, 0, byArray5, (n4 + n) / 8 * 8, 8);
            }
            n4 = n5;
        } while (n5 < n3);
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        this.read(n * this.pageLength, bl, byArray, n2, this.pageLength);
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        int n3;
        byte[] byArray3 = new byte[32];
        if (!this.checked) {
            this.checked = this.ib.checkStatus();
        }
        if (!this.hasPageAutoCRC()) {
            throw new OneWireException("This memory bank doesn't have crc capabilities.");
        }
        if (!bl) {
            this.checkSpeed();
        }
        if (!this.ReadAuthPage(n3 = n * this.pageLength + this.startPhysicalAddress, byArray3, byArray2)) {
            throw new OneWireException("Read didn't work.");
        }
        System.arraycopy(byArray3, 0, byArray, n2, 32);
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[this.pageLength];
        this.readPage(n, bl, byArray2, 0);
        if ((byArray2[0] & 0xFF) > this.maxPacketDataLength) {
            throw new OneWireIOException("Invalid length in packet.");
        }
        if (CRC16.compute(byArray2, 0, byArray2[0] + 3, n) == 45057) {
            System.arraycopy(byArray2, 1, byArray, n2, byArray2[0]);
            return byArray2[0];
        }
        throw new OneWireIOException("Invalid CRC16 in packet read.");
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        byte[] byArray3 = new byte[this.pageLength];
        if (!this.checked) {
            this.checked = this.ib.checkStatus();
        }
        if (!this.hasPageAutoCRC()) {
            throw new OneWireException("This memory bank page doesn't have CRC capabilites.");
        }
        int n3 = this.startPhysicalAddress + n * this.pageLength;
        this.ReadAuthPage(n3, byArray3, byArray2);
        if ((byArray3[0] & 0xFF) > this.maxPacketDataLength) {
            throw new OneWireIOException("Invalid length in packet.");
        }
        if (CRC16.compute(byArray3, 0, byArray3[0] + 3, n) == 45057) {
            System.arraycopy(byArray3, 1, byArray, n2, byArray3[0]);
            return byArray3[0];
        }
        throw new OneWireIOException("Invalid CRC16 in packet read.");
    }

    public void writePagePacket(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 > this.maxPacketDataLength) {
            throw new OneWireIOException("Length of packet requested exceeds page size.");
        }
        if (!this.generalPurposeMemory) {
            throw new OneWireException("Current bank is not general purpose memory.");
        }
        byte[] byArray2 = new byte[n3 + 3];
        byArray2[0] = (byte)n3;
        System.arraycopy(byArray, 0, byArray2, 1, n3);
        int n4 = CRC16.compute(byArray2, 0, n3 + 1, n);
        byArray2[n3 + 1] = (byte)(~n4 & 0xFF);
        byArray2[n3 + 2] = (byte)((~n4 & 0xFFFF) >>> 8 & 0xFF);
        this.write(n * this.pageLength, byArray2, 0, n3 + 3);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[32];
        if (!this.checked) {
            this.checked = this.ib.checkStatus();
        }
        if (!this.hasPageAutoCRC()) {
            throw new OneWireException("This memory bank doesn't have CRC capabilites.");
        }
        int n3 = this.startPhysicalAddress + n * this.pageLength;
        if (!this.ReadAuthPage(n3, byArray3, byArray2)) {
            throw new OneWireException("Read didn't work.");
        }
        System.arraycopy(byArray3, 0, byArray, n2, this.pageLength);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        byte[] byArray3 = new byte[32];
        if (!this.checked) {
            this.checked = this.ib.checkStatus();
        }
        if (!this.hasPageAutoCRC()) {
            throw new OneWireException("This memory bank doesn't have CRC capabilities.");
        }
        int n3 = this.startPhysicalAddress + n * this.pageLength;
        if (!this.ReadAuthPage(n3, byArray3, byArray2)) {
            throw new OneWireException("Read didn't work.");
        }
        System.arraycopy(byArray3, 0, byArray, n2, this.pageLength);
    }

    public void writeprotect() {
        this.readOnly = true;
        this.readWrite = false;
    }

    public void setEPROM() {
        this.writeOnce = true;
    }

    public void checkSpeed() throws OneWireIOException, OneWireException {
        if (this.doSetSpeed) {
            this.ib.doSpeed();
            this.doSetSpeed = false;
        }
    }

    public boolean writeSpad(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[64];
        int n4 = 0;
        if (this.ib.adapter.select(this.ib.address)) {
            byArray2[n4++] = 15;
            byArray2[n4++] = (byte)(n & 0xFF);
            byArray2[n4++] = (byte)((n & 0xFFFF) >>> 8 & 0xFF);
            System.arraycopy(byArray, n2, byArray2, n4, n3);
            n4 += n3;
            byArray2[n4++] = -1;
            byArray2[n4++] = -1;
            this.ib.adapter.dataBlock(byArray2, 0, n4);
            if (CRC16.compute(byArray2, 0, n4) != 45057) {
                throw new OneWireIOException("Invalid CRC16 in Writing Scratch Pad");
            }
        } else {
            throw new OneWireIOException("Device select failed.");
        }
        return true;
    }

    public void copySpad(int n, byte[] byArray, byte[] byArray2) throws OneWireIOException, OneWireException {
        int n2 = 0;
        int n3 = 0;
        byte[] byArray3 = new byte[80];
        byte[] byArray4 = new byte[11];
        byte[] byArray5 = new byte[8];
        byte[] byArray6 = new byte[8];
        byte by = 0;
        byte by2 = 0;
        byte[] byArray7 = new byte[64];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (!this.ib.isContainerSecretSet()) {
            throw new OneWireException("Secret is not set.");
        }
        byArray6 = this.ib.getAddress();
        this.ib.getSecret(byArray5);
        System.arraycopy(byArray5, 0, byArray7, 0, 4);
        System.arraycopy(byArray2, 0, byArray7, 4, 32);
        if (this.readSpad(byArray4)) {
            System.arraycopy(byArray4, 0, byArray7, 32, 8);
        }
        by = byArray4[8];
        n3 = (byArray4[10] & 0xFF) << 8 | byArray4[9] & 0xFF;
        byArray7[40] = (byte)((n3 & 0xF0) >>> 5);
        System.arraycopy(byArray6, 0, byArray7, 41, 7);
        System.arraycopy(byArray5, 4, byArray7, 48, 4);
        System.arraycopy(this.ffBlock, 0, byArray7, 52, 3);
        byArray7[55] = -128;
        System.arraycopy(this.zeroBlock, 0, byArray7, 56, 6);
        byArray7[62] = 1;
        byArray7[63] = -72;
        int[] nArray = new int[5];
        OneWireContainer33.ComputeSHA(byArray7, nArray);
        n4 = nArray[0];
        n5 = nArray[1];
        n6 = nArray[2];
        n7 = nArray[3];
        n8 = nArray[4];
        if (this.ib.adapter.select(this.ib.address)) {
            int n9 = n2;
            n2 = (short)(n2 + 1);
            byArray3[n9] = 85;
            int n10 = n2;
            n2 = (short)(n2 + 1);
            byArray3[n10] = (byte)(n3 & 0xFF);
            int n11 = n2;
            n2 = (short)(n2 + 1);
            byArray3[n11] = (byte)((n3 & 0xFFFF) >>> 8 & 0xFF);
            int n12 = n2;
            n2 = (short)(n2 + 1);
            byArray3[n12] = by;
            this.ib.adapter.dataBlock(byArray3, 0, n2);
            n2 = 0;
            int n13 = n8;
            int n14 = 0;
            while (n14 < 4) {
                int n15 = n2;
                n2 = (short)(n2 + 1);
                byArray3[n15] = (byte)(n13 & 0xFF);
                n13 >>= 8;
                ++n14;
            }
            n13 = n7;
            n14 = 0;
            while (n14 < 4) {
                int n16 = n2;
                n2 = (short)(n2 + 1);
                byArray3[n16] = (byte)(n13 & 0xFF);
                n13 >>= 8;
                ++n14;
            }
            n13 = n6;
            n14 = 0;
            while (n14 < 4) {
                int n17 = n2;
                n2 = (short)(n2 + 1);
                byArray3[n17] = (byte)(n13 & 0xFF);
                n13 >>= 8;
                ++n14;
            }
            n13 = n5;
            n14 = 0;
            while (n14 < 4) {
                int n18 = n2;
                n2 = (short)(n2 + 1);
                byArray3[n18] = (byte)(n13 & 0xFF);
                n13 >>= 8;
                ++n14;
            }
            n13 = n4;
            n14 = 0;
            while (n14 < 4) {
                int n19 = n2;
                n2 = (short)(n2 + 1);
                byArray3[n19] = (byte)(n13 & 0xFF);
                n13 >>= 8;
                ++n14;
            }
            System.arraycopy(byArray3, 0, byArray, 0, 20);
            try {
                Thread.sleep(4L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.ib.adapter.dataBlock(byArray3, 0, n2);
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            by2 = (byte)this.ib.adapter.getByte();
            if (by2 != -86 && by2 != 85) {
                if (by2 == -1) {
                    throw new OneWireException("That area of memory is write-protected.");
                }
                if (by2 == 0) {
                    throw new OneWireIOException("Error due to not matching MAC.");
                }
            }
        } else {
            throw new OneWireIOException("Device select failed.");
        }
    }

    public boolean readSpad(byte[] byArray) throws OneWireIOException, OneWireException {
        int n = 0;
        byte[] byArray2 = new byte[50];
        if (this.ib.adapter.select(this.ib.address)) {
            byArray2[n++] = -86;
            System.arraycopy(this.ffBlock, 0, byArray2, n, 13);
            this.ib.adapter.dataBlock(byArray2, 0, n += 13);
            byArray[9] = byArray2[1];
            byArray[10] = byArray2[2];
            byArray[8] = byArray2[3];
            if (CRC16.compute(byArray2, 0, n) == 45057) {
                System.arraycopy(byArray2, 4, byArray, 0, 8);
                return true;
            }
            throw new OneWireException("Error due to CRC.");
        }
        throw new OneWireIOException("Device select failed.");
    }

    public boolean LoadFirSecret(int n, byte[] byArray) throws OneWireIOException, OneWireException {
        int n2 = 0;
        byte by = 0;
        byte[] byArray2 = new byte[11];
        byte[] byArray3 = new byte[32];
        int n3 = 0;
        if (this.ib.isSecretWriteProtected()) {
            throw new OneWireException("Error due to secret is write-protected.");
        }
        if (this.writeSpad(n + this.startPhysicalAddress, byArray, 0, 8) && this.readSpad(byArray2)) {
            n2 = (byArray2[10] & 0xFF) << 8 | byArray2[9] & 0xFF;
            if (this.ib.adapter.select(this.ib.address)) {
                byArray3[n3++] = 90;
                byArray3[n3++] = byArray2[9];
                byArray3[n3++] = byArray2[10];
                byArray3[n3++] = byArray2[8];
                this.ib.adapter.dataBlock(byArray3, 0, n3);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                by = (byte)this.ib.adapter.getByte();
                if (by == -86 || by == 85) {
                    this.ib.setContainerSecret(byArray);
                    return true;
                }
                throw new OneWireException("Error due to invalid load.");
            }
            throw new OneWireIOException("Device select failed.");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void nextSecret(int n, byte[] byArray, byte[] byArray2) throws OneWireIOException, OneWireException {
        int n2 = 0;
        boolean bl = false;
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[8];
        byte[] byArray6 = new byte[8];
        boolean bl2 = false;
        boolean bl3 = false;
        byte[] byArray7 = new byte[64];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!this.ib.isContainerSecretSet()) {
            throw new OneWireException("Secret is not set.");
        }
        this.read(n / 32 * 32, false, byArray4, 0, 32);
        if (!this.writeSpad(n, byArray2, 0, 8)) {
            throw new OneWireIOException("Error writing scratch pad.");
        }
        this.ib.getSecret(byArray5);
        System.arraycopy(byArray5, 0, byArray7, 0, 4);
        System.arraycopy(byArray4, 0, byArray7, 4, 32);
        System.arraycopy(this.ffBlock, 0, byArray7, 36, 4);
        byArray7[40] = (byte)(byArray2[0] & 0x3F);
        System.arraycopy(byArray2, 1, byArray7, 41, 7);
        System.arraycopy(byArray5, 4, byArray7, 48, 4);
        System.arraycopy(this.ffBlock, 0, byArray7, 52, 3);
        byArray7[55] = -128;
        System.arraycopy(this.zeroBlock, 0, byArray7, 56, 6);
        byArray7[62] = 1;
        byArray7[63] = -72;
        int[] nArray = new int[5];
        OneWireContainer33.ComputeSHA(byArray7, nArray);
        n3 = nArray[0];
        n4 = nArray[1];
        n5 = nArray[2];
        n6 = nArray[3];
        int n8 = n7 = nArray[4];
        int n9 = 0;
        while (n9 < 4) {
            byArray5[n9] = (byte)(n8 & 0xFF);
            n8 >>= 8;
            byArray[n2++] = byArray5[n9];
            ++n9;
        }
        n8 = n6;
        n9 = 0;
        while (n9 < 4) {
            byArray5[n9 + 4] = (byte)(n8 & 0xFF);
            n8 >>= 8;
            byArray[n2++] = byArray5[n9];
            ++n9;
        }
        n8 = n5;
        n9 = 0;
        while (n9 < 4) {
            byArray[n2++] = (byte)(n8 & 0xFF);
            n8 >>= 8;
            ++n9;
        }
        n8 = n4;
        n9 = 0;
        while (n9 < 4) {
            byArray[n2++] = (byte)(n8 & 0xFF);
            n8 >>= 8;
            ++n9;
        }
        n8 = n3;
        n9 = 0;
        while (n9 < 4) {
            byArray[n2++] = (byte)(n8 & 0xFF);
            n8 >>= 8;
            ++n9;
        }
        n2 = 0;
        if (!this.ib.adapter.select(this.ib.address)) throw new OneWireIOException("Device select failed.");
        byArray3[n2++] = 51;
        byArray3[n2++] = (byte)(n & 0xFF);
        byArray3[n2++] = (byte)((n & 0xFFFF) >>> 8 & 0xFF);
        this.ib.adapter.dataBlock(byArray3, 0, n2);
        try {
            Thread.sleep(24L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.readSpad(byArray6)) throw new OneWireIOException("Error reading scratch pad.");
        n9 = 0;
        while (n9 < 8) {
            if (byArray6[n9] != -86) {
                MemoryBankSHAEE.hexPrint(byArray6, 0, 8);
                throw new OneWireIOException("Next secret not calculated.");
            }
            ++n9;
        }
        this.ib.setContainerSecret(byArray5);
    }

    public boolean ReadAuthPage(int n, byte[] byArray, byte[] byArray2) throws OneWireException, OneWireIOException {
        int n2 = 0;
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[8];
        this.ib.getChallenge(byArray4);
        if (!this.writeSpad(n, byArray4, 0, 8)) {
            throw new OneWireIOException("Error writing scratch pad.");
        }
        if (this.ib.adapter.select(this.ib.address)) {
            byArray3[n2++] = -91;
            byArray3[n2++] = (byte)(n & 0xFF);
            byArray3[n2++] = (byte)((n & 0xFFFF) >>> 8 & 0xFF);
            System.arraycopy(this.ffBlock, 0, byArray3, n2, 35);
            this.ib.adapter.dataBlock(byArray3, 0, n2 += 35);
            if (CRC16.compute(byArray3, 0, n2, 0) != 45057) {
                throw new OneWireException("First CRC didn't pass.");
            }
            System.arraycopy(byArray3, 3, byArray, 0, 32);
            n2 = 22;
            System.arraycopy(this.ffBlock, 0, byArray3, 0, 22);
            this.ib.adapter.dataBlock(byArray3, 0, n2);
            if (CRC16.compute(byArray3, 0, n2, 0) != 45057) {
                throw new OneWireException("Second CRC didn't pass.");
            }
        } else {
            throw new OneWireIOException("Device select failed.");
        }
        System.arraycopy(byArray3, 0, byArray2, 0, 20);
        return true;
    }

    public static void hexPrint(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if ((byArray[n3 + n] & 0xFF) < 16) {
                System.out.print("0");
                System.out.print(Integer.toHexString(byArray[n3 + n] & 0xF).toUpperCase());
            } else {
                System.out.print(Integer.toHexString(byArray[n3 + n] & 0xFF).toUpperCase());
            }
            ++n3;
        }
    }
}

