/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.MemoryBankNV;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.ScratchPad;
import com.dalsemi.onewire.utils.CRC16;

class MemoryBankNVCRC
extends MemoryBankNV {
    public static final byte READ_PAGE_WITH_CRC = -91;
    protected boolean readContinuePossible;
    protected int numVerifyBytes;

    public MemoryBankNVCRC(OneWireContainer oneWireContainer, ScratchPad scratchPad) {
        super(oneWireContainer, scratchPad);
        this.pageAutoCRC = true;
        this.readContinuePossible = true;
        this.numVerifyBytes = 0;
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        this.readPageCRC(n, bl, byArray, n2, null, this.extraInfoLength);
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        if (!this.extraInfo) {
            throw new OneWireException("Read extra information not supported on this memory bank");
        }
        this.readPageCRC(n, bl, byArray, n2, byArray2, this.extraInfoLength);
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        byte[] byArray3 = new byte[this.pageLength];
        this.readPageCRC(n, bl, byArray3, 0, byArray2, this.extraInfoLength);
        if (byArray3[0] > this.maxPacketDataLength) {
            this.sp.forceVerify();
            throw new OneWireIOException("Invalid length in packet");
        }
        int n3 = this.startPhysicalAddress / this.pageLength + n;
        if (CRC16.compute(byArray3, 0, byArray3[0] + 3, n3) == 45057) {
            System.arraycopy(byArray3, 1, byArray, n2, byArray3[0]);
            return byArray3[0];
        }
        this.sp.forceVerify();
        throw new OneWireIOException("Invalid CRC16 in packet read");
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        this.readPageCRC(n, bl, byArray, n2, null, this.extraInfoLength);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        this.readPageCRC(n, bl, byArray, n2, byArray2, this.extraInfoLength);
    }

    protected void readPageCRC(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2, int n3) throws OneWireIOException, OneWireException {
        byte[] byArray3;
        int n4 = 0;
        if (!this.pageAutoCRC) {
            throw new OneWireException("Read page with CRC not supported in this memory bank");
        }
        if (!bl) {
            this.sp.checkSpeed();
        }
        if (n > this.numberPages) {
            throw new OneWireException("Read exceeds memory bank end");
        }
        if (!bl || !this.readContinuePossible) {
            if (!this.ib.adapter.select(this.ib.address)) {
                this.sp.forceVerify();
                throw new OneWireIOException("Device select failed");
            }
            byArray3 = new byte[3];
            byArray3[0] = -91;
            int n5 = n * this.pageLength + this.startPhysicalAddress;
            byArray3[1] = (byte)(n5 & 0xFF);
            byArray3[2] = (byte)((n5 & 0xFFFF) >>> 8 & 0xFF);
            n4 = CRC16.compute(byArray3, 0, byArray3.length, n4);
            this.ib.adapter.dataBlock(byArray3, 0, 3);
        }
        byArray3 = new byte[this.pageLength + n3 + 2 + this.numVerifyBytes];
        System.arraycopy(this.ffBlock, 0, byArray3, 0, byArray3.length);
        this.ib.adapter.dataBlock(byArray3, 0, byArray3.length);
        if (CRC16.compute(byArray3, 0, byArray3.length - this.numVerifyBytes, n4) != 45057) {
            this.sp.forceVerify();
            throw new OneWireIOException("Invalid CRC16 read from device");
        }
        System.arraycopy(byArray3, 0, byArray, n2, this.pageLength);
        if (byArray2 != null) {
            System.arraycopy(byArray3, this.pageLength, byArray2, 0, n3);
        }
    }
}

