/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.container.ScratchPad;
import com.dalsemi.onewire.utils.CRC16;

class MemoryBankNV
implements PagedMemoryBank {
    public static final byte READ_MEMORY_COMMAND = -16;
    protected ScratchPad sp;
    protected OneWireContainer ib;
    protected byte[] ffBlock;
    protected int size;
    protected String bankDescription;
    protected boolean generalPurposeMemory;
    protected boolean readWrite;
    protected boolean writeOnce;
    protected boolean readOnly;
    protected boolean nonVolatile;
    protected boolean programPulse;
    protected boolean powerDelivery;
    protected int startPhysicalAddress;
    protected boolean writeVerification;
    protected int numberPages;
    protected int pageLength;
    protected int maxPacketDataLength;
    protected boolean pageAutoCRC;
    protected boolean extraInfo;
    protected int extraInfoLength;
    protected String extraInfoDescription;

    public MemoryBankNV(OneWireContainer oneWireContainer, ScratchPad scratchPad) {
        this.ib = oneWireContainer;
        this.sp = scratchPad;
        this.bankDescription = "Main Memory";
        this.generalPurposeMemory = true;
        this.startPhysicalAddress = 0;
        this.size = 512;
        this.readWrite = true;
        this.writeOnce = false;
        this.readOnly = false;
        this.nonVolatile = true;
        this.programPulse = false;
        this.powerDelivery = false;
        this.writeVerification = true;
        this.numberPages = 16;
        this.pageLength = 32;
        this.maxPacketDataLength = 29;
        this.pageAutoCRC = false;
        this.extraInfo = false;
        this.extraInfoLength = 0;
        this.extraInfoDescription = null;
        this.ffBlock = new byte[50];
        int n = 0;
        while (n < 50) {
            this.ffBlock[n] = -1;
            ++n;
        }
    }

    public String getBankDescription() {
        return this.bankDescription;
    }

    public boolean isGeneralPurposeMemory() {
        return this.generalPurposeMemory;
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    public boolean isWriteOnce() {
        return this.writeOnce;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isNonVolatile() {
        return this.nonVolatile;
    }

    public boolean needsProgramPulse() {
        return this.programPulse;
    }

    public boolean needsPowerDelivery() {
        return this.powerDelivery;
    }

    public int getStartPhysicalAddress() {
        return this.startPhysicalAddress;
    }

    public int getSize() {
        return this.size;
    }

    public void setWriteVerification(boolean bl) {
        this.writeVerification = bl;
    }

    public int getNumberPages() {
        return this.numberPages;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getMaxPacketDataLength() {
        return this.maxPacketDataLength;
    }

    public boolean hasPageAutoCRC() {
        return this.pageAutoCRC;
    }

    public boolean haveExtraInfo() {
        return this.extraInfo;
    }

    public boolean hasExtraInfo() {
        return this.extraInfo;
    }

    public int getExtraInfoLength() {
        return this.extraInfoLength;
    }

    public String getExtraInfoDescription() {
        return this.extraInfoDescription;
    }

    public void read(int n, boolean bl, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        int n4;
        if (!bl) {
            this.sp.checkSpeed();
        }
        if (n + n3 > this.pageLength * this.numberPages) {
            throw new OneWireException("Read exceeds memory bank end");
        }
        if (!bl) {
            if (!this.ib.adapter.select(this.ib.address)) {
                this.sp.forceVerify();
                throw new OneWireIOException("Device select failed");
            }
            n4 = n + this.startPhysicalAddress;
            byte[] byArray2 = new byte[]{-16, (byte)(n4 & 0xFF), (byte)((n4 & 0xFFFF) >>> 8 & 0xFF)};
            this.ib.adapter.dataBlock(byArray2, 0, 3);
        }
        n4 = n3 / this.pageLength;
        int n5 = n3 % this.pageLength;
        int n6 = 0;
        while (n6 < n4) {
            System.arraycopy(this.ffBlock, 0, byArray, n2 + n6 * this.pageLength, this.pageLength);
            ++n6;
        }
        System.arraycopy(this.ffBlock, 0, byArray, n2 + n4 * this.pageLength, n5);
        this.ib.adapter.dataBlock(byArray, n2, n3);
    }

    public void write(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 == 0) {
            return;
        }
        this.sp.checkSpeed();
        if (n + n3 > this.size) {
            throw new OneWireException("Write exceeds memory bank end");
        }
        if (this.isReadOnly()) {
            throw new OneWireException("Trying to write read-only memory bank");
        }
        int n4 = 0;
        int n5 = 0;
        byte[] byArray2 = new byte[this.pageLength];
        byte[] byArray3 = new byte[this.sp.getExtraInfoLength()];
        int n6 = this.startPhysicalAddress + n;
        int n7 = this.pageLength;
        do {
            int n8;
            n5 = n3 - n4 > (n8 = n7 - (n6 + n4) % n7) ? n4 + n8 : n3;
            this.sp.writeScratchpad(n6 + n4, byArray, n2 + n4, n5 - n4);
            this.sp.readScratchpad(byArray2, 0, n7, byArray3);
            int n9 = 0;
            while (n9 < n5 - n4) {
                if (byArray2[n9] != byArray[n9 + n2 + n4]) {
                    this.sp.forceVerify();
                    throw new OneWireIOException("Read back of scratchpad had incorrect data");
                }
                ++n9;
            }
            if (((byArray3[0] & 0xFF | byArray3[1] << 8 & 0xFF00) & 0xFFFF) != n6 + n4) {
                this.sp.forceVerify();
                throw new OneWireIOException("Address read back from scrachpad was incorrect");
            }
            this.sp.copyScratchpad(n6 + n4, n5 - n4);
            n4 = n5;
        } while (n5 < n3);
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        this.read(n * this.pageLength, bl, byArray, n2, this.pageLength);
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with extra-info not supported by this memory bank");
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[this.pageLength];
        this.readPage(n, bl, byArray2, 0);
        if ((byArray2[0] & 0xFF) > this.maxPacketDataLength) {
            throw new OneWireIOException("Invalid length in packet");
        }
        int n3 = this.startPhysicalAddress / this.pageLength + n;
        if (CRC16.compute(byArray2, 0, byArray2[0] + 3, n3) == 45057) {
            System.arraycopy(byArray2, 1, byArray, n2, byArray2[0]);
            return byArray2[0];
        }
        throw new OneWireIOException("Invalid CRC16 in packet read");
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read packet with extra-info not supported by this memory bank");
    }

    public void writePagePacket(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 > this.maxPacketDataLength) {
            throw new OneWireIOException("Length of packet requested exceeds page size");
        }
        if (!this.generalPurposeMemory) {
            throw new OneWireException("Current bank is not general purpose memory");
        }
        byte[] byArray2 = new byte[n3 + 3];
        byArray2[0] = (byte)n3;
        System.arraycopy(byArray, n2, byArray2, 1, n3);
        int n4 = this.startPhysicalAddress / this.pageLength + n;
        int n5 = CRC16.compute(byArray2, 0, n3 + 1, n4);
        byArray2[n3 + 1] = (byte)(~n5 & 0xFF);
        byArray2[n3 + 2] = (byte)((~n5 & 0xFFFF) >>> 8 & 0xFF);
        this.write(n * this.pageLength, byArray2, 0, n3 + 3);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with CRC not supported by this memory bank");
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with CRC and extra-info not supported by this memory bank");
    }
}

