/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OTPMemoryBank;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.utils.CRC16;
import com.dalsemi.onewire.utils.CRC8;

class MemoryBankEPROM
implements OTPMemoryBank {
    public static final byte READ_MEMORY_COMMAND = -16;
    public static final byte MAIN_READ_PAGE_COMMAND = -91;
    public static final byte STATUS_READ_PAGE_COMMAND = -86;
    public static final byte MAIN_WRITE_COMMAND = 15;
    public static final byte STATUS_WRITE_COMMAND = 85;
    protected OneWireContainer ib;
    protected byte READ_PAGE_WITH_CRC;
    protected int numCRCBytes;
    protected boolean crcAfterAddress;
    protected boolean normalReadCRC;
    protected byte WRITE_MEMORY_COMMAND;
    protected byte[] ffBlock;
    protected boolean doSetSpeed;
    protected int size;
    protected String bankDescription;
    protected boolean generalPurposeMemory;
    protected boolean readWrite;
    protected boolean writeOnce;
    protected boolean readOnly;
    protected boolean nonVolatile;
    protected boolean programPulse;
    protected boolean powerDelivery;
    protected int startPhysicalAddress;
    protected boolean writeVerification;
    protected int numberPages;
    protected int pageLength;
    protected int maxPacketDataLength;
    protected boolean pageAutoCRC;
    protected boolean extraInfo;
    protected int extraInfoLength;
    protected String extraInfoDescription;
    protected boolean redirectPage;
    protected boolean lockPage;
    protected boolean lockRedirectPage;
    protected PagedMemoryBank mbLock;
    protected PagedMemoryBank mbRedirect;
    protected PagedMemoryBank mbLockRedirect;
    protected int lockOffset;
    protected int redirectOffset;
    protected int lockRedirectOffset;

    public MemoryBankEPROM(OneWireContainer oneWireContainer) {
        this.ib = oneWireContainer;
        this.mbLock = null;
        this.mbRedirect = null;
        this.mbLockRedirect = null;
        this.lockOffset = 0;
        this.redirectOffset = 0;
        this.lockRedirectOffset = 0;
        this.generalPurposeMemory = true;
        this.bankDescription = "Main Memory";
        this.numberPages = 64;
        this.size = 2048;
        this.pageLength = 32;
        this.maxPacketDataLength = 29;
        this.readWrite = false;
        this.writeOnce = true;
        this.readOnly = false;
        this.nonVolatile = true;
        this.pageAutoCRC = true;
        this.redirectPage = false;
        this.lockPage = false;
        this.lockRedirectPage = false;
        this.programPulse = true;
        this.powerDelivery = false;
        this.extraInfo = true;
        this.extraInfoLength = 1;
        this.extraInfoDescription = "Inverted redirection page";
        this.writeVerification = true;
        this.startPhysicalAddress = 0;
        this.READ_PAGE_WITH_CRC = (byte)-91;
        this.WRITE_MEMORY_COMMAND = (byte)15;
        this.numCRCBytes = 2;
        this.crcAfterAddress = true;
        this.normalReadCRC = false;
        this.doSetSpeed = true;
        this.ffBlock = new byte[50];
        int n = 0;
        while (n < 50) {
            this.ffBlock[n] = -1;
            ++n;
        }
    }

    public String getBankDescription() {
        return this.bankDescription;
    }

    public boolean isGeneralPurposeMemory() {
        return this.generalPurposeMemory;
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    public boolean isWriteOnce() {
        return this.writeOnce;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isNonVolatile() {
        return this.nonVolatile;
    }

    public boolean needsProgramPulse() {
        return this.programPulse;
    }

    public boolean needsPowerDelivery() {
        return this.powerDelivery;
    }

    public int getStartPhysicalAddress() {
        return this.startPhysicalAddress;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumberPages() {
        return this.numberPages;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getMaxPacketDataLength() {
        return this.maxPacketDataLength;
    }

    public boolean hasPageAutoCRC() {
        return this.pageAutoCRC;
    }

    public boolean haveExtraInfo() {
        return this.extraInfo;
    }

    public boolean hasExtraInfo() {
        return this.extraInfo;
    }

    public int getExtraInfoLength() {
        return this.extraInfoLength;
    }

    public String getExtraInfoDescription() {
        return this.extraInfoDescription;
    }

    public void setWriteVerification(boolean bl) {
        this.writeVerification = bl;
    }

    public boolean canRedirectPage() {
        return this.redirectPage;
    }

    public boolean canLockPage() {
        return this.lockPage;
    }

    public boolean canLockRedirectPage() {
        return this.lockRedirectPage;
    }

    public void read(int n, boolean bl, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n + n3 > this.pageLength * this.numberPages) {
            throw new OneWireException("Read exceeds memory bank end");
        }
        if (!bl) {
            this.checkSpeed();
        }
        if (this.READ_PAGE_WITH_CRC == -86) {
            int n4 = n / this.pageLength;
            int n5 = (n + n3) / this.pageLength - 1;
            if ((n + n3) % this.pageLength > 0) {
                ++n5;
            }
            byte[] byArray2 = new byte[(n5 - n4 + 1) * this.pageLength];
            int n6 = n4;
            while (n6 <= n5) {
                this.readPageCRC(n6, n6 != n4, byArray2, (n6 - n4) * this.pageLength, null, 0);
                ++n6;
            }
            System.arraycopy(byArray2, n % this.pageLength, byArray, n2, n3);
        } else {
            int n7;
            if (!bl) {
                if (!this.ib.adapter.select(this.ib.address)) {
                    this.forceVerify();
                    throw new OneWireIOException("Device select failed");
                }
                byte[] byArray3 = new byte[]{-16, (byte)(n + this.startPhysicalAddress & 0xFF), (byte)((n + this.startPhysicalAddress & 0xFFFF) >>> 8 & 0xFF), -1};
                n7 = this.normalReadCRC ? 4 : 3;
                this.ib.adapter.dataBlock(byArray3, 0, n7);
            }
            int n8 = n3 / this.pageLength;
            n7 = n3 % this.pageLength;
            int n9 = 0;
            while (n9 < n8) {
                System.arraycopy(this.ffBlock, 0, byArray, n2 + n9 * this.pageLength, this.pageLength);
                ++n9;
            }
            System.arraycopy(this.ffBlock, 0, byArray, n2 + n8 * this.pageLength, n7);
            this.ib.adapter.dataBlock(byArray, n2, n3);
        }
    }

    public void write(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 == 0) {
            return;
        }
        if (!this.ib.adapter.canProgram()) {
            throw new OneWireException("Program voltage required but not available");
        }
        if (this.isReadOnly()) {
            throw new OneWireException("Trying to write read-only memory bank");
        }
        if (n + n3 > this.pageLength * this.numberPages) {
            throw new OneWireException("Write exceeds memory bank end");
        }
        this.ib.adapter.setProgramPulseDuration(7);
        this.checkSpeed();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            byte by = this.programByte(n + n4 + this.startPhysicalAddress, byArray[n2 + n4], bl);
            if (this.writeVerification) {
                if (by == byArray[n2 + n4]) {
                    bl = true;
                } else {
                    this.forceVerify();
                    throw new OneWireIOException("Read back byte on EPROM programming did not match");
                }
            }
            ++n4;
        }
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        if (this.pageAutoCRC) {
            this.readPageCRC(n, bl, byArray, n2, null, this.extraInfoLength);
        } else {
            this.read(n * this.pageLength, bl, byArray, n2, this.pageLength);
        }
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        if (!this.extraInfo) {
            throw new OneWireException("Read extra information not supported on this memory bank");
        }
        this.readPageCRC(n, bl, byArray, n2, byArray2, this.extraInfoLength);
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        byte[] byArray3 = new byte[this.pageLength];
        if (!this.extraInfo) {
            throw new OneWireException("Read extra information not supported on this memory bank");
        }
        this.readPageCRC(n, bl, byArray3, 0, byArray2, this.extraInfoLength);
        if ((byArray3[0] & 0xFF) > this.maxPacketDataLength) {
            this.forceVerify();
            throw new OneWireIOException("Invalid length in packet");
        }
        if (CRC16.compute(byArray3, 0, byArray3[0] + 3, n) == 45057) {
            System.arraycopy(byArray3, 1, byArray, n2, byArray3[0]);
            return byArray3[0];
        }
        this.forceVerify();
        throw new OneWireIOException("Invalid CRC16 in packet read");
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[this.pageLength];
        this.readPageCRC(n, bl, byArray2, 0, null, this.extraInfoLength);
        if ((byArray2[0] & 0xFF) > this.maxPacketDataLength) {
            this.forceVerify();
            throw new OneWireIOException("Invalid length in packet");
        }
        if (CRC16.compute(byArray2, 0, byArray2[0] + 3, n) == 45057) {
            System.arraycopy(byArray2, 1, byArray, n2, byArray2[0]);
            return byArray2[0];
        }
        this.forceVerify();
        throw new OneWireIOException("Invalid CRC16 in packet read");
    }

    public void writePagePacket(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 > this.maxPacketDataLength) {
            throw new OneWireIOException("Length of packet requested exceeds page size");
        }
        if (!this.generalPurposeMemory) {
            throw new OneWireException("Current bank is not general purpose memory");
        }
        byte[] byArray2 = new byte[n3 + 3];
        byArray2[0] = (byte)n3;
        System.arraycopy(byArray, n2, byArray2, 1, n3);
        int n4 = CRC16.compute(byArray2, 0, n3 + 1, n);
        byArray2[n3 + 1] = (byte)(~n4 & 0xFF);
        byArray2[n3 + 2] = (byte)((~n4 & 0xFFFF) >>> 8 & 0xFF);
        this.write(n * this.pageLength, byArray2, 0, n3 + 3);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        this.readPageCRC(n, bl, byArray, n2, null, this.extraInfoLength);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        this.readPageCRC(n, bl, byArray, n2, byArray2, this.extraInfoLength);
    }

    public void lockPage(int n) throws OneWireIOException, OneWireException {
        int n2 = n >>> 3;
        int n3 = n - (n2 << 3);
        byte[] byArray = new byte[]{(byte)(~(1 << n3))};
        this.mbLock.setWriteVerification(false);
        this.mbLock.write(n2 + this.lockOffset, byArray, 0, 1);
        if (!this.isPageLocked(n)) {
            this.forceVerify();
            throw new OneWireIOException("Read back from write incorrect, could not lock page");
        }
    }

    public boolean isPageLocked(int n) throws OneWireIOException, OneWireException {
        int n2 = this.mbLock.getPageLength();
        int n3 = (n + this.lockOffset) / (n2 * 8);
        byte[] byArray = new byte[n2];
        this.mbLock.readPageCRC(n3, false, byArray, 0);
        int n4 = n + this.lockOffset - n3 * 8 * n2;
        int n5 = n4 >>> 3;
        int n6 = n4 - (n5 << 3);
        return (byArray[n5] >>> n6 & 1) != 1;
    }

    public void redirectPage(int n, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[]{(byte)(~n2)};
        this.mbRedirect.setWriteVerification(true);
        this.mbRedirect.write(n + this.redirectOffset, byArray, 0, 1);
    }

    public int isPageRedirected(int n) throws OneWireIOException, OneWireException {
        int n2 = this.mbRedirect.getPageLength();
        int n3 = (n + this.redirectOffset) / n2;
        byte[] byArray = new byte[n2];
        this.mbRedirect.readPageCRC(n3, false, byArray, 0);
        return ~byArray[(n + this.redirectOffset) % n2] & 0xFF;
    }

    public int getRedirectedPage(int n) throws OneWireIOException, OneWireException {
        int n2 = this.mbRedirect.getPageLength();
        int n3 = (n + this.redirectOffset) / n2;
        byte[] byArray = new byte[n2];
        this.mbRedirect.readPageCRC(n3, false, byArray, 0);
        return ~byArray[(n + this.redirectOffset) % n2] & 0xFF;
    }

    public void lockRedirectPage(int n) throws OneWireIOException, OneWireException {
        int n2 = n >>> 3;
        int n3 = n - (n2 << 3);
        byte[] byArray = new byte[]{(byte)(~(1 << n3))};
        this.mbLockRedirect.setWriteVerification(false);
        this.mbLockRedirect.write(n2 + this.lockRedirectOffset, byArray, 0, 1);
        if (!this.isRedirectPageLocked(n)) {
            this.forceVerify();
            throw new OneWireIOException("Read back from write incorrect, could not lock redirect byte");
        }
    }

    public boolean isRedirectPageLocked(int n) throws OneWireIOException, OneWireException {
        int n2 = this.mbLockRedirect.getPageLength();
        int n3 = (n + this.lockRedirectOffset) / (n2 * 8);
        byte[] byArray = new byte[n2];
        this.mbLockRedirect.readPageCRC(n3, false, byArray, 0);
        int n4 = n + this.lockRedirectOffset - n3 * 8 * n2;
        int n5 = n4 >>> 3;
        int n6 = n4 - (n5 << 3);
        return (byArray[n5] >>> n6 & 1) != 1;
    }

    protected void readPageCRC(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2, int n3) throws OneWireIOException, OneWireException {
        int n4 = 0;
        int n5 = 0;
        byte[] byArray3 = new byte[this.pageLength + this.numCRCBytes];
        if (!this.pageAutoCRC) {
            throw new OneWireException("Read page with CRC not supported in this memory bank");
        }
        if (!bl) {
            this.checkSpeed();
        }
        if (n > this.numberPages) {
            throw new OneWireException("Read exceeds memory bank end");
        }
        if (!bl) {
            if (!this.ib.adapter.select(this.ib.address)) {
                this.forceVerify();
                throw new OneWireIOException("Device select failed");
            }
            n4 = 3 + this.extraInfoLength;
            if (this.crcAfterAddress) {
                n4 += this.numCRCBytes;
            }
            System.arraycopy(this.ffBlock, 0, byArray3, 0, n4);
            byArray3[0] = this.READ_PAGE_WITH_CRC;
            int n6 = n * this.pageLength + this.startPhysicalAddress;
            byArray3[1] = (byte)(n6 & 0xFF);
            byArray3[2] = (byte)((n6 & 0xFFFF) >>> 8 & 0xFF);
            this.ib.adapter.dataBlock(byArray3, 0, n4);
        } else if (this.extraInfoLength > 0) {
            n4 = this.extraInfoLength + this.numCRCBytes;
            System.arraycopy(this.ffBlock, 0, byArray3, 0, n4);
            this.ib.adapter.dataBlock(byArray3, 0, n4);
        }
        n5 = this.numCRCBytes == 2 ? CRC16.compute(byArray3, 0, n4, 0) : CRC8.compute(byArray3, 0, n4, 0);
        if (this.extraInfoLength > 0 || this.crcAfterAddress) {
            if (this.numCRCBytes == 2) {
                if (n5 != 45057) {
                    this.forceVerify();
                    throw new OneWireIOException("Invalid CRC16 read from device");
                }
            } else if (n5 != 0) {
                this.forceVerify();
                throw new OneWireIOException("Invalid CRC8 read from device");
            }
            n5 = 0;
            if (this.extraInfoLength > 0 && byArray2 != null) {
                System.arraycopy(byArray3, n4 - this.extraInfoLength - this.numCRCBytes, byArray2, 0, n3);
            }
        }
        System.arraycopy(this.ffBlock, 0, byArray3, 0, byArray3.length);
        this.ib.adapter.dataBlock(byArray3, 0, byArray3.length);
        if (this.numCRCBytes == 2) {
            if (CRC16.compute(byArray3, 0, byArray3.length, n5) != 45057) {
                this.forceVerify();
                throw new OneWireIOException("Invalid CRC16 read from device");
            }
        } else if (CRC8.compute(byArray3, 0, byArray3.length, n5) != 0) {
            this.forceVerify();
            throw new OneWireIOException("Invalid CRC8 read from device");
        }
        System.arraycopy(byArray3, 0, byArray, n2, this.pageLength);
    }

    protected byte programByte(int n, byte by, boolean bl) throws OneWireIOException, OneWireException {
        int n2 = 0;
        if (!bl) {
            int n3;
            if (!this.ib.adapter.select(this.ib.address)) {
                this.forceVerify();
                throw new OneWireIOException("device not present");
            }
            byte[] byArray = new byte[6];
            System.arraycopy(this.ffBlock, 0, byArray, 0, byArray.length);
            byArray[0] = this.WRITE_MEMORY_COMMAND;
            byArray[1] = (byte)(n & 0xFF);
            byArray[2] = (byte)((n & 0xFFFF) >>> 8 & 0xFF);
            byArray[3] = by;
            if (this.numCRCBytes == 2) {
                n2 = CRC16.compute(byArray, 0, 4, 0);
                n3 = 6;
            } else {
                n2 = CRC8.compute(byArray, 0, 4, 0);
                n3 = 5;
            }
            this.ib.adapter.dataBlock(byArray, 0, n3);
            if (this.numCRCBytes == 2) {
                if (CRC16.compute(byArray, 4, 2, n2) != 45057) {
                    this.forceVerify();
                    throw new OneWireIOException("Invalid CRC16 read from device");
                }
            } else if (CRC8.compute(byArray, 4, 1, n2) != 0) {
                this.forceVerify();
                throw new OneWireIOException("Invalid CRC8 read from device");
            }
        } else {
            this.ib.adapter.putByte(by);
            if (this.numCRCBytes == 2) {
                n2 = CRC16.compute(by, n);
                n2 = CRC16.compute(this.ib.adapter.getByte(), n2);
                if (CRC16.compute(this.ib.adapter.getByte(), n2) != 45057) {
                    this.forceVerify();
                    throw new OneWireIOException("Invalid CRC16 read from device");
                }
            } else {
                n2 = CRC8.compute(by, n);
                if (CRC8.compute(this.ib.adapter.getByte(), n2) != 0) {
                    this.forceVerify();
                    throw new OneWireIOException("Invalid CRC8 read from device");
                }
            }
        }
        this.ib.adapter.startProgramPulse(0);
        return (byte)this.ib.adapter.getByte();
    }

    public void checkSpeed() throws OneWireIOException, OneWireException {
        MemoryBankEPROM memoryBankEPROM = this;
        synchronized (memoryBankEPROM) {
            if (this.doSetSpeed) {
                this.ib.doSpeed();
                this.doSetSpeed = false;
            }
        }
    }

    public void forceVerify() {
        MemoryBankEPROM memoryBankEPROM = this;
        synchronized (memoryBankEPROM) {
            this.doSetSpeed = true;
        }
    }
}

