/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.utils.CRC16;

class MemoryBankEE
implements PagedMemoryBank {
    public static final byte READ_MEMORY_COMMAND = -16;
    public static final byte WRITE_SCRATCHPAD_COMMAND = 15;
    public static final byte READ_SCRATCHPAD_COMMAND = -86;
    public static final byte COPY_SCRATCHPAD_COMMAND = 85;
    public static final int PAGE_LENGTH = 32;
    protected OneWireContainer ib;
    protected byte[] ffBlock;
    protected boolean writeVerification;
    protected boolean doSetSpeed;

    public MemoryBankEE(OneWireContainer oneWireContainer) {
        MemoryBankEE memoryBankEE = this;
        synchronized (memoryBankEE) {
            this.ib = oneWireContainer;
            this.ffBlock = new byte[50];
            int n = 0;
            while (n < 50) {
                this.ffBlock[n] = -1;
                ++n;
            }
            this.writeVerification = true;
            this.doSetSpeed = true;
        }
    }

    public String getBankDescription() {
        return "Main Memory";
    }

    public boolean isGeneralPurposeMemory() {
        return true;
    }

    public boolean isReadWrite() {
        return true;
    }

    public boolean isWriteOnce() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isNonVolatile() {
        return true;
    }

    public boolean needsProgramPulse() {
        return false;
    }

    public boolean needsPowerDelivery() {
        return true;
    }

    public int getStartPhysicalAddress() {
        return 0;
    }

    public int getSize() {
        return 32;
    }

    public void setWriteVerification(boolean bl) {
        this.writeVerification = bl;
    }

    public int getNumberPages() {
        return 1;
    }

    public int getPageLength() {
        return 32;
    }

    public int getMaxPacketDataLength() {
        return 29;
    }

    public boolean hasPageAutoCRC() {
        return false;
    }

    public boolean haveExtraInfo() {
        return false;
    }

    public boolean hasExtraInfo() {
        return false;
    }

    public int getExtraInfoLength() {
        return 0;
    }

    public String getExtraInfoDescription() {
        return null;
    }

    public void read(int n, boolean bl, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        int n4 = 0;
        byte[] byArray2 = new byte[2];
        if (!bl) {
            this.checkSpeed();
        }
        if (n + n3 > 32) {
            throw new OneWireException("Read exceeds memory bank end");
        }
        do {
            if (!this.ib.adapter.select(this.ib.address)) {
                this.forceVerify();
                throw new OneWireIOException("Device select failed");
            }
            byArray2[0] = -16;
            byArray2[1] = (byte)(n & 0xFF);
            this.ib.adapter.dataBlock(byArray2, 0, 2);
            System.arraycopy(this.ffBlock, 0, byArray, n2, n3);
            this.ib.adapter.dataBlock(byArray, n2, n3);
            int n5 = 0;
            while (n5 < n3) {
                if (byArray[n2 + n5] != -1) {
                    return;
                }
                ++n5;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.ib.isPresent()) continue;
            this.forceVerify();
            throw new OneWireIOException("Device not present on 1-Wire");
        } while (++n4 < 6);
    }

    public void write(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 == 0) {
            return;
        }
        if (!this.ib.adapter.canDeliverPower()) {
            throw new OneWireException("Power delivery required but not available");
        }
        this.checkSpeed();
        if (n + n3 > 32) {
            throw new OneWireException("Write exceeds memory bank end");
        }
        this.writeScratchpad(n, byArray, n2, n3);
        byte[] byArray2 = new byte[32];
        this.readScratchpad(byArray2, n, 0, 32);
        int n4 = 0;
        while (n4 < n3) {
            if (byArray2[n4] != byArray[n4 + n2]) {
                this.forceVerify();
                throw new OneWireIOException("Read back scratchpad verify had incorrect data");
            }
            ++n4;
        }
        this.copyScratchpad();
        if (this.writeVerification) {
            this.read(n, false, byArray2, 0, n3);
            n4 = 0;
            while (n4 < n3) {
                if (byArray2[n4] != byArray[n4 + n2]) {
                    this.forceVerify();
                    throw new OneWireIOException("Read back verify had incorrect data");
                }
                ++n4;
            }
        }
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        if (n != 0) {
            throw new OneWireException("Page read exceeds memory bank end");
        }
        this.read(0, bl, byArray, n2, 32);
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with extra-info not supported by this memory bank");
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[32];
        this.checkSpeed();
        this.readPage(n, bl, byArray2, 0);
        if (byArray2[0] > 29) {
            this.forceVerify();
            throw new OneWireIOException("Invalid length in packet");
        }
        if (CRC16.compute(byArray2, 0, byArray2[0] + 3, n) == 45057) {
            System.arraycopy(byArray2, 1, byArray, n2, byArray2[0]);
            return byArray2[0];
        }
        this.forceVerify();
        throw new OneWireIOException("Invalid CRC16 in packet read");
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page packet with extra-info not supported by this memory bank");
    }

    public void writePagePacket(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 > 29) {
            throw new OneWireIOException("Length of packet requested exceeds page size");
        }
        byte[] byArray2 = new byte[n3 + 3];
        byArray2[0] = (byte)n3;
        System.arraycopy(byArray, n2, byArray2, 1, n3);
        int n4 = CRC16.compute(byArray2, 0, n3 + 1, n);
        byArray2[n3 + 1] = (byte)(~n4 & 0xFF);
        byArray2[n3 + 2] = (byte)((~n4 & 0xFFFF) >>> 8 & 0xFF);
        this.write(n * 32, byArray2, 0, n3 + 3);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with CRC not supported by this memory bank");
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with CRC and extra-info not supported by this memory bank");
    }

    protected void readScratchpad(byte[] byArray, int n, int n2, int n3) throws OneWireIOException, OneWireException {
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byte[] byArray2 = new byte[]{-86, (byte)n};
        this.ib.adapter.dataBlock(byArray2, 0, 2);
        System.arraycopy(this.ffBlock, 0, byArray, n2, n3);
        this.ib.adapter.dataBlock(byArray, n2, n3);
    }

    protected void writeScratchpad(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byte[] byArray2 = new byte[n3 + 2];
        byArray2[0] = 15;
        byArray2[1] = (byte)(n & 0xFF);
        System.arraycopy(byArray, n2, byArray2, 2, n3);
        this.ib.adapter.dataBlock(byArray2, 0, n3 + 2);
    }

    protected void copyScratchpad() throws OneWireIOException, OneWireException {
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        try {
            this.ib.adapter.putByte(85);
            this.ib.adapter.setPowerDuration(5);
            this.ib.adapter.startPowerDelivery(2);
            this.ib.adapter.putByte(-91);
            Thread.sleep(10L);
            this.ib.adapter.setPowerNormal();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void checkSpeed() throws OneWireIOException, OneWireException {
        MemoryBankEE memoryBankEE = this;
        synchronized (memoryBankEE) {
            if (this.doSetSpeed) {
                this.ib.doSpeed();
                this.doSetSpeed = false;
            }
        }
    }

    public void forceVerify() {
        MemoryBankEE memoryBankEE = this;
        synchronized (memoryBankEE) {
            this.doSetSpeed = true;
        }
    }
}

