/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OTPMemoryBank;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.CRC16;

class MemoryBankAppReg
implements OTPMemoryBank {
    public static final int PAGE_SIZE = 8;
    public static final byte READ_MEMORY_COMMAND = -61;
    public static final byte WRITE_MEMORY_COMMAND = -103;
    public static final byte COPY_LOCK_COMMAND = 90;
    public static final byte READ_STATUS_COMMAND = 102;
    public static final byte VALIDATION_KEY = -91;
    public static final byte LOCKED_FLAG = -4;
    protected OneWireContainer ib;
    protected byte[] ffBlock;
    protected int size;
    protected static String bankDescription = "Application register, non-volatile when locked";
    protected boolean writeVerification;
    protected int extraInfoLength;
    protected static String extraInfoDescription = "Page Locked flag";

    public MemoryBankAppReg(OneWireContainer oneWireContainer) {
        this.ib = oneWireContainer;
        this.writeVerification = true;
        this.ffBlock = new byte[50];
        int n = 0;
        while (n < 50) {
            this.ffBlock[n] = -1;
            ++n;
        }
    }

    public String getBankDescription() {
        return bankDescription;
    }

    public boolean isGeneralPurposeMemory() {
        return true;
    }

    public boolean isReadWrite() {
        return true;
    }

    public boolean isWriteOnce() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isNonVolatile() {
        return false;
    }

    public boolean needsProgramPulse() {
        return false;
    }

    public boolean needsPowerDelivery() {
        return true;
    }

    public int getStartPhysicalAddress() {
        return 0;
    }

    public int getSize() {
        return 8;
    }

    public int getNumberPages() {
        return 1;
    }

    public int getPageLength() {
        return 8;
    }

    public int getMaxPacketDataLength() {
        return 6;
    }

    public boolean hasPageAutoCRC() {
        return false;
    }

    public boolean haveExtraInfo() {
        return true;
    }

    public boolean hasExtraInfo() {
        return true;
    }

    public int getExtraInfoLength() {
        return 1;
    }

    public String getExtraInfoDescription() {
        return extraInfoDescription;
    }

    public void setWriteVerification(boolean bl) {
        this.writeVerification = bl;
    }

    public boolean canRedirectPage() {
        return false;
    }

    public boolean canLockPage() {
        return true;
    }

    public boolean canLockRedirectPage() {
        return false;
    }

    public void read(int n, boolean bl, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n + n3 > 8) {
            throw new OneWireException("Read exceeds memory bank end");
        }
        this.ib.doSpeed();
        if (!this.ib.adapter.select(this.ib.address)) {
            throw new OneWireIOException("Device select failed");
        }
        this.ib.adapter.putByte(-61);
        this.ib.adapter.putByte(n & 0xFF);
        System.arraycopy(this.ffBlock, 0, byArray, n2, n3);
        this.ib.adapter.dataBlock(byArray, n2, n3);
    }

    public void write(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 == 0) {
            return;
        }
        if (!this.ib.adapter.canDeliverPower()) {
            throw new OneWireException("Power delivery required but not available");
        }
        if (n + n3 > 8) {
            throw new OneWireException("Write exceeds memory bank end");
        }
        this.ib.doSpeed();
        if (!this.ib.adapter.select(this.ib.address)) {
            throw new OneWireIOException("Device select failed");
        }
        this.ib.adapter.putByte(-103);
        this.ib.adapter.putByte(n & 0xFF);
        this.ib.adapter.dataBlock(byArray, n2, n3);
        if (this.writeVerification) {
            byte[] byArray2 = new byte[n3];
            this.read(n, true, byArray2, 0, n3);
            int n4 = 0;
            while (n4 < n3) {
                if (byArray2[n4] != byArray[n4 + n2]) {
                    throw new OneWireIOException("Read back from write compare is incorrect, page may be locked");
                }
                ++n4;
            }
        }
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        if (n != 0) {
            throw new OneWireException("Invalid page number for this memory bank");
        }
        this.read(0, true, byArray, n2, 8);
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        this.read(n, true, byArray, n2, 8);
        this.readStatus(byArray2);
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        byte[] byArray3 = new byte[8];
        this.read(n, true, byArray3, 0, 8);
        if (byArray3[0] > 6) {
            throw new OneWireIOException("Invalid length in packet");
        }
        if (CRC16.compute(byArray3, 0, byArray3[0] + 3, n) == 45057) {
            System.arraycopy(byArray3, 1, byArray, n2, byArray3[0]);
            this.readStatus(byArray2);
            return byArray3[0];
        }
        throw new OneWireIOException("Invalid CRC16 in packet read");
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[8];
        this.read(n, true, byArray2, 0, 8);
        if (byArray2[0] > 6) {
            throw new OneWireIOException("Invalid length in packet");
        }
        if (CRC16.compute(byArray2, 0, byArray2[0] + 3, n) == 45057) {
            System.arraycopy(byArray2, 1, byArray, n2, byArray2[0]);
            return byArray2[0];
        }
        throw new OneWireIOException("Invalid CRC16 in packet read");
    }

    public void writePagePacket(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 > 6) {
            throw new OneWireIOException("Length of packet requested exceeds page size");
        }
        byte[] byArray2 = new byte[n3 + 3];
        byArray2[0] = (byte)n3;
        System.arraycopy(byArray, n2, byArray2, 1, n3);
        int n4 = CRC16.compute(byArray2, 0, n3 + 1, n);
        byArray2[n3 + 1] = (byte)(~n4 & 0xFF);
        byArray2[n3 + 2] = (byte)((~n4 & 0xFFFF) >>> 8 & 0xFF);
        this.write(n * 8, byArray2, 0, n3 + 3);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with CRC not supported by this memory bank");
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with CRC not supported by this memory bank");
    }

    public void lockPage(int n) throws OneWireIOException, OneWireException {
        this.ib.doSpeed();
        if (!this.ib.adapter.select(this.ib.address)) {
            throw new OneWireIOException("Device select failed");
        }
        this.ib.adapter.putByte(90);
        this.ib.adapter.putByte(-91);
        if (!this.isPageLocked(n)) {
            throw new OneWireIOException("Read back from write incorrect, could not lock page");
        }
    }

    public boolean isPageLocked(int n) throws OneWireIOException, OneWireException {
        if (n != 0) {
            throw new OneWireException("Invalid page number for this memory bank");
        }
        this.ib.doSpeed();
        return this.readStatus() == -4;
    }

    public void redirectPage(int n, int n2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Page redirection not supported by this memory bank");
    }

    public int isPageRedirected(int n) throws OneWireIOException, OneWireException {
        return 0;
    }

    public int getRedirectedPage(int n) throws OneWireIOException, OneWireException {
        return 0;
    }

    public void lockRedirectPage(int n) throws OneWireIOException, OneWireException {
        throw new OneWireException("Lock Page redirection not supported by this memory bank");
    }

    public boolean isRedirectPageLocked(int n) throws OneWireIOException, OneWireException {
        return false;
    }

    protected void readStatus(byte[] byArray) throws OneWireIOException, OneWireException {
        byArray[0] = this.readStatus();
    }

    protected byte readStatus() throws OneWireIOException, OneWireException {
        if (!this.ib.adapter.select(this.ib.address)) {
            throw new OneWireIOException("Device select failed");
        }
        this.ib.adapter.putByte(102);
        this.ib.adapter.putByte(0);
        return (byte)this.ib.adapter.getByte();
    }
}

