/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.container.PagedMemoryBank;
import com.dalsemi.onewire.utils.CRC16;

class MemoryBankAD
implements PagedMemoryBank {
    public static final byte READ_MEMORY_COMMAND = -86;
    public static final byte WRITE_MEMORY_COMMAND = 85;
    public static final int PAGE_LENGTH = 8;
    protected OneWireContainer ib;
    protected byte[] ffBlock;
    protected boolean writeVerification;
    protected boolean doSetSpeed;
    protected String bankDescription;
    protected boolean generalPurposeMemory;
    protected boolean readWrite;
    protected boolean writeOnce;
    protected boolean readOnly;
    protected boolean nonVolatile;
    protected int startPhysicalAddress;

    public MemoryBankAD(OneWireContainer oneWireContainer) {
        this.ib = oneWireContainer;
        this.ffBlock = new byte[50];
        int n = 0;
        while (n < 50) {
            this.ffBlock[n] = -1;
            ++n;
        }
        this.bankDescription = "A/D Conversion read-out";
        this.generalPurposeMemory = false;
        this.startPhysicalAddress = 0;
        this.readWrite = false;
        this.writeOnce = false;
        this.readOnly = true;
        this.nonVolatile = false;
        this.writeVerification = true;
        this.doSetSpeed = true;
    }

    public String getBankDescription() {
        return this.bankDescription;
    }

    public boolean isGeneralPurposeMemory() {
        return this.generalPurposeMemory;
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    public boolean isWriteOnce() {
        return this.writeOnce;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isNonVolatile() {
        return this.nonVolatile;
    }

    public boolean needsProgramPulse() {
        return false;
    }

    public boolean needsPowerDelivery() {
        return false;
    }

    public int getStartPhysicalAddress() {
        return this.startPhysicalAddress;
    }

    public int getSize() {
        return 8;
    }

    public void setWriteVerification(boolean bl) {
        this.writeVerification = bl;
    }

    public int getNumberPages() {
        return 1;
    }

    public int getPageLength() {
        return 8;
    }

    public int getMaxPacketDataLength() {
        return 5;
    }

    public boolean hasPageAutoCRC() {
        return true;
    }

    public boolean haveExtraInfo() {
        return false;
    }

    public boolean hasExtraInfo() {
        return false;
    }

    public int getExtraInfoLength() {
        return 0;
    }

    public String getExtraInfoDescription() {
        return null;
    }

    public void read(int n, boolean bl, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n + n3 > 8) {
            throw new OneWireException("Read exceeds memory bank end");
        }
        int n4 = n / 8;
        int n5 = (n + n3) / 8 - 1;
        if ((n + n3) % 8 > 0) {
            ++n5;
        }
        byte[] byArray2 = new byte[(n5 - n4 + 1) * 8];
        int n6 = n4;
        while (n6 <= n5) {
            this.readPageCRC(n6, n6 != n4, byArray2, (n6 - n4) * 8);
            ++n6;
        }
        System.arraycopy(byArray2, n % 8, byArray, n2, n3);
    }

    public void write(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[7];
        int n4 = 0;
        if (n3 == 0) {
            return;
        }
        this.checkSpeed();
        if (!this.ib.adapter.select(this.ib.address)) {
            this.forceVerify();
            throw new OneWireIOException("Device select failed");
        }
        byArray2[n4++] = 85;
        int n5 = n + this.startPhysicalAddress;
        int n6 = n5 + n3;
        byArray2[n4++] = (byte)(n5 & 0xFF);
        byArray2[n4++] = (byte)((n5 & 0xFFFF) >>> 8 & 0xFF);
        int n7 = n5;
        while (n7 < n6) {
            byArray2[n4++] = byArray[n2 + n7 - n5];
            int n8 = CRC16.compute(byArray2, 0, n4, n7 == n5 ? 0 : n7);
            System.arraycopy(this.ffBlock, 0, byArray2, n4, 3);
            this.ib.adapter.dataBlock(byArray2, 0, n4 + 3);
            if (CRC16.compute(byArray2, n4, 2, n8) != 45057) {
                this.forceVerify();
                throw new OneWireIOException("Invalid CRC16 read from device");
            }
            if (byArray2[n4 + 2] != byArray[n2 + n7 - n5]) {
                this.forceVerify();
                throw new OneWireIOException("Write byte echo was invalid");
            }
            n4 = 0;
            ++n7;
        }
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        this.readPageCRC(n, bl, byArray, n2);
    }

    public void readPage(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with extra-info not supported by this memory bank");
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[8];
        this.readPageCRC(n, bl, byArray2, 0);
        if (byArray2[0] > 5) {
            throw new OneWireIOException("Invalid length in packet");
        }
        if (CRC16.compute(byArray2, 0, byArray2[0] + 3, n) == 45057) {
            System.arraycopy(byArray2, 1, byArray, n2, byArray2[0]);
            return byArray2[0];
        }
        this.forceVerify();
        throw new OneWireIOException("Invalid CRC16 in packet read");
    }

    public int readPagePacket(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page packet with extra-info not supported by this memory bank");
    }

    public void writePagePacket(int n, byte[] byArray, int n2, int n3) throws OneWireIOException, OneWireException {
        if (n3 > 5) {
            throw new OneWireIOException("Length of packet requested exceeds page size");
        }
        byte[] byArray2 = new byte[n3 + 3];
        byArray2[0] = (byte)n3;
        System.arraycopy(byArray, n2, byArray2, 1, n3);
        int n4 = CRC16.compute(byArray2, 0, n3 + 1, n);
        byArray2[n3 + 1] = (byte)(~n4 & 0xFF);
        byArray2[n3 + 2] = (byte)((~n4 & 0xFFFF) >>> 8 & 0xFF);
        this.write(n * 8, byArray2, 0, n3 + 3);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2) throws OneWireIOException, OneWireException {
        int n3;
        byte[] byArray2 = new byte[13];
        if (!bl) {
            this.checkSpeed();
        }
        if (!bl) {
            if (!this.ib.adapter.select(this.ib.address)) {
                this.forceVerify();
                throw new OneWireIOException("Device select failed");
            }
            n3 = byArray2.length;
            System.arraycopy(this.ffBlock, 0, byArray2, 0, n3);
            byArray2[0] = -86;
            int n4 = n * 8 + this.startPhysicalAddress;
            byArray2[1] = (byte)(n4 & 0xFF);
            byArray2[2] = (byte)((n4 & 0xFFFF) >>> 8 & 0xFF);
        } else {
            n3 = 10;
            System.arraycopy(this.ffBlock, 0, byArray2, 0, n3);
        }
        this.ib.adapter.dataBlock(byArray2, 0, n3);
        if (CRC16.compute(byArray2, 0, n3, 0) != 45057) {
            this.forceVerify();
            throw new OneWireIOException("Invalid CRC16 read from device");
        }
        System.arraycopy(byArray2, n3 - 2 - 8, byArray, n2, 8);
    }

    public void readPageCRC(int n, boolean bl, byte[] byArray, int n2, byte[] byArray2) throws OneWireIOException, OneWireException {
        throw new OneWireException("Read page with CRC and extra-info not supported by this memory bank");
    }

    public void checkSpeed() throws OneWireIOException, OneWireException {
        MemoryBankAD memoryBankAD = this;
        synchronized (memoryBankAD) {
            if (this.doSetSpeed) {
                this.ib.doSpeed();
                this.doSetSpeed = false;
            }
        }
    }

    public void forceVerify() {
        MemoryBankAD memoryBankAD = this;
        synchronized (memoryBankAD) {
            this.doSetSpeed = true;
        }
    }
}

