/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.utils.CRC16;
import java.io.ByteArrayOutputStream;

class JibComm {
    private static final byte COPROCESSOR_ACCELERATOR_RUNNING = 1;
    private static final byte POWER_ON_RESET = 64;
    private static final byte COMMAND_COMPLETE = 11;
    private static final byte COMMAND_NOT_COMPLETE = 32;
    private static final byte FIRST_BIRTHDAY = 29;
    private static final byte MASTER_ERASE_PROBLEM = 31;
    private static final byte WRITE_IPR_COMMAND = 15;
    private static final byte READ_IPR_COMMAND = -86;
    private static final byte WRITE_IO_BUFFER_COMMAND = 45;
    private static final byte READ_IO_BUFFER_COMMAND = 34;
    private static final byte INTERRUPT_MICRO_COMMAND = 119;
    private static final byte RUN_MICRO_COMMAND = -121;
    private static final byte RESET_MICRO_COMMAND = -35;
    private static final byte READ_STATUS_COMMAND = -31;
    private static final byte WRITE_STATUS_COMMAND = -46;
    private static final int HEADER_SIZE = 8;
    private final int MAX_BLOCK_SIZE = 120;
    private static final int MIN_RUNTIME_IN_MILLIS = 96;
    private static final int MAX_RUNTIME_IN_MILLIS = 3813;
    private static final int MIN_RUNTIME = 0;
    private static final int MAX_RUNTIME = 15;
    private static final int SEND = 1;
    private static final int RECEIVE = 2;
    private DSPortAdapter adapter;
    private byte[] address = new byte[8];
    private static boolean doDebugMessages = false;
    private boolean shouldCorrectPOR = false;
    private byte[] ffBlock;

    public JibComm(DSPortAdapter dSPortAdapter, byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("iButton Address must be of length 8.");
        }
        System.arraycopy(byArray, 0, this.address, 0, this.address.length);
        this.adapter = dSPortAdapter;
        this.ffBlock = new byte[130];
        int n = 0;
        while (n < 130) {
            this.ffBlock[n] = -1;
            ++n;
        }
    }

    public byte[] transferJibData(byte[] byArray, int n) throws OneWireException, OneWireIOException, IllegalArgumentException {
        if (n > 15 || n < 0) {
            throw new IllegalArgumentException("Run Time value should be between 0 and 15.");
        }
        BlockDataFragmenter blockDataFragmenter = new BlockDataFragmenter(byArray);
        this.shouldCorrectPOR = true;
        if (this.adapter.getSpeed() != 2) {
            throw new OneWireIOException("Adapter not in overdrive mode.");
        }
        if (doDebugMessages) {
            System.out.println("Sending data to Java iButton.");
        }
        while (true) {
            this.checkStatus(0, 1);
            this.setHeader(blockDataFragmenter.getNextHeaderToSend());
            this.setData(blockDataFragmenter.getNextDataToSend());
            if (doDebugMessages) {
                System.out.println("Data has been written.");
            }
            if (!blockDataFragmenter.hasMore()) break;
            this.setStatus(0);
            this.interrupt(0);
        }
        this.setStatus(n);
        this.interrupt(n);
        byte[] byArray2 = new byte[8];
        while (true) {
            byte[] byArray3 = this.checkStatus(n, 2);
            byArray2 = this.getHeader();
            byArray = this.getData(byArray2[1]);
            if (doDebugMessages) {
                System.out.println("Data read back successfully.");
            }
            blockDataFragmenter.checkBlock(byArray2, byArray);
            if (byArray3[2] == 11) break;
            this.setStatus(0);
            this.run(0);
        }
        return blockDataFragmenter.getDataFromRead();
    }

    public void correctPOR() throws OneWireException, OneWireIOException {
        if (doDebugMessages) {
            System.out.println("Attempting to correct the POR!");
        }
        this.reset();
        this.setStatus(0);
        this.run(0);
    }

    public byte[] getStatus() throws OneWireException, OneWireIOException {
        byte[] byArray = new byte[7];
        byArray[0] = -31;
        System.arraycopy(this.ffBlock, 0, byArray, 1, 6);
        if (this.adapter.select(this.address)) {
            this.adapter.dataBlock(byArray, 0, 7);
            byArray[1] = (byte)(byArray[1] & 0xFFFFFFFE);
            if (CRC16.compute(byArray, 0, 7, 0) != 45057) {
                throw new OneWireIOException("Bad CRC on data returned in Read Status method.");
            }
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 1, byArray2, 0, 4);
            return byArray2;
        }
        throw new OneWireIOException("JibComm Error - Device not found on One-Wire Bus.");
    }

    public byte[] checkStatus(int n, int n2) throws OneWireIOException, OneWireException {
        byte[] byArray;
        int n3 = 0;
        while (true) {
            if (++n3 > 200) {
                throw new OneWireException("Unrecoverable error.  Fail.");
            }
            byArray = this.getStatus();
            if ((byArray[2] & 0x40) != 0) {
                if (!this.shouldCorrectPOR) {
                    throw new OneWireException("POR of Device is set.");
                }
                this.correctPOR();
                this.shouldCorrectPOR = false;
                continue;
            }
            if ((byArray[3] & 1) != 0) {
                if (doDebugMessages) {
                    System.out.println("Coprocessor still running.");
                }
                this.run(n + 6);
                continue;
            }
            if ((byArray[2] & 0x1F) == 29 || (byArray[2] & 0x1F) == 31) {
                if (doDebugMessages) {
                    System.out.println("FirstBirth identified.");
                }
                this.setStatus(12);
                this.run(13);
                continue;
            }
            if ((byArray[2] & 0x20) == 0) break;
            if (n == 0) {
                n = 2;
            } else if (n < 8) {
                n *= 2;
            }
            this.setStatus(n);
            this.run(n + 1);
        }
        if (n2 == 1) {
            if (byArray[0] < 8) {
                throw new OneWireIOException("JibComm Error - No room in header input buffer.");
            }
        } else {
            if (byArray[1] == 0) {
                throw new OneWireIOException("JibComm Error - No header in output buffer.");
            }
            if (byArray[1] != 8) {
                throw new OneWireIOException("JibComm Error - Bad header in output buffer.");
            }
        }
        return byArray;
    }

    public void setStatus(int n) throws OneWireException, OneWireIOException {
        if (n > 15) {
            n = 15;
        }
        byte[] byArray = new byte[]{-46, (byte)(n & 0xF), -1, -1};
        byte[] byArray2 = new byte[]{127, 81};
        this.sendCommand(byArray, byArray2, false, 0L);
    }

    public void setHeader(byte[] byArray) throws OneWireException, OneWireIOException, IllegalArgumentException {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("The header must be of length 8");
        }
        byte[] byArray2 = new byte[12];
        byArray2[0] = 45;
        byArray2[1] = 8;
        System.arraycopy(byArray, 0, byArray2, 2, 8);
        byArray2[10] = -1;
        byArray2[11] = -1;
        byte[] byArray3 = new byte[]{-77, -99};
        this.sendCommand(byArray2, byArray3, false, 0L);
    }

    public byte[] getHeader() throws OneWireException, OneWireIOException {
        byte[] byArray = new byte[12];
        byArray[0] = 34;
        byArray[1] = 8;
        System.arraycopy(this.ffBlock, 0, byArray, 2, 10);
        byte[] byArray2 = new byte[]{76, 98};
        this.sendCommand(byArray, byArray2, false, 0L);
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, 2, byArray3, 0, 8);
        return byArray3;
    }

    public void setData(byte[] byArray) throws OneWireException, OneWireIOException {
        byte[] byArray2 = new byte[4 + byArray.length];
        byArray2[0] = 15;
        byArray2[1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        byArray2[byArray.length + 2] = -1;
        byArray2[byArray.length + 3] = -1;
        this.sendCommand(byArray2, null, false, 0L);
    }

    public byte[] getData(int n) throws OneWireException, OneWireIOException {
        byte[] byArray = new byte[n + 4];
        byArray[0] = -86;
        byArray[1] = (byte)(n & 0xFF);
        System.arraycopy(this.ffBlock, 0, byArray, 2, n + 2);
        this.sendCommand(byArray, null, false, 0L);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 2, byArray2, 0, n);
        return byArray2;
    }

    public void run(int n) throws OneWireException, OneWireIOException {
        long l = n * 250 + 96 + 25;
        byte[] byArray = new byte[]{-121, 115, 93};
        this.sendCommand(null, byArray, true, l);
    }

    public void interrupt(int n) throws OneWireException, OneWireIOException {
        long l = n * 250 + 96 + 25;
        byte[] byArray = new byte[]{119, 67, 109};
        this.sendCommand(null, byArray, true, l);
    }

    public void reset() throws OneWireException, OneWireIOException {
        byte[] byArray = new byte[]{-35, -68, -110};
        this.sendCommand(null, byArray, false, 0L);
    }

    public void sendCommand(byte[] byArray, byte[] byArray2, boolean bl, long l) throws OneWireException, OneWireIOException {
        if (this.adapter.select(this.address)) {
            if (byArray != null) {
                this.adapter.dataBlock(byArray, 0, byArray.length);
            }
            if (byArray2 != null) {
                this.adapter.dataBlock(byArray2, 0, byArray2.length);
                if (bl) {
                    this.adapter.setPowerDuration(5);
                    this.adapter.startPowerDelivery(1);
                    if (this.adapter.getBit()) {
                        throw new OneWireIOException("Command not understood by Java iButton.");
                    }
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.adapter.setPowerNormal();
                } else if (this.adapter.getBit()) {
                    throw new OneWireIOException("Command not understood by Java iButton.");
                }
            }
        } else {
            throw new OneWireIOException("JibComm Error - Device not found on One Wire Bus.");
        }
    }

    class BlockDataFragmenter {
        private final long MAX_DATA_LENGTH = 16384L;
        private final int FINAL_BLOCK = 128;
        private byte[] dataBuffer;
        private int dataBufferLength;
        private ByteArrayOutputStream dataRead = new ByteArrayOutputStream();
        private boolean more = true;
        private byte[] currentHeader = new byte[8];
        private byte[] currentDataBlock;
        private int currentBlockLength;
        private int currentBlockNumber = 0;
        private int byteSent = 0;
        private long checkSum = 0L;

        public BlockDataFragmenter(byte[] byArray) {
            this.dataBufferLength = byArray.length;
            if (this.dataBufferLength == 0) {
                throw new IllegalArgumentException("Data array cannot be empty.");
            }
            if ((long)this.dataBufferLength > 16384L) {
                throw new IllegalArgumentException("Data array size cannot exceed 16384");
            }
            this.dataBuffer = new byte[this.dataBufferLength];
            System.arraycopy(byArray, 0, this.dataBuffer, 0, this.dataBufferLength);
        }

        public boolean hasMore() {
            return this.more;
        }

        public byte[] getNextHeaderToSend() {
            int n = this.byteSent;
            int n2 = this.currentBlockLength;
            int n3 = this.currentBlockNumber;
            int n4 = this.dataBufferLength;
            long l = this.checkSum;
            int n5 = n4 - n;
            int n6 = n2 = n5 > 120 ? 120 : n5;
            if (n5 == n2) {
                this.more = false;
                n3 |= 0x80;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.dataBuffer, n, byArray, 0, n2);
            int n7 = CRC16.compute(n2, 0);
            n7 = CRC16.compute(byArray, 0, n2, n7);
            byte[] byArray2 = this.currentHeader;
            byArray2[0] = (byte)n3;
            byArray2[1] = (byte)n2;
            byArray2[2] = (byte)(n5 & 0xFF);
            byArray2[3] = (byte)(n5 >> 8 & 0xFF);
            byArray2[4] = (byte)(n7 & 0xFF);
            byArray2[5] = (byte)(n7 >> 8 & 0xFF);
            l += (long)(byArray2[0] & 0xFF);
            l += (long)(byArray2[1] & 0xFF);
            l += (long)(byArray2[2] & 0xFF);
            l += (long)(byArray2[3] & 0xFF);
            l += (long)(byArray2[4] & 0xFF);
            l += (long)(byArray2[5] & 0xFF);
            int n8 = 0;
            while (n8 < n2) {
                l += (long)(byArray[n8] & 0xFF);
                ++n8;
            }
            byArray2[6] = (byte)(l & 0xFFL);
            byArray2[7] = (byte)(l >> 8 & 0xFFL);
            l += (long)byArray2[6];
            this.byteSent = n += n2;
            this.currentDataBlock = byArray;
            this.currentBlockLength = n2;
            this.currentBlockNumber = ++n3;
            this.checkSum = l += (long)byArray2[7];
            return byArray2;
        }

        public byte[] getNextDataToSend() {
            return this.currentDataBlock;
        }

        public void checkBlock(byte[] byArray, byte[] byArray2) throws OneWireIOException {
            int n = CRC16.compute(byArray[1], 0);
            n = CRC16.compute(byArray2, 0, byArray2.length, n);
            int n2 = byArray[5] & 0xFF;
            n2 <<= 8;
            if (n != (n2 |= byArray[4] & 0xFF)) {
                throw new OneWireIOException("CRC passed in header does not match CRC computed from passed data.");
            }
            this.dataRead.write(byArray2, 3, byArray2.length - 3);
        }

        public byte[] getDataFromRead() {
            return this.dataRead.toByteArray();
        }
    }
}

