/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.container;

public class CommandAPDU {
    public static final int CLA = 0;
    public static final int INS = 1;
    public static final int P1 = 2;
    public static final int P2 = 3;
    public static final int LC = 4;
    protected byte[] apduBuffer = null;
    protected int apduLength;

    public CommandAPDU(byte[] byArray) {
        this.apduLength = byArray.length;
        this.apduBuffer = new byte[this.apduLength];
        System.arraycopy(byArray, 0, this.apduBuffer, 0, this.apduLength);
    }

    public CommandAPDU(byte by, byte by2, byte by3, byte by4) {
        this(by, by2, by3, by4, null, -1);
    }

    public CommandAPDU(byte by, byte by2, byte by3, byte by4, int n) {
        this(by, by2, by3, by4, null, n);
    }

    public CommandAPDU(byte by, byte by2, byte by3, byte by4, byte[] byArray) {
        this(by, by2, by3, by4, byArray, -1);
    }

    public CommandAPDU(byte by, byte by2, byte by3, byte by4, byte[] byArray, int n) {
        this.apduLength = 4;
        if (byArray != null) {
            ++this.apduLength;
            this.apduLength += byArray.length;
        }
        if (n >= 0) {
            ++this.apduLength;
        }
        this.apduBuffer = new byte[this.apduLength];
        this.apduBuffer[0] = by;
        this.apduBuffer[1] = by2;
        this.apduBuffer[2] = by3;
        this.apduBuffer[3] = by4;
        if (byArray != null) {
            this.apduBuffer[4] = (byte)byArray.length;
            System.arraycopy(byArray, 0, this.apduBuffer, 5, byArray.length);
        }
        if (n >= 0) {
            this.apduBuffer[this.apduLength - 1] = (byte)n;
        }
    }

    public byte getCLA() {
        return this.apduBuffer[0];
    }

    public byte getINS() {
        return this.apduBuffer[1];
    }

    public byte getP1() {
        return this.apduBuffer[2];
    }

    public byte getP2() {
        return this.apduBuffer[3];
    }

    public int getLC() {
        if (this.apduLength >= 6) {
            return this.apduBuffer[4];
        }
        return 0;
    }

    public int getLE() {
        if (this.apduLength == 5 || this.apduLength == 6 + this.getLC()) {
            return this.apduBuffer[this.apduLength - 1];
        }
        return -1;
    }

    public final byte[] getBuffer() {
        return this.apduBuffer;
    }

    public final byte getByte(int n) {
        if (n >= this.apduLength) {
            return -1;
        }
        return this.apduBuffer[n];
    }

    public final byte[] getBytes() {
        byte[] byArray = new byte[this.apduLength];
        System.arraycopy(this.apduBuffer, 0, byArray, 0, this.apduLength);
        return byArray;
    }

    public final int getLength() {
        return this.apduLength;
    }

    public final void setByte(int n, byte by) {
        if (n < this.apduLength) {
            this.apduBuffer[n] = by;
        }
    }

    public String toString() {
        String string = "";
        string = string + "CLA = " + Integer.toHexString(this.apduBuffer[0] & 0xFF);
        string = string + " INS = " + Integer.toHexString(this.apduBuffer[1] & 0xFF);
        string = string + " P1 = " + Integer.toHexString(this.apduBuffer[2] & 0xFF);
        string = string + " P2 = " + Integer.toHexString(this.apduBuffer[3] & 0xFF);
        string = string + " LC = " + Integer.toHexString(this.getLC() & 0xFF);
        string = this.getLE() == -1 ? string + " LE = " + this.getLE() : string + " LE = " + Integer.toHexString(this.getLE() & 0xFF);
        if (this.apduLength > 5) {
            string = string + "\nDATA = ";
            int n = 5;
            while (n < this.getLC() + 5) {
                if ((this.apduBuffer[n] & 0xFF) < 16) {
                    string = string + '0';
                }
                string = string + Integer.toHexString(this.apduBuffer[n] & 0xFF) + " ";
                ++n;
            }
        }
        return string.toUpperCase();
    }
}

