/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.adapter;

import com.dalsemi.onewire.OneWireAccessProvider;
import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.adapter.OneWireState;
import com.dalsemi.onewire.adapter.RawSendPacket;
import com.dalsemi.onewire.adapter.SerialService;
import com.dalsemi.onewire.adapter.UAdapterState;
import com.dalsemi.onewire.adapter.UPacketBuilder;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.Bit;
import com.dalsemi.onewire.utils.CRC8;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.comm.CommPortIdentifier;

public class USerialAdapter
extends DSPortAdapter {
    private static final int ADAPTER_ID_FAMILY = 9;
    private static final int EXTENDED_READ_PAGE = 195;
    private static final char NORMAL_SEARCH_CMD = '\u00f0';
    private static final char ALARM_SEARCH_CMD = '\u00ec';
    private static String classVersion = "0.09";
    private static Hashtable serailServiceHash = new Hashtable(4);
    private static int maxBaud;
    private SerialService serial = null;
    private boolean adapterPresent = false;
    private boolean extraBytesReceived;
    UPacketBuilder uBuild;
    private OneWireState owState = new OneWireState();
    private UAdapterState uState = new UAdapterState(this.owState);
    private StringBuffer inBuffer;
    private boolean haveLocalUse = false;
    private Object syncObject;
    private static boolean doDebugMessages;

    public USerialAdapter() {
        this.uBuild = new UPacketBuilder(this.uState);
        this.inBuffer = new StringBuffer();
        this.syncObject = new Object();
    }

    public String getAdapterName() {
        return "DS9097U";
    }

    public String getPortTypeDescription() {
        return "serial communication port";
    }

    public String getClassVersion() {
        return classVersion;
    }

    public Enumeration getPortNames() {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = serailServiceHash.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            vector2.addElement((String)vector.elementAt(n));
            --n;
        }
        return vector2.elements();
    }

    public boolean selectPort(String string) throws OneWireIOException, OneWireException {
        this.serial = (SerialService)serailServiceHash.get(string);
        if (this.serial == null) {
            throw new OneWireException("USerialAdapter: selectPort(), Not such serial port: " + string);
        }
        try {
            this.beginLocalExclusive();
            this.serial.openPort();
            boolean bl = true;
            Object var4_3 = null;
            this.endLocalExclusive();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endLocalExclusive();
            throw throwable;
        }
    }

    public String getPortName() throws OneWireException {
        if (this.serial != null) {
            return this.serial.getName();
        }
        throw new OneWireException("USerialAdapter-getPortName, port not selected");
    }

    public void freePort() throws OneWireException {
        try {
            this.beginLocalExclusive();
            this.serial.closePort();
            Object var2_1 = null;
            this.endLocalExclusive();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endLocalExclusive();
            throw throwable;
        }
    }

    public boolean adapterDetected() throws OneWireIOException, OneWireException {
        boolean bl;
        try {
            try {
                this.beginLocalExclusive();
                this.uAdapterPresent();
                bl = this.uVerify();
            }
            catch (OneWireException oneWireException) {
                bl = false;
                Object var4_3 = null;
                this.endLocalExclusive();
            }
            Object var4_2 = null;
            this.endLocalExclusive();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endLocalExclusive();
            throw throwable;
        }
        return bl;
    }

    public String getAdapterVersion() throws OneWireIOException, OneWireException {
        String string = "DS2480 based adapter";
        try {
            this.beginLocalExclusive();
            if (this.uAdapterPresent()) {
                if (this.uState.revision == '\u0000') {
                    this.reset();
                }
                String string2 = string = string.concat(", version " + (this.uState.revision >> 2));
                Object var5_3 = null;
                this.endLocalExclusive();
                return string2;
            }
            throw new OneWireIOException("USerialAdapter-getAdapterVersion, adapter not present");
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.endLocalExclusive();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAdapterAddress() throws OneWireIOException, OneWireException {
        OneWireState oneWireState = this.owState;
        this.owState = new OneWireState();
        try {
            try {
                this.beginLocalExclusive();
                if (!this.uAdapterPresent()) throw new OneWireIOException("USerialAdapter-getAdapterAddress, adapter not present");
                this.setSearchAllDevices();
                this.targetAllFamilies();
                this.targetFamily(9);
                Enumeration enumeration = this.getAllDeviceContainers();
                byte[] byArray = new byte[8];
                block4: while (enumeration.hasMoreElements()) {
                    OneWireContainer oneWireContainer = (OneWireContainer)enumeration.nextElement();
                    System.arraycopy(oneWireContainer.getAddress(), 0, byArray, 0, 8);
                    if (!this.select(byArray)) continue;
                    byte[] byArray2 = new byte[37];
                    int n = 0;
                    byArray2[n++] = -61;
                    byArray2[n++] = 0;
                    byArray2[n++] = 0;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= 34) {
                            int n3 = CRC8.compute(byArray2, 0, 3, 0);
                            this.dataBlock(byArray2, 0, n);
                            if (CRC8.compute(byArray2, 3, 1, n3) != 0 || CRC8.compute(byArray2, 4, 33, 0) != 0) continue block4;
                            break;
                        }
                        byArray2[n++] = -1;
                        ++n2;
                    }
                    n2 = 4;
                    while (true) {
                        if (n2 >= 36) {
                            if (n2 != 36) continue block4;
                            String string = oneWireContainer.getAddressAsString();
                            Object var11_11 = null;
                            this.owState = oneWireState;
                            this.endLocalExclusive();
                            return string;
                        }
                        if (byArray2[n2] != -1) {
                            // empty if block
                        }
                        ++n2;
                    }
                }
            }
            catch (OneWireException oneWireException) {
                Object var11_13 = null;
                this.owState = oneWireState;
                this.endLocalExclusive();
                return "<not available>";
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.owState = oneWireState;
            this.endLocalExclusive();
            throw throwable;
        }
        Object var11_12 = null;
        this.owState = oneWireState;
        this.endLocalExclusive();
        return "<not available>";
    }

    public boolean canOverdrive() throws OneWireIOException, OneWireException {
        return true;
    }

    public boolean canHyperdrive() throws OneWireIOException, OneWireException {
        return false;
    }

    public boolean canFlex() throws OneWireIOException, OneWireException {
        return true;
    }

    public boolean canProgram() throws OneWireIOException, OneWireException {
        try {
            this.beginLocalExclusive();
            if (this.uAdapterPresent()) {
                if (this.uState.revision == '\u0000') {
                    this.reset();
                }
                boolean bl = this.uState.programVoltageAvailable;
                Object var3_2 = null;
                this.endLocalExclusive();
                return bl;
            }
            throw new OneWireIOException("USerialAdapter-canProgram, adapter not present");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.endLocalExclusive();
            throw throwable;
        }
    }

    public boolean canDeliverPower() throws OneWireIOException, OneWireException {
        return true;
    }

    public boolean canDeliverSmartPower() throws OneWireIOException, OneWireException {
        return false;
    }

    public boolean canBreak() throws OneWireIOException, OneWireException {
        return true;
    }

    public boolean findFirstDevice() throws OneWireIOException, OneWireException {
        this.owState.searchLastDiscrepancy = 0;
        this.owState.searchFamilyLastDiscrepancy = 0;
        this.owState.searchLastDevice = false;
        return this.findNextDevice();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean findNextDevice() throws OneWireIOException, OneWireException {
        boolean bl;
        int n;
        block14: {
            try {
                this.beginLocalExclusive();
                if (this.owState.searchLastDevice) {
                    this.owState.searchLastDiscrepancy = 0;
                    this.owState.searchFamilyLastDiscrepancy = 0;
                    this.owState.searchLastDevice = false;
                    boolean bl2 = false;
                    Object var8_5 = null;
                    this.endLocalExclusive();
                    return bl2;
                }
                if (this.owState.searchLastDiscrepancy != 0 || this.owState.searchLastDevice || this.owState.searchIncludeFamilies.length != 1) break block14;
                this.owState.searchLastDiscrepancy = 64;
                byte[] byArray = new byte[8];
                byArray[0] = this.owState.searchIncludeFamilies[0];
                n = 1;
                while (true) {
                    if (n >= 8) {
                        System.arraycopy(byArray, 0, this.owState.ID, 0, 8);
                        break;
                    }
                    byArray[n] = 0;
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.endLocalExclusive();
                throw throwable;
            }
        }
        do {
            if (bl = this.search(this.owState)) {
                boolean bl3 = false;
                n = 0;
                while (n < this.owState.searchExcludeFamilies.length) {
                    if (this.owState.ID[0] == this.owState.searchExcludeFamilies[n]) {
                        bl3 = true;
                        break;
                    }
                    ++n;
                }
                if (!bl3) {
                    boolean bl4 = false;
                    int n2 = 0;
                    while (n2 < this.owState.searchIncludeFamilies.length) {
                        if (this.owState.ID[0] == this.owState.searchIncludeFamilies[n2]) {
                            bl4 = true;
                            break;
                        }
                        ++n2;
                    }
                    if (bl4 || this.owState.searchIncludeFamilies.length == 0) {
                        boolean bl5 = true;
                        Object var8_6 = null;
                        this.endLocalExclusive();
                        return bl5;
                    }
                }
            }
            if (!this.owState.searchLastDevice && this.owState.searchFamilyLastDiscrepancy != 0) {
                this.owState.searchLastDiscrepancy = this.owState.searchFamilyLastDiscrepancy;
                this.owState.searchFamilyLastDiscrepancy = 0;
                this.owState.searchLastDevice = false;
                continue;
            }
            this.owState.searchLastDiscrepancy = 0;
            this.owState.searchFamilyLastDiscrepancy = 0;
            this.owState.searchLastDevice = false;
            bl = false;
        } while (bl);
        boolean bl6 = false;
        Object var8_7 = null;
        this.endLocalExclusive();
        return bl6;
    }

    public void getAddress(byte[] byArray) {
        System.arraycopy(this.owState.ID, 0, byArray, 0, 8);
    }

    public void setAddress(byte[] byArray) {
        System.arraycopy(byArray, 0, this.owState.ID, 0, 8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPresent(byte[] byArray) throws OneWireIOException, OneWireException {
        boolean bl;
        try {
            this.beginLocalExclusive();
            if (!this.uAdapterPresent()) throw new OneWireIOException("Error communicating with adapter");
            if (this.owState.oneWireLevel != '\u0000') {
                this.setPowerNormal();
            }
            if (this.owState.oneWireSpeed == '\u0002') {
                boolean bl2 = this.blockIsPresent(byArray, false);
                Object var8_3 = null;
                this.endLocalExclusive();
                return bl2;
            }
            OneWireState oneWireState = new OneWireState();
            System.arraycopy(byArray, 0, oneWireState.ID, 0, 8);
            oneWireState.searchLastDiscrepancy = 64;
            oneWireState.searchFamilyLastDiscrepancy = 0;
            oneWireState.searchLastDevice = false;
            oneWireState.searchOnlyAlarmingButtons = false;
            if (this.search(oneWireState)) {
                int n = 0;
                while (true) {
                    if (n >= 8) break;
                    if (byArray[n] != oneWireState.ID[n]) {
                        boolean bl3 = false;
                        Object var8_4 = null;
                        this.endLocalExclusive();
                        return bl3;
                    }
                    ++n;
                }
                boolean bl4 = true;
                Object var8_5 = null;
                this.endLocalExclusive();
                return bl4;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.endLocalExclusive();
            throw throwable;
        }
        Object var8_6 = null;
        this.endLocalExclusive();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAlarming(byte[] byArray) throws OneWireIOException, OneWireException {
        boolean bl;
        try {
            this.beginLocalExclusive();
            if (!this.uAdapterPresent()) throw new OneWireIOException("Error communicating with adapter");
            if (this.owState.oneWireLevel != '\u0000') {
                this.setPowerNormal();
            }
            if (this.owState.oneWireSpeed == '\u0002') {
                boolean bl2 = this.blockIsPresent(byArray, true);
                Object var8_3 = null;
                this.endLocalExclusive();
                return bl2;
            }
            OneWireState oneWireState = new OneWireState();
            System.arraycopy(byArray, 0, oneWireState.ID, 0, 8);
            oneWireState.searchLastDiscrepancy = 64;
            oneWireState.searchFamilyLastDiscrepancy = 0;
            oneWireState.searchLastDevice = false;
            oneWireState.searchOnlyAlarmingButtons = true;
            if (this.search(oneWireState)) {
                int n = 0;
                while (true) {
                    if (n >= 8) break;
                    if (byArray[n] != oneWireState.ID[n]) {
                        boolean bl3 = false;
                        Object var8_4 = null;
                        this.endLocalExclusive();
                        return bl3;
                    }
                    ++n;
                }
                boolean bl4 = true;
                Object var8_5 = null;
                this.endLocalExclusive();
                return bl4;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.endLocalExclusive();
            throw throwable;
        }
        Object var8_6 = null;
        this.endLocalExclusive();
        return bl;
    }

    public void setSearchOnlyAlarmingDevices() {
        this.owState.searchOnlyAlarmingButtons = true;
    }

    public void setNoResetSearch() {
        this.owState.skipResetOnSearch = true;
    }

    public void setSearchAllDevices() {
        this.owState.searchOnlyAlarmingButtons = false;
        this.owState.skipResetOnSearch = false;
    }

    public void targetAllFamilies() {
        this.owState.searchIncludeFamilies = new byte[0];
        this.owState.searchExcludeFamilies = new byte[0];
    }

    public void targetFamily(int n) {
        this.owState.searchIncludeFamilies = new byte[1];
        this.owState.searchIncludeFamilies[0] = (byte)n;
    }

    public void targetFamily(byte[] byArray) {
        this.owState.searchIncludeFamilies = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.owState.searchIncludeFamilies, 0, byArray.length);
    }

    public void excludeFamily(int n) {
        this.owState.searchExcludeFamilies = new byte[1];
        this.owState.searchExcludeFamilies[0] = (byte)n;
    }

    public void excludeFamily(byte[] byArray) {
        this.owState.searchExcludeFamilies = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.owState.searchExcludeFamilies, 0, byArray.length);
    }

    public boolean beginExclusive(boolean bl) throws OneWireException {
        return this.serial.beginExclusive(bl);
    }

    public void endExclusive() {
        this.serial.endExclusive();
    }

    private void beginLocalExclusive() throws OneWireException {
        if (this.serial == null) {
            throw new OneWireException("USerialAdapter: port not selected ");
        }
        if (this.serial.haveExclusive()) {
            return;
        }
        Object object = this.syncObject;
        synchronized (object) {
            this.serial.beginExclusive(true);
            this.haveLocalUse = true;
        }
    }

    private void endLocalExclusive() {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.haveLocalUse) {
                this.haveLocalUse = false;
                this.serial.endExclusive();
            }
        }
    }

    public void putBit(boolean bl) throws OneWireIOException, OneWireException {
        try {
            this.beginLocalExclusive();
            if (this.uAdapterPresent()) {
                char[] cArray;
                if (this.owState.oneWireLevel != '\u0000') {
                    this.setPowerNormal();
                }
                this.serial.flushCom();
                this.uBuild.restart();
                int n = this.uBuild.dataBit(bl, this.owState.levelChangeOnNextBit);
                if (this.owState.levelChangeOnNextBit) {
                    this.owState.levelChangeOnNextBit = false;
                    this.owState.oneWireLevel = '\u0001';
                }
                if (bl != this.uBuild.interpretOneWireBit((cArray = this.uTransaction(this.uBuild))[n])) {
                    throw new OneWireIOException("1-Wire communication error, echo was incorrect");
                }
            } else {
                throw new OneWireIOException("Error communicating with adapter");
            }
            Object var5_4 = null;
            this.endLocalExclusive();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.endLocalExclusive();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBit() throws OneWireIOException, OneWireException {
        boolean bl;
        try {
            char[] cArray;
            this.beginLocalExclusive();
            if (!this.uAdapterPresent()) throw new OneWireIOException("Error communicating with adapter");
            if (this.owState.oneWireLevel != '\u0000') {
                this.setPowerNormal();
            }
            this.serial.flushCom();
            this.uBuild.restart();
            int n = this.uBuild.dataBit(true, this.owState.levelChangeOnNextBit);
            if (this.owState.levelChangeOnNextBit) {
                this.owState.levelChangeOnNextBit = false;
                this.owState.oneWireLevel = '\u0001';
            }
            if ((cArray = this.uTransaction(this.uBuild)).length == n + 1) {
                boolean bl2 = this.uBuild.interpretOneWireBit(cArray[n]);
                Object var6_4 = null;
                this.endLocalExclusive();
                return bl2;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.endLocalExclusive();
            throw throwable;
        }
        Object var6_5 = null;
        this.endLocalExclusive();
        return bl;
    }

    public void putByte(int n) throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[]{(byte)n};
        this.dataBlock(byArray, 0, 1);
    }

    public int getByte() throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[]{-1};
        this.dataBlock(byArray, 0, 1);
        if (byArray.length == 1) {
            return byArray[0] & 0xFF;
        }
        throw new OneWireIOException("Error communicating with adapter");
    }

    public byte[] getBlock(int n) throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = -1;
            ++n2;
        }
        this.getBlock(byArray, n);
        return byArray;
    }

    public void getBlock(byte[] byArray, int n) throws OneWireIOException, OneWireException {
        this.getBlock(byArray, 0, n);
    }

    public void getBlock(byte[] byArray, int n, int n2) throws OneWireIOException, OneWireException {
        int n3 = n;
        while (n3 < n2) {
            byArray[n3] = -1;
            ++n3;
        }
        this.dataBlock(byArray, n, n2);
    }

    public void dataBlock(byte[] byArray, int n, int n2) throws OneWireIOException, OneWireException {
        try {
            this.beginLocalExclusive();
            if (this.uAdapterPresent()) {
                if (this.owState.oneWireLevel != '\u0000') {
                    this.setPowerNormal();
                }
                this.setStreamingSpeed(0);
                this.serial.flushCom();
                this.uBuild.restart();
                if (n2 == 1 && this.owState.levelChangeOnNextByte) {
                    int n3 = this.uBuild.primedDataByte(byArray[n]);
                    this.owState.levelChangeOnNextByte = false;
                    char[] cArray = this.uTransaction(this.uBuild);
                    this.owState.oneWireLevel = '\u0001';
                    byArray[n] = this.uBuild.interpretPrimedByte(cArray, n3);
                } else {
                    int n4 = this.uBuild.dataBytes(byArray, n, n2);
                    char[] cArray = this.uTransaction(this.uBuild);
                    this.uBuild.interpretDataBytes(cArray, n4, byArray, n, n2);
                }
            } else {
                throw new OneWireIOException("Error communicating with adapter");
            }
            Object var7_8 = null;
            this.endLocalExclusive();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.endLocalExclusive();
            throw throwable;
        }
    }

    public int reset() throws OneWireIOException, OneWireException {
        try {
            this.beginLocalExclusive();
            if (this.uAdapterPresent()) {
                if (this.owState.oneWireLevel != '\u0000') {
                    this.setPowerNormal();
                }
                this.serial.flushCom();
                this.uBuild.restart();
                int n = this.uBuild.oneWireReset();
                char[] cArray = this.uTransaction(this.uBuild);
                if (cArray.length == n + 1) {
                    int n2 = this.uBuild.interpretOneWireReset(cArray[n]);
                    Object var5_4 = null;
                    this.endLocalExclusive();
                    return n2;
                }
                throw new OneWireIOException("USerialAdapter-reset: no return byte form 1-Wire reset");
            }
            throw new OneWireIOException("Error communicating with adapter");
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.endLocalExclusive();
            throw throwable;
        }
    }

    public void setPowerDuration(int n) throws OneWireIOException, OneWireException {
        if (n != 5) {
            throw new OneWireException("USerialAdapter-setPowerDuration, does not support this duration, infinite only");
        }
        this.owState.levelTimeFactor = 5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startPowerDelivery(int n) throws OneWireIOException, OneWireException {
        int n2;
        try {
            this.beginLocalExclusive();
            if (n == 1) {
                this.owState.levelChangeOnNextBit = true;
                this.owState.primedLevelValue = '\u0001';
            } else if (n == 2) {
                this.owState.levelChangeOnNextByte = true;
                this.owState.primedLevelValue = '\u0001';
            } else {
                if (n != 0) throw new OneWireException("Invalid power delivery condition");
                if (!this.uAdapterPresent()) throw new OneWireIOException("Error communicating with adapter");
                if (this.owState.oneWireLevel != '\u0000') {
                    this.setPowerNormal();
                }
                this.serial.flushCom();
                this.uBuild.restart();
                n2 = this.uBuild.setParameter('0', '\u000e');
                this.uBuild.sendCommand('\u00ed', false);
                char[] cArray = this.uTransaction(this.uBuild);
                if (cArray.length == n2 + 1) {
                    this.owState.oneWireLevel = '\u0001';
                    boolean bl = true;
                    Object var6_5 = null;
                    this.endLocalExclusive();
                    return bl;
                }
            }
            n2 = 0;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.endLocalExclusive();
            throw throwable;
        }
        Object var6_6 = null;
        this.endLocalExclusive();
        return n2 != 0;
    }

    public void setProgramPulseDuration(int n) throws OneWireIOException, OneWireException {
        if (n != 7) {
            throw new OneWireException("Only support EPROM length program pulse duration");
        }
    }

    public boolean startProgramPulse(int n) throws OneWireIOException, OneWireException {
        if (!this.uState.programVoltageAvailable) {
            throw new OneWireException("USerialAdapter: startProgramPulse, program voltage not available");
        }
        try {
            this.beginLocalExclusive();
            this.uBuild.restart();
            int n2 = this.uBuild.setParameter(' ', '\b');
            int n3 = this.uBuild.sendCommand('\u00fd', true);
            char[] cArray = this.uTransaction(this.uBuild);
            boolean bl = true;
            Object var7_6 = null;
            this.endLocalExclusive();
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endLocalExclusive();
            throw throwable;
        }
    }

    public void startBreak() throws OneWireIOException, OneWireException {
        try {
            this.beginLocalExclusive();
            this.serial.setPower(false);
            this.sleep(200L);
            this.owState.oneWireLevel = (char)2;
            Object var2_1 = null;
            this.endLocalExclusive();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endLocalExclusive();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPowerNormal() throws OneWireIOException, OneWireException {
        try {
            this.beginLocalExclusive();
            if (this.owState.oneWireLevel == '\u0001') {
                if (this.uAdapterPresent()) {
                    this.serial.flushCom();
                    this.uBuild.restart();
                    int n = this.uBuild.sendCommand('\u00f1', true);
                    char[] cArray = this.uTransaction(this.uBuild);
                    if (cArray.length != n + 1) throw new OneWireIOException("Did not get a response back from stop power delivery");
                    this.owState.oneWireLevel = '\u0000';
                    this.getBit();
                }
            } else if (this.owState.oneWireLevel == '\u0002') {
                this.serial.setPower(true);
                this.sleep(300L);
                this.owState.oneWireLevel = '\u0000';
                this.adapterPresent = false;
                if (!this.uAdapterPresent()) {
                    throw new OneWireIOException("Did not get a response back from adapter after break");
                }
            }
            Object var4_3 = null;
            this.endLocalExclusive();
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endLocalExclusive();
            throw throwable;
        }
    }

    public void setSpeed(int n) throws OneWireIOException, OneWireException {
        try {
            this.beginLocalExclusive();
            if (n == 0 || n == 2 || n == 1) {
                this.owState.oneWireSpeed = (char)n;
                this.uState.uSpeedMode = n == 2 ? (char)8 : (char)4;
            } else {
                throw new OneWireException("Requested speed is not supported by this adapter");
            }
            Object var3_2 = null;
            this.endLocalExclusive();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.endLocalExclusive();
            throw throwable;
        }
    }

    public int getSpeed() {
        return this.owState.oneWireSpeed;
    }

    private boolean search(OneWireState oneWireState) throws OneWireIOException, OneWireException {
        int n = 0;
        if (this.uAdapterPresent()) {
            if (this.owState.oneWireLevel != '\u0000') {
                this.setPowerNormal();
            }
            this.setStreamingSpeed(1);
            this.uBuild.restart();
            if (!oneWireState.skipResetOnSearch) {
                n = this.uBuild.oneWireReset();
            }
            if (oneWireState.searchOnlyAlarmingButtons) {
                this.uBuild.dataByte('\u00ec');
            } else {
                this.uBuild.dataByte('\u00f0');
            }
            int n2 = this.uBuild.search(oneWireState);
            char[] cArray = this.uTransaction(this.uBuild);
            if (!oneWireState.skipResetOnSearch) {
                this.uBuild.interpretOneWireReset(cArray[n]);
            }
            return this.uBuild.interpretSearch(oneWireState, cArray, n2);
        }
        throw new OneWireIOException("Error communicating with adapter");
    }

    private boolean blockIsPresent(byte[] byArray, boolean bl) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[24];
        this.reset();
        if (bl) {
            this.putByte(236);
        } else {
            this.putByte(240);
        }
        int n = 0;
        while (n < 24) {
            byArray2[n] = -1;
            ++n;
        }
        n = 0;
        while (n < 64) {
            Bit.arrayWriteBit(Bit.arrayReadBit(n, 0, byArray), (n + 1) * 3 - 1, 0, byArray2);
            ++n;
        }
        this.dataBlock(byArray2, 0, 24);
        int n2 = 56;
        int n3 = 0;
        n = 168;
        while (n < 192) {
            int n4 = Bit.arrayReadBit(n, 0, byArray2) << 1 | Bit.arrayReadBit(n + 1, 0, byArray2);
            int n5 = Bit.arrayReadBit(n2++, 0, byArray);
            if (n4 == 3) {
                n3 = 0;
                break;
            }
            if (n5 == 1 && n4 == 2 || n5 == 0 && n4 == 1) {
                ++n3;
            }
            n += 3;
        }
        return n3 >= 8;
    }

    private void setStreamingSpeed(int n) throws OneWireIOException {
        char c;
        int n2 = UPacketBuilder.getDesiredBaud(n, this.owState.oneWireSpeed, maxBaud);
        if (n2 == this.serial.getBaudRate()) {
            return;
        }
        this.adapterPresent = false;
        if (doDebugMessages) {
            System.out.println("Changing baud rate from " + this.serial.getBaudRate() + " to " + n2);
        }
        switch (n2) {
            case 115200: {
                c = '\u0006';
                break;
            }
            case 57600: {
                c = '\u0004';
                break;
            }
            case 19200: {
                c = '\u0002';
                break;
            }
            default: {
                c = '\u0000';
            }
        }
        this.uBuild.restart();
        int n3 = this.uBuild.setParameter('p', c);
        this.serial.flushCom();
        RawSendPacket rawSendPacket = (RawSendPacket)this.uBuild.getPackets().nextElement();
        char[] cArray = new char[rawSendPacket.buffer.length()];
        rawSendPacket.buffer.getChars(0, rawSendPacket.buffer.length(), cArray, 0);
        this.serial.writeCom(cArray);
        this.sleep(5L);
        this.serial.flushCom();
        this.serial.setBaudRate(n2);
        this.uState.ubaud = c;
        this.sleep(5L);
        this.uBuild.restart();
        n3 = this.uBuild.getParameter(112);
        this.uBuild.setSpeed();
        try {
            this.serial.flushCom();
            char[] cArray2 = this.uTransaction(this.uBuild);
            if (cArray2.length == 1 && (cArray2[n3] & 0xF1) == 0 && (cArray2[n3] & 0xE) == this.uState.ubaud) {
                if (doDebugMessages) {
                    System.out.println("Success, baud changed and DS2480 is there");
                }
                this.adapterPresent = true;
                return;
            }
        }
        catch (OneWireIOException oneWireIOException) {
            System.err.println("USerialAdapter-setStreamingSpeed: " + oneWireIOException);
        }
        if (doDebugMessages) {
            System.out.println("Failed to change baud of DS2480");
        }
    }

    private boolean uAdapterPresent() throws OneWireException {
        boolean bl = true;
        if (!this.adapterPresent) {
            this.uMasterReset();
            if (!this.uVerify()) {
                this.uMasterReset();
                if (!this.uVerify()) {
                    this.uPowerReset();
                    if (!this.uVerify()) {
                        bl = false;
                    }
                }
            }
        }
        this.adapterPresent = bl;
        if (doDebugMessages) {
            System.out.println("DEBUG: AdapterPresent result: " + bl);
        }
        return bl;
    }

    private void uMasterReset() {
        if (doDebugMessages) {
            System.out.println("DEBUG: uMasterReset");
        }
        try {
            this.serial.setBaudRate(9600);
            this.uState.ubaud = '\u0000';
            this.owState.oneWireSpeed = '\u0000';
            this.uState.uSpeedMode = (char)4;
            this.uState.ubaud = '\u0000';
            this.serial.sendBreak(10);
            this.sleep(5L);
            this.serial.flushCom();
            this.serial.writeCom('\u00c1');
            this.serial.flushCom();
        }
        catch (OneWireIOException oneWireIOException) {
            System.err.println("USerialAdapter-uMasterReset: " + oneWireIOException);
        }
    }

    private void uPowerReset() {
        if (doDebugMessages) {
            System.out.println("DEBUG: uPowerReset");
        }
        try {
            this.serial.setBaudRate(9600);
            this.uState.ubaud = '\u0000';
            this.owState.oneWireSpeed = '\u0000';
            this.uState.uSpeedMode = (char)4;
            this.uState.ubaud = '\u0000';
            this.serial.setPower(false);
            this.sleep(300L);
            this.serial.setPower(true);
            this.sleep(1L);
            this.serial.flushCom();
            this.serial.writeCom('\u00c1');
            this.serial.flushCom();
        }
        catch (OneWireIOException oneWireIOException) {
            System.err.println("USerialAdapter-uPowerReset: " + oneWireIOException);
        }
    }

    private boolean uVerify() {
        block3: {
            this.serial.flushCom();
            this.uBuild.restart();
            int n = this.uBuild.setParameter('\u0010', this.uState.uParameters[this.owState.oneWireSpeed].pullDownSlewRate);
            int n2 = this.uBuild.setParameter('@', this.uState.uParameters[this.owState.oneWireSpeed].write1LowTime);
            int n3 = this.uBuild.setParameter('P', this.uState.uParameters[this.owState.oneWireSpeed].sampleOffsetTime);
            int n4 = this.uBuild.setParameter('0', '\u000e');
            int n5 = this.uBuild.getParameter(112);
            int n6 = this.uBuild.dataBit(true, false);
            try {
                char[] cArray = this.uTransaction(this.uBuild);
                if (cArray.length == n6 + 1 && (cArray[n5] & 0xF1) == 0 && (cArray[n5] & 0xE) == this.uState.ubaud && (cArray[n6] & 0xF0) == 144 && (cArray[n6] & 0xC) == this.uState.uSpeedMode) {
                    return true;
                }
            }
            catch (OneWireIOException oneWireIOException) {
                if (!this.adapterPresent) break block3;
                System.err.println("USerialAdapter-uVerify: " + oneWireIOException);
            }
        }
        return false;
    }

    private char[] uTransaction(UPacketBuilder uPacketBuilder) throws OneWireIOException {
        try {
            Object object;
            this.serial.flushCom();
            this.inBuffer.setLength(0);
            Enumeration enumeration = uPacketBuilder.getPackets();
            while (enumeration.hasMoreElements()) {
                object = (RawSendPacket)enumeration.nextElement();
                if (((RawSendPacket)object).buffer.length() == 0 && ((RawSendPacket)object).returnLength == 0) {
                    this.sleep(6L);
                    this.serial.flushCom();
                    continue;
                }
                char[] cArray = new char[((RawSendPacket)object).buffer.length()];
                ((RawSendPacket)object).buffer.getChars(0, ((RawSendPacket)object).buffer.length(), cArray, 0);
                int n = this.inBuffer.length();
                this.serial.writeCom(cArray);
                this.inBuffer.append(this.serial.readComWait(((RawSendPacket)object).returnLength));
            }
            object = new char[this.inBuffer.length()];
            this.inBuffer.getChars(0, this.inBuffer.length(), (char[])object, 0);
            this.extraBytesReceived = this.inBuffer.length() > uPacketBuilder.totalReturnLength;
            this.inBuffer.setLength(0);
            return object;
        }
        catch (OneWireIOException oneWireIOException) {
            this.adapterPresent = false;
            throw new OneWireIOException(oneWireIOException.toString());
        }
    }

    private void sleep(long l) {
        if (doDebugMessages) {
            System.out.println("DEBUG: sleep(" + l + ")");
        }
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        doDebugMessages = false;
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1) continue;
            SerialService serialService = new SerialService(commPortIdentifier.getName());
            serailServiceHash.put(commPortIdentifier.getName(), serialService);
            if (!doDebugMessages) continue;
            System.out.println("DEBUG: Serial port: " + commPortIdentifier.getName());
        }
        maxBaud = 115200;
        String string = OneWireAccessProvider.getProperty("onewire.serial.maxbaud");
        if (string != null) {
            try {
                maxBaud = Integer.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                maxBaud = 0;
            }
        }
        if (doDebugMessages) {
            System.out.println("DEBUG: getMaxBaud from properties: " + maxBaud);
        }
        if (maxBaud != 115200 && maxBaud != 57600 && maxBaud != 19200 && maxBaud != 9600) {
            maxBaud = 115200;
        }
    }
}

