/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.adapter;

import com.dalsemi.onewire.OneWireAccessProvider;
import com.dalsemi.onewire.adapter.OneWireState;
import com.dalsemi.onewire.adapter.RawSendPacket;
import com.dalsemi.onewire.adapter.UAdapterState;
import com.dalsemi.onewire.utils.Address;
import java.util.Enumeration;
import java.util.Vector;

class UPacketBuilder {
    public static final int OPERATION_BYTE = 0;
    public static final int OPERATION_SEARCH = 1;
    public static final char MAX_BYTES_STREAMED = '@';
    public static final char FUNCTION_BIT = '\u0081';
    public static final char FUNCTION_SEARCHON = '\u00b1';
    public static final char FUNCTION_SEARCHOFF = '\u00a1';
    public static final char FUNCTION_RESET = '\u00c1';
    public static final char FUNCTION_5VPULSE_NOW = '\u00ed';
    public static final char FUNCTION_12VPULSE_NOW = '\u00fd';
    public static final char FUNCTION_5VPULSE_ARM = '\u00ef';
    public static final char FUNCTION_STOP_PULSE = '\u00f1';
    public static final char BIT_ONE = '\u0010';
    public static final char BIT_ZERO = '\u0000';
    public static final char PRIME5V_TRUE = '\u0002';
    public static final char PRIME5V_FALSE = '\u0000';
    public static final char CONFIG_MASK = '\u0001';
    public static final char RESPONSE_RESET_MASK = '\u0003';
    public static final char RESPONSE_RESET_SHORT = '\u0000';
    public static final char RESPONSE_RESET_PRESENCE = '\u0001';
    public static final char RESPONSE_RESET_ALARM = '\u0002';
    public static final char RESPONSE_RESET_NOPRESENCE = '\u0003';
    public static final char RESPONSE_BIT_MASK = '\u0003';
    public static final char RESPONSE_BIT_ONE = '\u0003';
    public static final char RESPONSE_BIT_ZERO = '\u0000';
    public static boolean doDebugMessages = false;
    private UAdapterState uState;
    protected int totalReturnLength;
    protected RawSendPacket packet;
    protected Vector packetsVector;
    protected boolean bitsOnly;

    public UPacketBuilder(UAdapterState uAdapterState) {
        this.uState = uAdapterState;
        this.packet = new RawSendPacket();
        this.packetsVector = new Vector();
        this.restart();
        this.bitsOnly = System.getProperty("os.name").indexOf("SunOS") != -1;
        String string = OneWireAccessProvider.getProperty("onewire.serial.forcebitsonly");
        if (string != null) {
            if (string.indexOf("true") != -1) {
                this.bitsOnly = true;
            } else if (string.indexOf("false") != -1) {
                this.bitsOnly = false;
            }
        }
    }

    public void restart() {
        this.packetsVector.removeAllElements();
        this.packet.buffer.setLength(0);
        this.packet.returnLength = 0;
        this.totalReturnLength = 0;
    }

    public void newPacket() {
        this.packetsVector.addElement(this.packet);
        this.packet = new RawSendPacket();
    }

    public Enumeration getPackets() {
        if (this.packet.buffer.length() > 0) {
            this.newPacket();
        }
        return this.packetsVector.elements();
    }

    public int oneWireReset() {
        block4: {
            block5: {
                this.setToCommandMode();
                this.packet.buffer.append((char)(0xC1 | this.uState.uSpeedMode));
                ++this.totalReturnLength;
                ++this.packet.returnLength;
                if (!this.uState.streamResets) {
                    this.newPacket();
                }
                if (!this.uState.longAlarmCheck) break block4;
                if (this.uState.uSpeedMode == '\u0000') break block5;
                if (this.uState.uSpeedMode != '\u0004') break block4;
            }
            this.newPacket();
        }
        return this.totalReturnLength - 1;
    }

    public int dataBytes(char[] cArray) {
        if (!this.bitsOnly) {
            this.setToDataMode();
        }
        if (doDebugMessages) {
            System.out.println("DEBUG: UPacketbuilder-dataBytes[] length " + cArray.length);
        }
        int n = this.totalReturnLength;
        int n2 = 0;
        while (n2 < cArray.length) {
            block11: {
                block13: {
                    block12: {
                        block10: {
                            if (!this.bitsOnly) break block10;
                            char c = cArray[n2];
                            int n3 = 0;
                            while (n3 < 8) {
                                this.dataBit((c & '\u0001') == 1, false);
                                c = (char)(c >>> 1);
                                ++n3;
                            }
                            break block11;
                        }
                        this.packet.buffer.append(cArray[n2]);
                        if (doDebugMessages) {
                            System.out.println("DEBUG: UPacketbuilder-dataBytes[] byte[" + Integer.toHexString(cArray[n2] & 0xFF) + "]");
                        }
                        if ((char)(cArray[n2] & 0xFF) == '\u00e3') break block12;
                        if ((char)(cArray[n2] & 0xFF) != '\u00f3') break block13;
                        if (this.uState.revision != '\u0004') break block13;
                    }
                    this.packet.buffer.append(cArray[n2]);
                }
                ++this.totalReturnLength;
                ++this.packet.returnLength;
                if (doDebugMessages) {
                    System.out.println("DEBUG: UPacketbuilder-dataBytes[] returnlength " + this.packet.returnLength + " bufferLength " + this.packet.buffer.length());
                }
                if (this.packet.buffer.length() > 64 || !this.uState.streamBytes) {
                    this.newPacket();
                }
            }
            ++n2;
        }
        return n;
    }

    public int dataBytes(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)byArray[n + n3];
            ++n3;
        }
        return this.dataBytes(cArray);
    }

    public int dataByte(char c) {
        char[] cArray = new char[]{c};
        if (doDebugMessages) {
            System.out.println("DEBUG: UPacketbuilder-dataBytes [" + Integer.toHexString(c & 0xFF) + "]");
        }
        return this.dataBytes(cArray);
    }

    public int primedDataByte(byte by) {
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            int n3 = this.dataBit((by & 1) == 1, n2 == 7);
            by = (byte)(by >>> 1);
            if (n2 == 0) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public int dataBit(boolean bl, boolean bl2) {
        this.setToCommandMode();
        this.packet.buffer.append((char)(0x81 | this.uState.uSpeedMode | (bl ? 16 : 0) | (bl2 ? 2 : 0)));
        ++this.totalReturnLength;
        ++this.packet.returnLength;
        if (this.packet.buffer.length() > 64 || !this.uState.streamBits) {
            this.newPacket();
        }
        return this.totalReturnLength - 1;
    }

    public int search(OneWireState oneWireState) {
        int n;
        this.setToCommandMode();
        this.packet.buffer.append((char)(0xB1 | this.uState.uSpeedMode));
        this.setToDataMode();
        char[] cArray = new char[16];
        char[] cArray2 = new char[8];
        int n2 = 0;
        while (n2 < 8) {
            cArray2[n2] = (char)(oneWireState.ID[n2] & 0xFF);
            ++n2;
        }
        int n3 = 0;
        while (n3 < 16) {
            cArray[n3] = '\u0000';
            ++n3;
        }
        if (doDebugMessages) {
            System.out.println("DEBUG: UPacketbuilder-search [" + Integer.toHexString(cArray2.length) + "]");
        }
        if (oneWireState.searchLastDiscrepancy != 255) {
            n = 0;
            while (n < 64) {
                if (n < oneWireState.searchLastDiscrepancy - 1) {
                    this.bitWrite(cArray, n * 2 + 1, this.bitRead(cArray2, n));
                } else if (n == oneWireState.searchLastDiscrepancy - 1) {
                    this.bitWrite(cArray, n * 2 + 1, true);
                }
                ++n;
            }
        }
        n = this.totalReturnLength;
        this.packet.buffer.append(cArray);
        this.setToCommandMode();
        this.packet.buffer.append((char)(0xA1 | this.uState.uSpeedMode));
        this.totalReturnLength += 16;
        this.packet.returnLength += 16;
        return n;
    }

    public void setSpeed() {
        this.setToCommandMode();
        this.packet.buffer.append((char)(0xA1 | this.uState.uSpeedMode));
    }

    public void setToCommandMode() {
        if (!this.uState.inCommandMode) {
            this.packet.buffer.append('\u00e3');
            this.uState.inCommandMode = true;
        }
    }

    public void setToDataMode() {
        if (this.uState.inCommandMode) {
            this.packet.buffer.append('\u00e1');
            this.uState.inCommandMode = false;
        }
    }

    public int getParameter(int n) {
        this.setToCommandMode();
        this.packet.buffer.append((char)(1 | n >> 3));
        ++this.totalReturnLength;
        ++this.packet.returnLength;
        if (this.packet.buffer.length() > 64) {
            this.newPacket();
        }
        return this.totalReturnLength - 1;
    }

    public int setParameter(char c, char c2) {
        this.setToCommandMode();
        this.packet.buffer.append((char)('\u0001' | c | c2));
        ++this.totalReturnLength;
        ++this.packet.returnLength;
        if (this.packet.buffer.length() > 64) {
            this.newPacket();
        }
        return this.totalReturnLength - 1;
    }

    public int sendCommand(char c, boolean bl) {
        this.setToCommandMode();
        this.packet.buffer.append(c);
        if (bl) {
            ++this.totalReturnLength;
            ++this.packet.returnLength;
        }
        if (this.packet.buffer.length() > 64) {
            this.newPacket();
        }
        return this.totalReturnLength - 1;
    }

    public void interpretDataBytes(char[] cArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (this.bitsOnly) {
                int n5 = n + 8 * n4;
                if (doDebugMessages) {
                    System.out.println("DEBUG: UPacketbuilder-interpretDataBytes[] responseOffset " + n + " offset " + n2 + " lenbuf " + cArray.length);
                }
                int n6 = 0;
                int n7 = 0;
                while (n7 < 8) {
                    n6 = (char)(n6 >>> 1);
                    if (this.interpretOneWireBit(cArray[n5 + n7])) {
                        n6 = (char)(n6 | 0x80);
                    }
                    ++n7;
                }
                byArray[n2 + n4] = (byte)(n6 & 0xFF);
            } else {
                byArray[n2 + n4] = (byte)cArray[n + n4];
            }
            ++n4;
        }
    }

    public int interpretOneWireReset(char c) {
        if ((c & 0xC0) == 192) {
            this.uState.revision = (char)(0x1C & c);
            boolean bl = this.uState.programVoltageAvailable = (0x20 & c) != 0;
            if (doDebugMessages) {
                System.out.println("DEBUG: UPacketbuilder-reset response " + Integer.toHexString(c & 0xFF));
            }
            switch (c & 3) {
                case 0: {
                    return 3;
                }
                case 1: {
                    if (this.uState.longAlarmCheck) {
                        if (this.uState.lastAlarmCount++ > 3000) {
                            this.uState.longAlarmCheck = false;
                        }
                    }
                    return 1;
                }
                case 2: {
                    this.uState.longAlarmCheck = true;
                    this.uState.lastAlarmCount = 0;
                    return 2;
                }
            }
            return 0;
        }
        return 0;
    }

    public boolean interpretOneWireBit(char c) {
        return (c & 3) == 3;
    }

    public boolean interpretSearch(OneWireState oneWireState, char[] cArray, int n) {
        char[] cArray2 = new char[8];
        int n2 = n * 8;
        int n3 = 255;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 64) {
            this.bitWrite(cArray2, n5, this.bitRead(cArray, n5 * 2 + 1 + n2));
            if (this.bitRead(cArray, n5 * 2 + n2) && !this.bitRead(cArray, n5 * 2 + 1 + n2)) {
                n3 = n5 + 1;
                if (n5 < 8) {
                    n4 = n5 + 1;
                }
            }
            ++n5;
        }
        byte[] byArray = new byte[8];
        int n6 = 0;
        while (n6 < 8) {
            byArray[n6] = (byte)cArray2[n6];
            ++n6;
        }
        if (!Address.isValid(byArray) || n3 == 63 || cArray2[0] == '\u0000') {
            return false;
        }
        if (n3 == oneWireState.searchLastDiscrepancy || n3 == 255) {
            oneWireState.searchLastDevice = true;
        }
        int n7 = 0;
        while (n7 < 8) {
            oneWireState.ID[n7] = (byte)cArray2[n7];
            ++n7;
        }
        oneWireState.searchLastDiscrepancy = n3;
        oneWireState.searchFamilyLastDiscrepancy = n4;
        return true;
    }

    public byte interpretPrimedByte(char[] cArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 8) {
            n2 = (char)(n2 >>> 1);
            if (this.interpretOneWireBit(cArray[n + n3])) {
                n2 = (char)(n2 | 0x80);
            }
            ++n3;
        }
        return (byte)(n2 & 0xFF);
    }

    public static int getDesiredBaud(int n, int n2, int n3) {
        int n4 = 9600;
        switch (n) {
            case 0: {
                if (n2 == 2) {
                    n4 = 115200;
                    break;
                }
                n4 = 9600;
                break;
            }
            case 1: {
                n4 = n2 == 2 ? 57600 : 9600;
            }
        }
        if (n4 > n3) {
            n4 = n3;
        }
        return n4;
    }

    public boolean bitRead(char[] cArray, int n) {
        int n2 = n / 8;
        int n3 = n - n2 * 8;
        return (char)(cArray[n2] >> n3 & 1) == '\u0001';
    }

    public void bitWrite(char[] cArray, int n, boolean bl) {
        int n2 = n / 8;
        int n3 = n - n2 * 8;
        if (bl) {
            int n4 = n2;
            cArray[n4] = (char)(cArray[n4] | (char)(1 << n3));
        } else {
            int n5 = n2;
            cArray[n5] = (char)(cArray[n5] & (char)(~(1 << n3)));
        }
    }
}

