/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.adapter;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class TMEXAdapter
extends DSPortAdapter {
    private static boolean driverLoaded;
    protected int portType;
    protected byte[] RomDta = new byte[8];
    private boolean doAlarmSearch = false;
    private boolean resetSearch = true;
    private boolean skipResetOnSearch = false;

    public TMEXAdapter() throws ClassNotFoundException {
        if (!driverLoaded) {
            throw new ClassNotFoundException("native driver 'ibtmjava.dll' not loaded");
        }
        this.portType = TMEXAdapter.getDefaultTypeNumber();
        if (!this.setPortType_Native(this.portType)) {
            throw new ClassNotFoundException("TMEX adapter type does not exist");
        }
    }

    public TMEXAdapter(int n) throws ClassNotFoundException {
        this.portType = n;
        if (!driverLoaded) {
            throw new ClassNotFoundException("native driver 'ibtmjava.dll' not loaded");
        }
        if (!this.setPortType_Native(this.portType)) {
            throw new ClassNotFoundException("TMEX adapter type does not exist");
        }
    }

    protected void finalize() {
        this.cleanup_Native();
    }

    public native String getAdapterName();

    public native String getPortTypeDescription();

    public String getClassVersion() {
        return new String("0.00, native: " + this.getVersion_Native());
    }

    public Enumeration getPortNames() {
        Vector<String> vector = new Vector<String>();
        String string = this.getPortNameHeader_Native();
        int n = 0;
        while (n < 16) {
            vector.addElement(new String(string + Integer.toString(n)));
            ++n;
        }
        return vector.elements();
    }

    public native boolean selectPort(String var1) throws OneWireIOException, OneWireException;

    public native void freePort() throws OneWireException;

    public native String getPortName() throws OneWireException;

    public native boolean adapterDetected() throws OneWireIOException, OneWireException;

    public native String getAdapterVersion() throws OneWireIOException, OneWireException;

    public String getAdapterAddress() throws OneWireIOException, OneWireException {
        return "<na>";
    }

    public native boolean canOverdrive() throws OneWireIOException, OneWireException;

    public native boolean canHyperdrive() throws OneWireIOException, OneWireException;

    public native boolean canFlex() throws OneWireIOException, OneWireException;

    public native boolean canProgram() throws OneWireIOException, OneWireException;

    public native boolean canDeliverPower() throws OneWireIOException, OneWireException;

    public native boolean canDeliverSmartPower() throws OneWireIOException, OneWireException;

    public native boolean canBreak() throws OneWireIOException, OneWireException;

    public boolean findFirstDevice() throws OneWireIOException, OneWireException {
        this.resetSearch = true;
        return this.findNextDevice();
    }

    public boolean findNextDevice() throws OneWireIOException, OneWireException {
        boolean bl;
        while (bl = this.romSearch_Native(this.skipResetOnSearch, this.resetSearch, this.doAlarmSearch, this.RomDta)) {
            this.resetSearch = false;
            if (!this.isValidFamily(this.RomDta)) continue;
            return true;
        }
        this.resetSearch = true;
        return false;
    }

    public void getAddress(byte[] byArray) {
        System.arraycopy(this.RomDta, 0, byArray, 0, 8);
    }

    public native boolean isPresent(byte[] var1) throws OneWireIOException, OneWireException;

    public native boolean isAlarming(byte[] var1) throws OneWireIOException, OneWireException;

    public native boolean select(byte[] var1) throws OneWireIOException, OneWireException;

    public void setSearchOnlyAlarmingDevices() {
        this.doAlarmSearch = true;
    }

    public void setNoResetSearch() {
        this.skipResetOnSearch = true;
    }

    public void setSearchAllDevices() {
        this.doAlarmSearch = false;
        this.skipResetOnSearch = false;
    }

    public native boolean beginExclusive(boolean var1) throws OneWireException;

    public native void endExclusive();

    public void putBit(boolean bl) throws OneWireIOException, OneWireException {
        if (this.dataBit_Native(bl) != bl) {
            throw new OneWireIOException("Error during putBit()");
        }
    }

    public boolean getBit() throws OneWireIOException, OneWireException {
        return this.dataBit_Native(true);
    }

    public void putByte(int n) throws OneWireIOException, OneWireException {
        if (this.dataByte_Native(n & 0xFF) != (0xFF & n)) {
            throw new OneWireIOException("Error during putByte(), echo was incorrect ");
        }
    }

    public int getByte() throws OneWireIOException, OneWireException {
        return this.dataByte_Native(255);
    }

    public byte[] getBlock(int n) throws OneWireIOException, OneWireException {
        byte[] byArray = new byte[n];
        this.getBlock(byArray, 0, n);
        return byArray;
    }

    public void getBlock(byte[] byArray, int n) throws OneWireIOException, OneWireException {
        this.getBlock(byArray, 0, n);
    }

    public native void getBlock(byte[] var1, int var2, int var3) throws OneWireIOException, OneWireException;

    public native void dataBlock(byte[] var1, int var2, int var3) throws OneWireIOException, OneWireException;

    public native int reset() throws OneWireIOException, OneWireException;

    public void setPowerDuration(int n) throws OneWireIOException, OneWireException {
        if (n != 5) {
            throw new OneWireException("No support for other than infinite power duration");
        }
    }

    public native boolean startPowerDelivery(int var1) throws OneWireIOException, OneWireException;

    public void setProgramPulseDuration(int n) throws OneWireIOException, OneWireException {
        if (n != 7) {
            throw new OneWireException("Only support EPROM length program pulse duration");
        }
    }

    public native boolean startProgramPulse(int var1) throws OneWireIOException, OneWireException;

    public native void startBreak() throws OneWireIOException, OneWireException;

    public native void setPowerNormal() throws OneWireIOException, OneWireException;

    public native void setSpeed(int var1) throws OneWireIOException, OneWireException;

    public native int getSpeed();

    public boolean setTMEXPortType(int n) {
        this.portType = n;
        return this.setPortType_Native(this.portType);
    }

    public static native String getDefaultAdapterName();

    public static native String getDefaultPortName();

    private static native int getDefaultTypeNumber();

    private native boolean setPortType_Native(int var1);

    private native boolean dataBit_Native(boolean var1) throws OneWireIOException, OneWireException;

    private native int dataByte_Native(int var1) throws OneWireIOException, OneWireException;

    private native String getVersion_Native();

    private native boolean romSearch_Native(boolean var1, boolean var2, boolean var3, byte[] var4) throws OneWireIOException, OneWireException;

    private native String getPortNameHeader_Native();

    private native void cleanup_Native();

    static {
        block11: {
            driverLoaded = false;
            driverLoaded = false;
            if (System.getProperty("os.arch").indexOf("86") != -1 && System.getProperty("os.name").indexOf("Windows") != -1) {
                int n = 0;
                int n2 = 0;
                String string = System.getProperty("java.library.path");
                boolean bl = false;
                if (string != null) {
                    do {
                        String string2;
                        File file;
                        if ((n = string.indexOf(File.pathSeparatorChar, n2)) > -1 && (file = new File((string2 = string.substring(n2, n)) + File.separator + "IBFS32.DLL")).exists()) {
                            bl = true;
                            break;
                        }
                        n2 = n + 1;
                    } while (n > -1);
                } else {
                    bl = true;
                }
                if (bl) {
                    try {
                        System.loadLibrary("ibtmjava");
                        driverLoaded = true;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (string != null) {
                            System.err.println("Could not load Java to TMEX-native bridge driver: ibtmjava.dll");
                            break block11;
                        }
                        System.err.println("Native drivers not found, download iButton-TMEX RTE Win32 from www.ibutton.com");
                    }
                } else {
                    System.err.println("Native drivers not found, download iButton-TMEX RTE Win32 from www.ibutton.com");
                }
            }
        }
    }
}

