/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.adapter;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

class SerialService {
    private Integer currentThreadHash = new Integer(0);
    private boolean portOpen = false;
    private String portName;
    private SerialPort serialPort;
    private OutputStream outStream;
    private InputStream inStream;
    private Vector users;
    private static boolean doDebugMessages = false;

    public SerialService(String string) {
        this.portName = string;
        this.users = new Vector(4);
    }

    public void openPort() throws OneWireException {
        CommPortIdentifier commPortIdentifier;
        Integer n = new Integer(Thread.currentThread().hashCode());
        if (this.users.indexOf(n) == -1) {
            this.users.addElement(n);
        }
        if (this.portOpen) {
            return;
        }
        try {
            commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.portName);
        }
        catch (NoSuchPortException noSuchPortException) {
            throw new OneWireException("Could not open port(" + this.portName + ") :" + (Object)((Object)noSuchPortException));
        }
        if (commPortIdentifier.isCurrentlyOwned()) {
            throw new OneWireException("Port In Use (" + this.portName + ")");
        }
        try {
            this.serialPort = (SerialPort)commPortIdentifier.open("Dallas Semiconductor 1-Wire API System", 2000);
            this.serialPort.setFlowControlMode(0);
            this.outStream = this.serialPort.getOutputStream();
            this.inStream = this.serialPort.getInputStream();
            this.serialPort.disableReceiveFraming();
            this.serialPort.disableReceiveThreshold();
            this.serialPort.enableReceiveTimeout(100);
            this.serialPort.setSerialPortParams(9600, 8, 1, 0);
            this.serialPort.setDTR(true);
            this.serialPort.setRTS(true);
            this.portOpen = true;
        }
        catch (Exception exception) {
            if (this.serialPort != null) {
                this.serialPort.close();
            }
            this.serialPort = null;
            this.portOpen = false;
            throw new OneWireException("Port In Use(" + this.portName + ") :" + exception);
        }
    }

    public void closePort() {
        this.users.removeElement(new Integer(Thread.currentThread().hashCode()));
        if (this.users.isEmpty()) {
            if (doDebugMessages) {
                System.out.println("Closing the port (" + this.portName + ") by " + Thread.currentThread().getName());
            }
            if (!this.portOpen) {
                return;
            }
            this.serialPort.close();
            this.serialPort = null;
            this.portOpen = false;
        }
    }

    public int getBaudRate() {
        return this.serialPort.getBaudRate();
    }

    public void setBaudRate(int n) {
        try {
            this.serialPort.setSerialPortParams(n, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            System.err.println("Setting baud rate: " + (Object)((Object)unsupportedCommOperationException));
        }
    }

    public void sendBreak(int n) {
        this.serialPort.sendBreak(n);
    }

    public void setPower(boolean bl) {
        this.serialPort.setDTR(bl);
        this.serialPort.setRTS(bl);
    }

    public String getName() {
        return new String(this.portName);
    }

    public void writeCom(char c) throws OneWireIOException {
        block3: {
            if (doDebugMessages) {
                System.out.print("W(" + Integer.toHexString(c) + ")");
            }
            try {
                this.outStream.write(c);
                this.outStream.flush();
            }
            catch (IOException iOException) {
                if (System.getProperty("os.name").indexOf("Linux") != -1 && iOException.toString().indexOf("Interrupted") != -1) break block3;
                throw new OneWireIOException("writeCom(): " + iOException);
            }
        }
    }

    public void writeCom(char[] cArray) throws OneWireIOException {
        block4: {
            try {
                byte[] byArray = new byte[cArray.length];
                int n = 0;
                while (n < cArray.length) {
                    byArray[n] = (byte)cArray[n];
                    if (doDebugMessages) {
                        System.out.print("W{" + Integer.toHexString(cArray[n] & 0xFF) + "}");
                    }
                    ++n;
                }
                this.outStream.write(byArray);
                this.outStream.flush();
            }
            catch (IOException iOException) {
                if (System.getProperty("os.name").indexOf("Linux") != -1 && iOException.toString().indexOf("Interrupted") != -1) break block4;
                throw new OneWireIOException("writeCom([]): " + iOException);
            }
        }
    }

    public char[] readComWait(int n) throws OneWireIOException {
        int n2 = 0;
        char[] cArray = new char[n];
        byte[] byArray = new byte[n];
        long l = System.currentTimeMillis() + (long)(n * 20) + 800L;
        if (doDebugMessages) {
            System.out.println("readComWait " + n);
        }
        try {
            do {
                if (this.inStream.available() > 0) {
                    int n3 = this.inStream.available();
                    if (n3 + n2 > n) {
                        n3 = n - n2;
                    }
                    n2 += this.inStream.read(byArray, n2, n3);
                    continue;
                }
                if (System.currentTimeMillis() > l) break;
                Thread.yield();
                if (!doDebugMessages) continue;
                System.out.print("y");
            } while (n > n2);
            if (doDebugMessages) {
                System.out.println("Got data size: " + n2);
            }
            int n4 = 0;
            while (n4 < n2) {
                cArray[n4] = (char)(byArray[n4] & 0xFF);
                ++n4;
            }
            if (doDebugMessages) {
                int n5 = 0;
                while (n5 < n2) {
                    System.out.print("R[" + Integer.toHexString(cArray[n5] & 0xFF) + "]");
                    ++n5;
                }
            }
            if (n != n2) {
                throw new OneWireIOException("readComWait, timeout waiting for return bytes (wanted " + n + ")");
            }
            return cArray;
        }
        catch (IOException iOException) {
            throw new OneWireIOException("readComWait: " + iOException);
        }
    }

    public void flushCom() {
        if (doDebugMessages) {
            System.out.println("DEBUG: flush");
        }
        try {
            this.outStream.flush();
            while (this.inStream.available() > 0) {
                this.inStream.read();
            }
        }
        catch (IOException iOException) {
            System.err.println("EXCEPTION: flush: " + iOException);
        }
    }

    public boolean beginExclusive(boolean bl) throws OneWireException {
        if (bl) {
            while (!this.beginExclusive()) {
            }
            return true;
        }
        return this.beginExclusive();
    }

    public void endExclusive() {
        Integer n = this.currentThreadHash;
        synchronized (n) {
            if (this.currentThreadHash.intValue() == Thread.currentThread().hashCode()) {
                this.currentThreadHash = new Integer(0);
            }
        }
    }

    public boolean haveExclusive() {
        Integer n = this.currentThreadHash;
        synchronized (n) {
            boolean bl = this.currentThreadHash.intValue() == Thread.currentThread().hashCode();
            return bl;
        }
    }

    private boolean beginExclusive() throws OneWireException {
        Integer n = this.currentThreadHash;
        synchronized (n) {
            if (this.currentThreadHash == 0) {
                this.currentThreadHash = new Integer(Thread.currentThread().hashCode());
                if (doDebugMessages) {
                    System.out.println("DEBUG: beginExclusive, now owned by: " + Thread.currentThread().getName());
                }
                boolean bl = true;
                return bl;
            }
            if (this.currentThreadHash.intValue() == Thread.currentThread().hashCode()) {
                if (doDebugMessages) {
                    System.out.println("DEBUG: beginExclusive, already owned by: " + Thread.currentThread().getName());
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

