/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire.adapter;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.container.OneWireContainer;
import com.dalsemi.onewire.utils.Address;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DSPortAdapter {
    public static final int SPEED_REGULAR = 0;
    public static final int SPEED_FLEX = 1;
    public static final int SPEED_OVERDRIVE = 2;
    public static final int SPEED_HYPERDRIVE = 3;
    public static final char LEVEL_NORMAL = '\u0000';
    public static final char LEVEL_POWER_DELIVERY = '\u0001';
    public static final char LEVEL_BREAK = '\u0002';
    public static final char LEVEL_PROGRAM = '\u0003';
    public static final int RESET_NOPRESENCE = 0;
    public static final int RESET_PRESENCE = 1;
    public static final int RESET_ALARM = 2;
    public static final int RESET_SHORT = 3;
    public static final int CONDITION_NOW = 0;
    public static final int CONDITION_AFTER_BIT = 1;
    public static final int CONDITION_AFTER_BYTE = 2;
    public static final int DELIVERY_HALF_SECOND = 0;
    public static final int DELIVERY_ONE_SECOND = 1;
    public static final int DELIVERY_TWO_SECONDS = 2;
    public static final int DELIVERY_FOUR_SECONDS = 3;
    public static final int DELIVERY_SMART_DONE = 4;
    public static final int DELIVERY_INFINITE = 5;
    public static final int DELIVERY_CURRENT_DETECT = 6;
    public static final int DELIVERY_EPROM = 7;
    private Hashtable registeredOneWireContainerClasses = new Hashtable(5);
    private byte[] include;
    private byte[] exclude;

    public abstract String getAdapterName();

    public abstract String getPortTypeDescription();

    public abstract String getClassVersion();

    public abstract Enumeration getPortNames();

    public void registerOneWireContainerClass(int n, Class clazz) throws OneWireException {
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("com.dalsemi.onewire.container.OneWireContainer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new OneWireException("Could not find OneWireContainer class");
        }
        Integer n2 = new Integer(n);
        if (clazz == null) {
            this.registeredOneWireContainerClasses.remove(n2);
        } else if (clazz2.isAssignableFrom(clazz)) {
            this.registeredOneWireContainerClasses.put(n2, clazz);
        } else {
            throw new ClassCastException("Does not extend com.dalsemi.onewire.container.OneWireContainer");
        }
    }

    public abstract boolean selectPort(String var1) throws OneWireIOException, OneWireException;

    public abstract void freePort() throws OneWireException;

    public abstract String getPortName() throws OneWireException;

    public abstract boolean adapterDetected() throws OneWireIOException, OneWireException;

    public String getAdapterVersion() throws OneWireIOException, OneWireException {
        return "<na>";
    }

    public String getAdapterAddress() throws OneWireIOException, OneWireException {
        return "<na>";
    }

    public boolean canOverdrive() throws OneWireIOException, OneWireException {
        return false;
    }

    public boolean canHyperdrive() throws OneWireIOException, OneWireException {
        return false;
    }

    public boolean canFlex() throws OneWireIOException, OneWireException {
        return false;
    }

    public boolean canProgram() throws OneWireIOException, OneWireException {
        return false;
    }

    public boolean canDeliverPower() throws OneWireIOException, OneWireException {
        return false;
    }

    public boolean canDeliverSmartPower() throws OneWireIOException, OneWireException {
        return false;
    }

    public boolean canBreak() throws OneWireIOException, OneWireException {
        return false;
    }

    public Enumeration getAllDeviceContainers() throws OneWireIOException, OneWireException {
        Vector<OneWireContainer> vector = new Vector<OneWireContainer>();
        OneWireContainer oneWireContainer = this.getFirstDeviceContainer();
        if (oneWireContainer != null) {
            vector.addElement(oneWireContainer);
            do {
                if ((oneWireContainer = this.getNextDeviceContainer()) == null) continue;
                vector.addElement(oneWireContainer);
            } while (oneWireContainer != null);
        }
        return vector.elements();
    }

    public OneWireContainer getFirstDeviceContainer() throws OneWireIOException, OneWireException {
        if (this.findFirstDevice()) {
            return this.getDeviceContainer();
        }
        return null;
    }

    public OneWireContainer getNextDeviceContainer() throws OneWireIOException, OneWireException {
        if (this.findNextDevice()) {
            return this.getDeviceContainer();
        }
        return null;
    }

    public abstract boolean findFirstDevice() throws OneWireIOException, OneWireException;

    public abstract boolean findNextDevice() throws OneWireIOException, OneWireException;

    public abstract void getAddress(byte[] var1);

    public long getAddressAsLong() {
        byte[] byArray = new byte[8];
        this.getAddress(byArray);
        return Address.toLong(byArray);
    }

    public String getAddressAsString() {
        byte[] byArray = new byte[8];
        this.getAddress(byArray);
        return Address.toString(byArray);
    }

    public boolean isPresent(byte[] byArray) throws OneWireIOException, OneWireException {
        this.reset();
        this.putByte(240);
        return this.strongAccess(byArray);
    }

    public boolean isPresent(long l) throws OneWireIOException, OneWireException {
        return this.isPresent(Address.toByteArray(l));
    }

    public boolean isPresent(String string) throws OneWireIOException, OneWireException {
        return this.isPresent(Address.toByteArray(string));
    }

    public boolean isAlarming(byte[] byArray) throws OneWireIOException, OneWireException {
        this.reset();
        this.putByte(236);
        return this.strongAccess(byArray);
    }

    public boolean isAlarming(long l) throws OneWireIOException, OneWireException {
        return this.isAlarming(Address.toByteArray(l));
    }

    public boolean isAlarming(String string) throws OneWireIOException, OneWireException {
        return this.isAlarming(Address.toByteArray(string));
    }

    public boolean select(byte[] byArray) throws OneWireIOException, OneWireException {
        int n = this.reset();
        byte[] byArray2 = new byte[9];
        byArray2[0] = 85;
        System.arraycopy(byArray, 0, byArray2, 1, 8);
        this.dataBlock(byArray2, 0, 9);
        return n == 1 || n == 2;
    }

    public boolean select(long l) throws OneWireIOException, OneWireException {
        return this.select(Address.toByteArray(l));
    }

    public boolean select(String string) throws OneWireIOException, OneWireException {
        return this.select(Address.toByteArray(string));
    }

    public abstract void setSearchOnlyAlarmingDevices();

    public abstract void setNoResetSearch();

    public abstract void setSearchAllDevices();

    public void targetAllFamilies() {
        this.include = null;
        this.exclude = null;
    }

    public void targetFamily(int n) {
        if (this.include == null || this.include.length != 1) {
            this.include = new byte[1];
        }
        this.include[0] = (byte)n;
    }

    public void targetFamily(byte[] byArray) {
        if (this.include == null || this.include.length != byArray.length) {
            this.include = new byte[byArray.length];
        }
        System.arraycopy(byArray, 0, this.include, 0, byArray.length);
    }

    public void excludeFamily(int n) {
        if (this.exclude == null || this.exclude.length != 1) {
            this.exclude = new byte[1];
        }
        this.exclude[0] = (byte)n;
    }

    public void excludeFamily(byte[] byArray) {
        if (this.exclude == null || this.exclude.length != byArray.length) {
            this.exclude = new byte[byArray.length];
        }
        System.arraycopy(byArray, 0, this.exclude, 0, byArray.length);
    }

    public abstract boolean beginExclusive(boolean var1) throws OneWireException;

    public abstract void endExclusive();

    public abstract void putBit(boolean var1) throws OneWireIOException, OneWireException;

    public abstract boolean getBit() throws OneWireIOException, OneWireException;

    public abstract void putByte(int var1) throws OneWireIOException, OneWireException;

    public abstract int getByte() throws OneWireIOException, OneWireException;

    public abstract byte[] getBlock(int var1) throws OneWireIOException, OneWireException;

    public abstract void getBlock(byte[] var1, int var2) throws OneWireIOException, OneWireException;

    public abstract void getBlock(byte[] var1, int var2, int var3) throws OneWireIOException, OneWireException;

    public abstract void dataBlock(byte[] var1, int var2, int var3) throws OneWireIOException, OneWireException;

    public abstract int reset() throws OneWireIOException, OneWireException;

    public void setPowerDuration(int n) throws OneWireIOException, OneWireException {
        throw new OneWireException("Power delivery not supported by this adapter type");
    }

    public boolean startPowerDelivery(int n) throws OneWireIOException, OneWireException {
        throw new OneWireException("Power delivery not supported by this adapter type");
    }

    public void setProgramPulseDuration(int n) throws OneWireIOException, OneWireException {
        throw new OneWireException("Program pulse delivery not supported by this adapter type");
    }

    public boolean startProgramPulse(int n) throws OneWireIOException, OneWireException {
        throw new OneWireException("Program pulse delivery not supported by this adapter type");
    }

    public void startBreak() throws OneWireIOException, OneWireException {
        throw new OneWireException("Break delivery not supported by this adapter type");
    }

    public void setPowerNormal() throws OneWireIOException, OneWireException {
    }

    public void setSpeed(int n) throws OneWireIOException, OneWireException {
        if (n != 0) {
            throw new OneWireException("Non-regular 1-Wire speed not supported by this adapter type");
        }
    }

    public int getSpeed() {
        return 0;
    }

    public OneWireContainer getDeviceContainer(byte[] byArray) {
        OneWireContainer oneWireContainer;
        int n = byArray[0] & 0x7F;
        String string = n < 16 ? ("0" + Integer.toHexString(n)).toUpperCase() : Integer.toHexString(n).toUpperCase();
        Class<?> clazz = null;
        if (!this.registeredOneWireContainerClasses.isEmpty()) {
            Integer n2 = new Integer(n);
            clazz = (Class)this.registeredOneWireContainerClasses.get(n2);
        }
        if (clazz == null) {
            try {
                clazz = Class.forName("com.dalsemi.onewire.container.OneWireContainer" + string);
            }
            catch (Exception exception) {
                clazz = null;
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName("com.dalsemi.onewire.container.OneWireContainer");
                }
                catch (Exception exception) {
                    System.out.println("EXCEPTION: Unable to load OneWireContainer" + exception);
                    return null;
                }
            }
        }
        try {
            oneWireContainer = (OneWireContainer)clazz.newInstance();
            oneWireContainer.setupContainer(this, byArray);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Unable to instantiate OneWireContainer " + clazz);
            return null;
        }
        return oneWireContainer;
    }

    public OneWireContainer getDeviceContainer(long l) {
        return this.getDeviceContainer(Address.toByteArray(l));
    }

    public OneWireContainer getDeviceContainer(String string) {
        return this.getDeviceContainer(Address.toByteArray(string));
    }

    public OneWireContainer getDeviceContainer() {
        byte[] byArray = new byte[8];
        this.getAddress(byArray);
        return this.getDeviceContainer(byArray);
    }

    protected boolean isValidFamily(byte[] byArray) {
        int n;
        byte by = byArray[0];
        if (this.exclude != null) {
            n = 0;
            while (n < this.exclude.length) {
                if (by == this.exclude[n]) {
                    return false;
                }
                ++n;
            }
        }
        if (this.include != null) {
            n = 0;
            while (n < this.include.length) {
                if (by == this.include[n]) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    private boolean strongAccess(byte[] byArray) throws OneWireIOException, OneWireException {
        byte[] byArray2 = new byte[24];
        int n = 0;
        while (n < 24) {
            byArray2[n] = -1;
            ++n;
        }
        n = 0;
        while (n < 64) {
            this.arrayWriteBit(this.arrayReadBit(n, byArray), (n + 1) * 3 - 1, byArray2);
            ++n;
        }
        this.dataBlock(byArray2, 0, 24);
        int n2 = 56;
        int n3 = 0;
        n = 168;
        while (n < 192) {
            int n4 = this.arrayReadBit(n, byArray2) << 1 | this.arrayReadBit(n + 1, byArray2);
            int n5 = this.arrayReadBit(n2++, byArray);
            if (n4 == 3) {
                n3 = 0;
                break;
            }
            if (n5 == 1 && n4 == 2 || n5 == 0 && n4 == 1) {
                ++n3;
            }
            n += 3;
        }
        return n3 >= 8;
    }

    private void arrayWriteBit(int n, int n2, byte[] byArray) {
        int n3 = n2 >>> 3;
        int n4 = n2 - (n3 << 3);
        if (n == 1) {
            int n5 = n3;
            byArray[n5] = (byte)(byArray[n5] | 1 << n4);
        } else {
            int n6 = n3;
            byArray[n6] = (byte)(byArray[n6] & ~(1 << n4));
        }
    }

    private int arrayReadBit(int n, byte[] byArray) {
        int n2 = n >>> 3;
        int n3 = n - (n2 << 3);
        return byArray[n2] >>> n3 & 1;
    }
}

