/*
 * Decompiled with CFR 0.152.
 */
package com.dalsemi.onewire;

import com.dalsemi.onewire.OneWireException;
import com.dalsemi.onewire.adapter.DSPortAdapter;
import com.dalsemi.onewire.adapter.OneWireIOException;
import com.dalsemi.onewire.adapter.TMEXAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class OneWireAccessProvider {
    private static String smartDefaultPort = "COM1";

    private OneWireAccessProvider() {
    }

    public static Enumeration enumerateAllAdapters() {
        Class<?> clazz;
        DSPortAdapter dSPortAdapter;
        Vector<DSPortAdapter> vector = new Vector<DSPortAdapter>(3, 1);
        String string = null;
        if (System.getProperty("os.arch").indexOf("86") != -1 && System.getProperty("os.name").indexOf("Windows") != -1) {
            int n = 0;
            while (n <= 15) {
                try {
                    dSPortAdapter = new TMEXAdapter(n);
                    if (dSPortAdapter.getPortNames().hasMoreElements()) {
                        vector.addElement(dSPortAdapter);
                    }
                }
                catch (Exception exception) {
                }
                catch (Error error) {
                    // empty catch block
                }
                ++n;
            }
        }
        try {
            clazz = Class.forName("com.dalsemi.onewire.adapter.USerialAdapter");
            dSPortAdapter = (DSPortAdapter)clazz.newInstance();
            if (!dSPortAdapter.getPortNames().hasMoreElements()) {
                System.err.println("javax.comm not setup properly, no ports in enumeration ");
                System.err.println("javax.comm pure-Java DS9097U adapter will not work, not added to adapter enum");
            } else {
                vector.addElement(dSPortAdapter);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println("Could not load javax.comm for pure-Java DS9097U adapter: " + noClassDefFoundError);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n = 0;
            while (n <= 15) {
                string = OneWireAccessProvider.getProperty("onewire.register.adapter" + n);
                if (string != null) {
                    clazz = Class.forName(string);
                    dSPortAdapter = (DSPortAdapter)clazz.newInstance();
                    vector.addElement(dSPortAdapter);
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Adapter \"" + string + "\" was registered in properties file, but the class was not found");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vector.isEmpty()) {
            System.err.println("No 1-Wire adapter classes found");
        }
        return vector.elements();
    }

    public static DSPortAdapter getAdapter(String string, String string2) throws OneWireIOException, OneWireException {
        Enumeration enumeration = OneWireAccessProvider.enumerateAllAdapters();
        while (enumeration.hasMoreElements()) {
            DSPortAdapter dSPortAdapter = (DSPortAdapter)enumeration.nextElement();
            if (!dSPortAdapter.getAdapterName().equals(string)) continue;
            if (dSPortAdapter.selectPort(string2)) {
                dSPortAdapter.beginExclusive(true);
                try {
                    if (dSPortAdapter.adapterDetected()) {
                        DSPortAdapter dSPortAdapter2 = dSPortAdapter;
                        Object var6_5 = null;
                        dSPortAdapter.endExclusive();
                        return dSPortAdapter2;
                    }
                    dSPortAdapter.freePort();
                    throw new OneWireException("Port found \"" + string2 + "\" but Adapter \"" + string + "\" not detected");
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    dSPortAdapter.endExclusive();
                    throw throwable;
                }
            }
            throw new OneWireException("Specified port \"" + string2 + "\" could not be selected for adapter \"" + string + "\"");
        }
        throw new OneWireException("Specified adapter name \"" + string + "\" is not known");
    }

    public static DSPortAdapter getDefaultAdapter() throws OneWireIOException, OneWireException {
        return OneWireAccessProvider.getAdapter(OneWireAccessProvider.getProperty("onewire.adapter.default"), OneWireAccessProvider.getProperty("onewire.port.default"));
    }

    public static String getProperty(String string) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        String string2 = null;
        try {
            string2 = System.getProperty(string, null);
        }
        catch (Exception exception) {
            string2 = null;
        }
        if (string2 == null) {
            String string3 = new String("");
            int n = 0;
            while (n <= 1) {
                try {
                    fileInputStream = new FileInputStream(string3 + "onewire.properties");
                }
                catch (IOException iOException) {
                    fileInputStream = null;
                }
                if (fileInputStream != null) {
                    try {
                        properties.load(fileInputStream);
                        string2 = properties.getProperty(string, null);
                    }
                    catch (Exception exception) {
                        string2 = null;
                    }
                }
                if (string2 != null) break;
                string3 = System.getProperty("java.home") + File.separator + "lib" + File.separator;
                ++n;
            }
        }
        if (string2 == null) {
            try {
                if (string.equals("onewire.adapter.default")) {
                    string2 = TMEXAdapter.getDefaultAdapterName();
                } else if (string.equals("onewire.port.default")) {
                    string2 = TMEXAdapter.getDefaultPortName();
                }
                if (string2 != null && string2.length() <= 0) {
                    string2 = null;
                }
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (string2 == null) {
            if (string.equals("onewire.adapter.default")) {
                string2 = "DS9097U";
            } else if (string.equals("onewire.port.default")) {
                try {
                    Class<?> clazz = Class.forName("com.dalsemi.onewire.adapter.USerialAdapter");
                    DSPortAdapter dSPortAdapter = (DSPortAdapter)clazz.newInstance();
                    if (dSPortAdapter.getPortNames().hasMoreElements()) {
                        string2 = (String)dSPortAdapter.getPortNames().nextElement();
                    }
                }
                catch (Exception exception) {
                }
                catch (Error error) {
                    // empty catch block
                }
            }
        }
        return string2;
    }
}

