/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Base64 {
    private static final char[] code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    private Base64() {
    }

    private static void encodeRest(StringBuilder out, byte[] s, int num) {
        long val = num == 2 ? (long)(s[0] << 16 | s[1] << 8) : (long)(s[0] << 16);
        out.append(code[(int)(val >> 18 & 0x3FL)]);
        out.append(code[(int)(val >> 12 & 0x3FL)]);
        if (num == 2) {
            out.append(code[(int)(val >> 6 & 0x3FL)]);
        } else {
            out.append('=');
        }
        out.append('=');
    }

    private static void encodeTriplet(StringBuilder out, byte[] s) {
        int val = s[0] << 16 | s[1] << 8 | s[2];
        out.append(code[val >> 18 & 0x3F]);
        out.append(code[val >> 12 & 0x3F]);
        out.append(code[val >> 6 & 0x3F]);
        out.append(code[val & 0x3F]);
    }

    private static boolean encode(StringBuilder out, InputStream in) throws IOException {
        byte[] s = new byte[3];
        int num = in.read(s);
        switch (num) {
            case 3: {
                Base64.encodeTriplet(out, s);
                return true;
            }
            case 1: 
            case 2: {
                Base64.encodeRest(out, s, num);
            }
            case -1: {
                return false;
            }
        }
        throw new AssertionError((Object)("Invalid length! " + num));
    }

    public static String encode(byte[] input) {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        StringBuilder sb = new StringBuilder();
        try {
            while (Base64.encode(sb, in)) {
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Base64.class.getName()).log(Level.SEVERE, null, ex);
        }
        return sb.toString();
    }

    public static String encode(String input) {
        return Base64.encode(input.getBytes());
    }

    private static byte getByte(byte val) {
        for (byte ii = 0; ii < code.length; ii = (byte)(ii + 1)) {
            if (code[ii] != val) continue;
            return ii;
        }
        throw new IllegalAccessError();
    }

    private static boolean decode(StringBuilder out, InputStream in) throws IOException {
        byte[] s = new byte[4];
        int num = in.read(s);
        if (num == -1) {
            return false;
        }
        int len = 3;
        int val = 0;
        val |= Base64.getByte(s[0]) << 18;
        val |= Base64.getByte(s[1]) << 12;
        if (s[2] == 61) {
            --len;
        } else {
            val |= Base64.getByte(s[2]) << 6;
        }
        if (s[3] == 61) {
            --len;
        } else {
            val |= Base64.getByte(s[3]);
        }
        out.append((char)(val >> 16 & 0xFF));
        if (len > 1) {
            out.append((char)(val >> 8 & 0xFF));
        }
        if (len > 2) {
            out.append((char)(val & 0xFF));
        }
        return len == 3;
    }

    public static String decode(String input) {
        ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes());
        StringBuilder sb = new StringBuilder();
        try {
            while (Base64.decode(sb, in)) {
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Base64.class.getName()).log(Level.SEVERE, null, ex);
        }
        return sb.toString();
    }
}

