/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

public enum CommandCode {
    GET(0),
    SET(1),
    ADD(2),
    REPLACE(3),
    DELETE(4),
    INCREMENT(5),
    DECREMENT(6),
    QUIT(7),
    FLUSH(8),
    GETQ(9),
    NOOP(10),
    VERSION(11),
    GETK(12),
    GETKQ(13),
    APPEND(14),
    PREPEND(15),
    STAT(16),
    SETQ(17),
    ADDQ(18),
    REPLACEQ(19),
    DELETEQ(20),
    INCREMENTQ(21),
    DECREMENTQ(22),
    QUITQ(23),
    FLUSHQ(24),
    APPENDQ(25),
    PREPENDQ(26),
    VERBOSITY(27),
    TOUCH(28),
    GAT(29),
    GATQ(30),
    SASL_LIST_MECHS(32),
    SASL_AUTH(33),
    SASL_STEP(34),
    RGET(48),
    RSET(49),
    RSETQ(50),
    RAPPEND(51),
    RAPPENDQ(52),
    RPREPEND(53),
    RPREPENDQ(54),
    RDELETE(55),
    RDELETEQ(56),
    RINCR(57),
    RINCRQ(58),
    RDECR(59),
    RDECRQ(60),
    SET_VBUCKET(61),
    GET_VBUCKET(62),
    DEL_VBUCKET(63),
    TAP_CONNECT(64),
    TAP_MUTATION(65),
    TAP_DELETE(66),
    TAP_FLUSH(67),
    TAP_OPAQUE(68),
    TAP_VBUCKET_SET(69),
    LAST_RESERVED(239),
    SCRUB(240),
    GET_REPLICA(131),
    SELECT_BUCKET(137),
    OBSERVE(146),
    EVICT(147),
    GETL(148),
    UNL(149),
    GET_CLUSTER_CONFIG(181),
    HELLO(31),
    GET_ERRMAP(254),
    ILLEGAL(255),
    OBSERVE_SEQNO(145),
    GET_RANDOM(182),
    SUBDOC_GET(197),
    SUBDOC_EXISTS(198),
    SUBDOC_DICT_ADD(199),
    SUBDOC_DICT_UPSERT(200),
    SUBDOC_DELETE(201),
    SUBDOC_REPLACE(202),
    SUBDOC_ARRAY_PUSH_LAST(203),
    SUBDOC_ARRAY_PUSH_FIRST(204),
    SUBDOC_ARRAY_INSERT(205),
    SUBDOC_ARRAY_ADD_UNIQUE(206),
    SUBDOC_COUNTER(207),
    SUBDOC_MULTI_LOOKUP(208),
    SUBDOC_MULTI_MUTATION(209),
    SUBDOC_GET_COUNT(210);

    private final int value;

    private CommandCode(int value) {
        this.value = value;
    }

    public int cc() {
        return this.value;
    }

    public static CommandCode valueOf(byte cc) {
        return CommandCode.valueOf(cc & 0xFF);
    }

    public static CommandCode valueOf(int cc) {
        switch (cc) {
            case 0: {
                return GET;
            }
            case 1: {
                return SET;
            }
            case 2: {
                return ADD;
            }
            case 3: {
                return REPLACE;
            }
            case 4: {
                return DELETE;
            }
            case 5: {
                return INCREMENT;
            }
            case 6: {
                return DECREMENT;
            }
            case 7: {
                return QUIT;
            }
            case 8: {
                return FLUSH;
            }
            case 9: {
                return GETQ;
            }
            case 10: {
                return NOOP;
            }
            case 11: {
                return VERSION;
            }
            case 12: {
                return GETK;
            }
            case 13: {
                return GETKQ;
            }
            case 14: {
                return APPEND;
            }
            case 15: {
                return PREPEND;
            }
            case 16: {
                return STAT;
            }
            case 17: {
                return SETQ;
            }
            case 18: {
                return ADDQ;
            }
            case 19: {
                return REPLACEQ;
            }
            case 20: {
                return DELETEQ;
            }
            case 21: {
                return INCREMENTQ;
            }
            case 22: {
                return DECREMENTQ;
            }
            case 23: {
                return QUITQ;
            }
            case 24: {
                return FLUSHQ;
            }
            case 25: {
                return APPENDQ;
            }
            case 26: {
                return PREPENDQ;
            }
            case 27: {
                return VERBOSITY;
            }
            case 28: {
                return TOUCH;
            }
            case 29: {
                return GAT;
            }
            case 30: {
                return GATQ;
            }
            case 32: {
                return SASL_LIST_MECHS;
            }
            case 33: {
                return SASL_AUTH;
            }
            case 34: {
                return SASL_STEP;
            }
            case 147: {
                return EVICT;
            }
            case 148: {
                return GETL;
            }
            case 149: {
                return UNL;
            }
            case 131: {
                return GET_REPLICA;
            }
            case 146: {
                return OBSERVE;
            }
            case 181: {
                return GET_CLUSTER_CONFIG;
            }
            case 31: {
                return HELLO;
            }
            case 145: {
                return OBSERVE_SEQNO;
            }
            case 197: {
                return SUBDOC_GET;
            }
            case 198: {
                return SUBDOC_EXISTS;
            }
            case 199: {
                return SUBDOC_DICT_ADD;
            }
            case 200: {
                return SUBDOC_DICT_UPSERT;
            }
            case 201: {
                return SUBDOC_DELETE;
            }
            case 202: {
                return SUBDOC_REPLACE;
            }
            case 203: {
                return SUBDOC_ARRAY_PUSH_LAST;
            }
            case 204: {
                return SUBDOC_ARRAY_PUSH_FIRST;
            }
            case 205: {
                return SUBDOC_ARRAY_INSERT;
            }
            case 206: {
                return SUBDOC_ARRAY_ADD_UNIQUE;
            }
            case 207: {
                return SUBDOC_COUNTER;
            }
            case 208: {
                return SUBDOC_MULTI_LOOKUP;
            }
            case 209: {
                return SUBDOC_MULTI_MUTATION;
            }
            case 210: {
                return SUBDOC_GET_COUNT;
            }
            case 182: {
                return GET_RANDOM;
            }
            case 254: {
                return GET_ERRMAP;
            }
            case 137: {
                return SELECT_BUCKET;
            }
        }
        return ILLEGAL;
    }

    static String toString(CommandCode cc) {
        switch (cc) {
            case SET: {
                return "set";
            }
            case ADD: {
                return "add";
            }
            case REPLACE: {
                return "replace";
            }
            case FLUSH: {
                return "flush";
            }
            case DELETE: {
                return "delete";
            }
            case INCREMENT: {
                return "increment";
            }
            case DECREMENT: {
                return "decrement";
            }
            case PREPEND: {
                return "prepend";
            }
            case APPEND: {
                return "append";
            }
            case VERSION: {
                return "version";
            }
            case NOOP: {
                return "noop";
            }
            case QUIT: {
                return "quit";
            }
            case GET: {
                return "get";
            }
            case GETQ: {
                return "getq";
            }
            case GETK: {
                return "getk";
            }
            case GETKQ: {
                return "getkq";
            }
            case ILLEGAL: {
                return "Illegal";
            }
            case STAT: {
                return "stat";
            }
            case SETQ: {
                return "setq";
            }
            case ADDQ: {
                return "addq";
            }
            case REPLACEQ: {
                return "replaceq";
            }
            case DELETEQ: {
                return "deleteq";
            }
            case INCREMENTQ: {
                return "incrementq";
            }
            case DECREMENTQ: {
                return "decrementq";
            }
            case QUITQ: {
                return "quitq";
            }
            case FLUSHQ: {
                return "flushq";
            }
            case APPENDQ: {
                return "appendq";
            }
            case PREPENDQ: {
                return "prependq";
            }
            case VERBOSITY: {
                return "verbosity";
            }
            case SASL_LIST_MECHS: {
                return "sasl_list_mechs";
            }
            case SASL_AUTH: {
                return "sasl_auth";
            }
            case SASL_STEP: {
                return "sasl_step";
            }
            case TOUCH: {
                return "touch";
            }
            case GAT: {
                return "gat";
            }
            case GATQ: {
                return "gatq";
            }
            case EVICT: {
                return "evict";
            }
            case GETL: {
                return "getl";
            }
            case UNL: {
                return "unl";
            }
            case GET_REPLICA: {
                return "get_replica";
            }
            case OBSERVE: {
                return "observe";
            }
            case GET_CLUSTER_CONFIG: {
                return "get_cluster_config";
            }
            case HELLO: {
                return "hello";
            }
            case OBSERVE_SEQNO: {
                return "observe_seqno";
            }
            case SUBDOC_GET: {
                return "subdoc_get";
            }
            case SUBDOC_EXISTS: {
                return "subdoc_exists";
            }
            case SUBDOC_GET_COUNT: {
                return "subdoc_get_count";
            }
            case GET_RANDOM: {
                return "get_random";
            }
            case GET_ERRMAP: {
                return "get_errormap";
            }
            case SELECT_BUCKET: {
                return "select_bucket";
            }
        }
        return "unknown";
    }
}

