/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.SubdocItem;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.CommandCode;
import com.couchbase.mock.subdoc.Operation;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class BinarySubdocCommand
extends BinaryCommand {
    private final Operation subdocOp;
    public static final byte PATHFLAG_MKDIR_P = 1;
    public static final byte PATHFLAG_XATTR = 4;
    public static final byte PATHFLAG_EXPAND_MACROS = 16;
    public static final byte DOCFLAG_MKDOC = 1;
    public static final byte DOCFLAG_ADD = 2;
    public static final byte DOCFLAG_CREATEMASK = 3;
    public static final byte DOCFLAG_ACCESS_DELETED = 4;
    private static final Map<CommandCode, Operation> opMap = new HashMap<CommandCode, Operation>();

    BinarySubdocCommand(ByteBuffer header) throws ProtocolException {
        super(header);
        switch (this.extraLength) {
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                throw new ProtocolException("Extras must be 3, 4, 7, or 8");
            }
        }
        this.subdocOp = BinarySubdocCommand.toSubdocOpcode(this.getComCode());
        if (this.subdocOp == null) {
            throw new ProtocolException("Unhandled opcode: " + (Object)((Object)this.getComCode()));
        }
    }

    public static Operation toSubdocOpcode(CommandCode op) {
        return opMap.get((Object)op);
    }

    public byte getSubdocPathFlags() {
        return this.bodyBuffer.get(2);
    }

    public byte getSubdocDocFlags() {
        switch (this.extraLength) {
            case 3: {
                return 0;
            }
            case 4: {
                return this.bodyBuffer.get(3);
            }
            case 7: {
                return 0;
            }
            case 8: {
                return this.bodyBuffer.get(7);
            }
        }
        return 0;
    }

    public Operation getSubdocOp() {
        return this.subdocOp;
    }

    public SubdocItem getItem() {
        int expiryTime = 0;
        if (this.extraLength == 7) {
            expiryTime = this.bodyBuffer.getInt(3);
        }
        short pathLength = this.bodyBuffer.getShort(0);
        byte[] path = new byte[pathLength];
        this.bodyBuffer.position(this.extraLength + this.keyLength);
        this.bodyBuffer.get(path);
        int valueLength = this.bodyLength - (this.keyLength + pathLength + this.extraLength);
        byte[] value = new byte[valueLength];
        this.bodyBuffer.position(this.extraLength + this.keyLength + pathLength);
        this.bodyBuffer.get(value);
        return new SubdocItem(this.getKeySpec(), 0, expiryTime, path, value, this.cas);
    }

    static {
        opMap.put(CommandCode.SUBDOC_GET, Operation.GET);
        opMap.put(CommandCode.SUBDOC_EXISTS, Operation.EXISTS);
        opMap.put(CommandCode.SUBDOC_DICT_ADD, Operation.DICT_ADD);
        opMap.put(CommandCode.SUBDOC_DICT_UPSERT, Operation.DICT_UPSERT);
        opMap.put(CommandCode.SUBDOC_DELETE, Operation.REMOVE);
        opMap.put(CommandCode.SUBDOC_REPLACE, Operation.REPLACE);
        opMap.put(CommandCode.SUBDOC_ARRAY_PUSH_LAST, Operation.ARRAY_APPEND);
        opMap.put(CommandCode.SUBDOC_ARRAY_PUSH_FIRST, Operation.ARRAY_PREPEND);
        opMap.put(CommandCode.SUBDOC_ARRAY_INSERT, Operation.ARRAY_INSERT);
        opMap.put(CommandCode.SUBDOC_ARRAY_ADD_UNIQUE, Operation.ADD_UNIQUE);
        opMap.put(CommandCode.SUBDOC_COUNTER, Operation.COUNTER);
        opMap.put(CommandCode.SUBDOC_GET_COUNT, Operation.GET_COUNT);
        opMap.put(CommandCode.GET, Operation.GET_FULLDOC);
        opMap.put(CommandCode.SET, Operation.WRITE_FULLDOC);
    }
}

