/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.client;

import com.couchbase.mock.memcached.protocol.CommandCode;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ClientResponse {
    private CommandCode code;
    private ErrorCode status;
    private byte[] extras;
    private byte[] key;
    private byte[] value;
    private byte[] body;
    private int opaque;
    private byte opcode;
    long cas;

    public long getCas() {
        return this.cas;
    }

    public long getOpaque() {
        return this.opaque;
    }

    public String getKey() {
        return new String(this.key);
    }

    public String getValue() {
        return new String(this.value);
    }

    public ByteBuffer getRawValue() {
        return ByteBuffer.wrap(this.value);
    }

    public byte[] getExtras() {
        return this.extras;
    }

    public ErrorCode getStatus() {
        return this.status;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    public CommandCode getComCode() {
        return this.code;
    }

    public boolean success() {
        return this.status == ErrorCode.SUCCESS;
    }

    public static ClientResponse read(InputStream input) throws IOException {
        int nr;
        int remaining;
        int nr2;
        byte[] header = new byte[24];
        for (remaining = header.length; remaining > 0 && (nr2 = input.read(header, header.length - remaining, remaining)) != -1; remaining -= nr2) {
        }
        if (remaining > 0) {
            throw new IOException("Incomplete read before stream closed");
        }
        ByteBuffer buf = ByteBuffer.wrap(header);
        byte magic = buf.get();
        if (magic != -127) {
            throw new IOException("Illegal magic: " + magic);
        }
        ClientResponse ret = new ClientResponse();
        ret.opcode = buf.get();
        ret.code = CommandCode.valueOf(ret.opcode);
        short keylen = buf.getShort();
        byte extlen = buf.get();
        buf.get();
        ret.status = ErrorCode.valueOf(buf.getShort());
        int totalLen = buf.getInt();
        ret.opaque = buf.getInt();
        ret.cas = buf.getLong();
        ret.body = new byte[totalLen];
        for (remaining = ret.body.length; remaining > 0; remaining -= nr) {
            nr = input.read(ret.body, ret.body.length - remaining, remaining);
            if (nr >= 0) continue;
            throw new IOException("Incomplete read");
        }
        ret.extras = Arrays.copyOfRange(ret.body, 0, (int)extlen);
        ret.key = Arrays.copyOfRange(ret.body, (int)extlen, extlen + keylen);
        ret.value = Arrays.copyOfRange(ret.body, extlen + keylen, ret.body.length);
        return ret;
    }
}

