/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.KeySpec;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.VBucketInfo;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.BinaryStatResponse;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.util.Map;

public class StatCommandExecutor
implements CommandExecutor {
    private void keyStats(BinaryCommand cmd, String key, MemcachedServer server, MemcachedConnection client) {
        String[] kstatReq = key.split(" ");
        if (kstatReq.length != 3) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.EINVAL));
        }
        key = kstatReq[1];
        short vbid = Short.parseShort(kstatReq[2]);
        VBucketInfo vbInfo = server.getStorage().getVBucketInfo(vbid);
        VBucketStore cache = server.getStorage().getCache(vbid);
        if (!vbInfo.hasAccess(server)) {
            throw new IllegalArgumentException("Wrong vBucket");
        }
        KeySpec ks = new KeySpec(key, vbid);
        Item item = cache.get(ks);
        Item diskItem = server.getStorage().getPersisted(ks);
        if (item == null) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.KEY_ENOENT));
            return;
        }
        String stateStr = server == vbInfo.getOwner() ? "active" : "replica";
        client.sendResponse(new BinaryStatResponse(cmd, "key_vb_state", stateStr));
        client.sendResponse(new BinaryStatResponse(cmd, "key_flags", "" + item.getFlags()));
        client.sendResponse(new BinaryStatResponse(cmd, "key_cas", "" + item.getCas()));
        client.sendResponse(new BinaryStatResponse(cmd, "key_exptime", "" + item.getExpiryTime()));
        boolean isDirty = false;
        if (diskItem == null || diskItem.getCas() != item.getCas()) {
            isDirty = true;
        }
        client.sendResponse(new BinaryStatResponse(cmd, "key_is_dirty", isDirty ? "1" : "0"));
        client.sendResponse(new BinaryResponse(cmd, ErrorCode.SUCCESS));
    }

    @Override
    public BinaryResponse execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        String key = cmd.getKey();
        if (key != null && key.startsWith("key ")) {
            try {
                this.keyStats(cmd, key, server, client);
            }
            catch (IllegalArgumentException ex) {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.EINVAL));
            }
            return null;
        }
        if ("uuid".equals(key)) {
            client.sendResponse(new BinaryStatResponse(cmd, "uuid", server.getBucket().getUUID()));
        } else {
            Map<String, String> myStats = server.getStats(key);
            if (myStats == null) {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.KEY_ENOENT));
                return null;
            }
            for (Map.Entry<String, String> stat : myStats.entrySet()) {
                client.sendResponse(new BinaryStatResponse(cmd, stat.getKey(), stat.getValue()));
            }
        }
        client.sendResponse(new BinaryResponse(cmd, ErrorCode.SUCCESS));
        return null;
    }
}

