/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.MutationInfoWriter;
import com.couchbase.mock.memcached.MutationStatus;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.protocol.BinaryArithmeticCommand;
import com.couchbase.mock.memcached.protocol.BinaryArithmeticResponse;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.CommandCode;
import com.couchbase.mock.memcached.protocol.Datatype;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.net.ProtocolException;

public class ArithmeticCommandExecutor
implements CommandExecutor {
    @Override
    public BinaryResponse execute(BinaryCommand command, MemcachedServer server, MemcachedConnection client) throws ProtocolException {
        long value;
        BinaryArithmeticCommand cmd = (BinaryArithmeticCommand)command;
        VBucketStore cache = server.getStorage().getCache(server, cmd.getVBucketId());
        Item item = cache.get(cmd.getKeySpec());
        CommandCode cc = cmd.getComCode();
        MutationInfoWriter miw = client.getMutinfoWriter();
        if (item == null) {
            if (cmd.create()) {
                item = new Item(cmd.getKeySpec(), 0, cmd.getExpiration(), Long.toString(cmd.getInitial()).getBytes(), null, 0L, Datatype.RAW.value());
                MutationStatus ms = cache.add(item, client.supportsXerror());
                ErrorCode err = ms.getStatus();
                switch (err) {
                    case KEY_EEXISTS: {
                        return this.execute(command, server, client);
                    }
                    case SUCCESS: {
                        if (cc == CommandCode.INCREMENT || cc == CommandCode.DECREMENT) {
                            return new BinaryArithmeticResponse(cmd, cmd.getInitial(), item.getCas(), ms, miw);
                        }
                        throw new ProtocolException("invalid opcode for Arithmetic handler: " + (Object)((Object)cc));
                    }
                }
                return new BinaryResponse(command, err);
            }
            return new BinaryResponse(command, ErrorCode.KEY_ENOENT);
        }
        if (!item.ensureUnlocked(command.getCas())) {
            return new BinaryResponse(command, ErrorCode.ETMPFAIL);
        }
        try {
            value = Long.parseLong(new String(item.getValue()));
        }
        catch (NumberFormatException ex) {
            return new BinaryResponse(command, ErrorCode.DELTA_BADVAL);
        }
        value = cc == CommandCode.INCREMENT || cc == CommandCode.INCREMENTQ ? (value += cmd.getDelta()) : (value -= cmd.getDelta());
        int exp = cmd.getExpiration() > 0 ? cmd.getExpiration() : item.getExpiryTime();
        Item newValue = new Item(cmd.getKeySpec(), item.getFlags(), exp, Long.toString(value).getBytes(), null, item.getCas(), Datatype.RAW.value());
        MutationStatus ms = cache.set(newValue, client.supportsXerror());
        if (ms.getStatus() == ErrorCode.SUCCESS) {
            if (cc == CommandCode.INCREMENT || cc == CommandCode.DECREMENT) {
                return new BinaryArithmeticResponse(cmd, value, newValue.getCas(), ms, miw);
            }
            throw new ProtocolException("invalid opcode for Arithmetic handler: " + (Object)((Object)cc));
        }
        return new BinaryResponse(command, ms.getStatus());
    }
}

