/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.deps.org.apache.http.impl.io;

import com.couchbase.mock.deps.org.apache.http.HttpResponse;
import com.couchbase.mock.deps.org.apache.http.HttpResponseFactory;
import com.couchbase.mock.deps.org.apache.http.annotation.Contract;
import com.couchbase.mock.deps.org.apache.http.annotation.ThreadingBehavior;
import com.couchbase.mock.deps.org.apache.http.config.MessageConstraints;
import com.couchbase.mock.deps.org.apache.http.impl.DefaultHttpResponseFactory;
import com.couchbase.mock.deps.org.apache.http.impl.io.DefaultHttpResponseParser;
import com.couchbase.mock.deps.org.apache.http.io.HttpMessageParser;
import com.couchbase.mock.deps.org.apache.http.io.HttpMessageParserFactory;
import com.couchbase.mock.deps.org.apache.http.io.SessionInputBuffer;
import com.couchbase.mock.deps.org.apache.http.message.BasicLineParser;
import com.couchbase.mock.deps.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

