/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control.handlers;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.couchbase.mock.control.MockCommand;
import com.couchbase.mock.deps.com.google.gson.JsonElement;
import com.couchbase.mock.deps.com.google.gson.JsonObject;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.protocol.CommandCode;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class OpfailCommandHandler
extends MockCommand {
    @Override
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        ErrorCode eCode = ErrorCode.SUCCESS;
        boolean eCodeFound = false;
        JsonElement eServerList = null;
        if (payload.has("servers")) {
            eServerList = payload.get("servers");
        }
        LinkedList<Integer> serverList = new LinkedList<Integer>();
        if (eServerList != null) {
            for (JsonElement ix : eServerList.getAsJsonArray()) {
                serverList.add(ix.getAsInt());
            }
        }
        int count = payload.get("count").getAsInt();
        short iCode = payload.get("code").getAsShort();
        CommandCode operation = CommandCode.ILLEGAL;
        if (payload.has("operation")) {
            operation = CommandCode.valueOf(payload.get("operation").getAsInt());
        }
        for (ErrorCode rc : ErrorCode.values()) {
            if (iCode != rc.value()) continue;
            eCode = rc;
            eCodeFound = true;
            break;
        }
        if (!eCodeFound) {
            return new CommandStatus().fail("Invalid error code");
        }
        for (Bucket bucket : mock.getBuckets().values()) {
            MemcachedServer[] servers = bucket.getServers();
            for (int ii = 0; ii < servers.length; ++ii) {
                if (serverList.size() > 0 && !serverList.contains(ii)) continue;
                servers[ii].updateFailMakerContext(eCode, count, operation);
            }
        }
        return new CommandStatus();
    }
}

