/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control;

import com.couchbase.mock.deps.com.google.gson.Gson;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class CommandStatus {
    private boolean success = true;
    private String failMsg = null;
    private Throwable t = null;
    private Object payload = new HashMap();
    private Map<String, Object> header = new HashMap<String, Object>();

    public CommandStatus fail() {
        this.success = false;
        return this;
    }

    public CommandStatus fail(String reason) {
        this.success = false;
        this.failMsg = reason;
        return this;
    }

    public CommandStatus fail(Throwable exc) {
        this.success = false;
        this.t = exc;
        return this;
    }

    public void setPayload(Object o) {
        this.payload = o;
    }

    public String toString() {
        this.header.put("payload", this.payload);
        if (this.success) {
            this.header.put("status", "ok");
        } else {
            this.header.put("status", "fail");
        }
        if (this.failMsg != null) {
            this.header.put("error", this.failMsg);
        } else if (this.t != null) {
            StringWriter sw = new StringWriter();
            sw.write("BEGIN CAUGHT EXCEPTION >>>\n");
            this.t.printStackTrace(new PrintWriter(sw));
            sw.write("<<< END CAUGHT EXCEPTION");
            this.header.put("error", sw.toString());
        }
        return new Gson().toJson(this.header);
    }
}

