/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.client;

import com.couchbase.mock.client.AbstractMockClient;
import com.couchbase.mock.client.MockRequest;
import com.couchbase.mock.client.MockResponse;
import com.couchbase.mock.deps.com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public class MockClient
extends AbstractMockClient {
    private final InetSocketAddress listenAddress;
    private final ServerSocket serverSocket;
    private Socket clientSocket = null;
    private BufferedReader reader = null;
    private BufferedWriter writer = null;
    private int restPort = -1;
    private volatile boolean isShutdown = false;

    public MockClient(@NotNull InetSocketAddress address) throws IOException {
        this.serverSocket = new ServerSocket(address.getPort(), 10);
        this.listenAddress = new InetSocketAddress(this.serverSocket.getInetAddress(), this.serverSocket.getLocalPort());
    }

    public InetSocketAddress getListeningAddress() {
        return this.listenAddress;
    }

    public InetSocketAddress getRestAddress() {
        return new InetSocketAddress(this.restPort);
    }

    public int getPort() {
        return this.listenAddress.getPort();
    }

    public int getRestPort() {
        return this.restPort;
    }

    @Override
    public void negotiate() throws IOException {
        char c;
        this.clientSocket = this.serverSocket.accept();
        this.reader = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
        StringBuilder sb = new StringBuilder();
        while ((c = (char)this.reader.read()) != '\u0000') {
            sb.append(c);
        }
        this.restPort = Integer.parseInt(sb.toString());
    }

    private void sendRequest(MockRequest request) throws IOException {
        String encoded = new Gson().toJson(request.getMap());
        this.writer.write(encoded, 0, encoded.length());
        this.writer.write(10);
        this.writer.flush();
    }

    private MockResponse readResponse() throws IOException {
        String respLine = this.reader.readLine();
        return new MockResponse(respLine);
    }

    @Override
    @NotNull
    public MockResponse request(@NotNull MockRequest request) throws IOException {
        this.sendRequest(request);
        return this.readResponse();
    }

    @Override
    public synchronized void shutdown() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (this.clientSocket != null) {
            try {
                this.reader.close();
                this.writer.close();
                this.clientSocket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

