/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.BucketAlreadyExistsException;
import com.couchbase.mock.BucketConfiguration;
import com.couchbase.mock.DocumentLoader;
import com.couchbase.mock.Info;
import com.couchbase.mock.client.RestAPIUtil;
import com.couchbase.mock.control.MockCommandDispatcher;
import com.couchbase.mock.harakiri.HarakiriMonitor;
import com.couchbase.mock.http.Authenticator;
import com.couchbase.mock.http.BucketAdminServer;
import com.couchbase.mock.http.ControlHandler;
import com.couchbase.mock.http.HttpAuthVerifier;
import com.couchbase.mock.http.PingServer;
import com.couchbase.mock.http.PoolsHandler;
import com.couchbase.mock.http.User;
import com.couchbase.mock.http.UserManagementHandler;
import com.couchbase.mock.http.capi.CAPIServer;
import com.couchbase.mock.http.query.QueryServer;
import com.couchbase.mock.httpio.HttpServer;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.util.Getopt;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CouchbaseMock {
    private final Map<String, BucketConfiguration> initialConfigs;
    private final Map<String, Bucket> buckets = new HashMap<String, Bucket>();
    private final HttpServer httpServer;
    private final Authenticator authenticator;
    private final CountDownLatch startupLatch = new CountDownLatch(1);
    private final MockCommandDispatcher controlDispatcher;
    private final PoolsHandler poolsHandler;
    private final UserManagementHandler userManagementHandler;
    private BucketConfiguration defaultConfig = new BucketConfiguration();
    private final Map<String, User> users = new HashMap<String, User>();
    private static boolean cccpBootstrap = false;
    private static boolean debug = false;
    private int port = 8091;
    private HarakiriMonitor harakiriMonitor;

    public boolean isCccpBootstrap() {
        return cccpBootstrap;
    }

    public void startHarakiriMonitor(InetSocketAddress address, boolean terminate) throws IOException {
        if (terminate) {
            this.harakiriMonitor.setTemrinateAction(new Callable(){

                public Object call() throws Exception {
                    System.exit(1);
                    return null;
                }
            });
        }
        boolean connected = false;
        do {
            try {
                this.harakiriMonitor.connect(address.getHostName(), address.getPort());
                connected = true;
            }
            catch (ConnectException ex) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!connected);
        this.harakiriMonitor.start();
    }

    public void startHarakiriMonitor(String host, boolean terminate) throws IOException {
        int idx = host.indexOf(58);
        String h = host.substring(0, idx);
        int p = Integer.parseInt(host.substring(idx + 1));
        this.startHarakiriMonitor(new InetSocketAddress(h, p), terminate);
    }

    public String getPoolName() {
        return "default";
    }

    public Map<String, Bucket> getBuckets() {
        return Collections.unmodifiableMap(this.buckets);
    }

    Map<String, BucketConfiguration> getInitialConfigs() {
        return this.initialConfigs;
    }

    public void clearInitialConfigs() {
        if (!this.buckets.isEmpty()) {
            throw new IllegalStateException("Cannot clear initial configs once they have been started");
        }
        this.initialConfigs.clear();
    }

    public HarakiriMonitor getMonitor() {
        return this.harakiriMonitor;
    }

    public MockCommandDispatcher getDispatcher() {
        return this.controlDispatcher;
    }

    public PoolsHandler getPoolsHandler() {
        return this.poolsHandler;
    }

    public BucketConfiguration getDefaultConfig() {
        return new BucketConfiguration(this.defaultConfig);
    }

    private static List<BucketConfiguration> fromSpecString(String bucketSpec, BucketConfiguration defaultConfig) {
        ArrayList<BucketConfiguration> configs = new ArrayList<BucketConfiguration>();
        if (bucketSpec != null) {
            for (String spec : bucketSpec.split(",")) {
                BucketConfiguration config = new BucketConfiguration(defaultConfig);
                String[] parts = spec.split(":");
                String name = parts[0];
                String pass = "";
                config.name = name;
                if (parts.length > 1) {
                    pass = parts[1];
                    if (parts.length > 2 && parts[2].startsWith("memcache")) {
                        config.type = Bucket.BucketType.MEMCACHED;
                    }
                }
                config.password = pass;
                configs.add(config);
            }
        }
        if (configs.isEmpty()) {
            BucketConfiguration defaultBucket = new BucketConfiguration(defaultConfig);
            defaultBucket.name = "default";
            configs.add(defaultBucket);
        }
        return configs;
    }

    private static BucketConfiguration createDefaultConfig(String hostname, int numNodes, int bucketStartPort, int numVBuckets, int numReplicas) {
        BucketConfiguration defaultConfig = new BucketConfiguration();
        defaultConfig.type = Bucket.BucketType.COUCHBASE;
        defaultConfig.hostname = hostname;
        defaultConfig.numNodes = numNodes;
        if (numReplicas > -1) {
            defaultConfig.numReplicas = numReplicas;
        }
        defaultConfig.bucketStartPort = bucketStartPort;
        defaultConfig.numVBuckets = numVBuckets;
        return defaultConfig;
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int bucketStartPort, int numVBuckets, String bucketSpec, int numReplicas) throws IOException {
        this(port, CouchbaseMock.fromSpecString(bucketSpec, CouchbaseMock.createDefaultConfig(hostname, numNodes, bucketStartPort, numVBuckets, numReplicas)));
        this.defaultConfig = CouchbaseMock.createDefaultConfig(hostname, numNodes, bucketStartPort, numVBuckets, numReplicas);
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int bucketStartPort, int numVBuckets) throws IOException {
        this(hostname, port, numNodes, bucketStartPort, numVBuckets, null, -1);
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int numVBuckets) throws IOException {
        this(hostname, port, numNodes, 0, numVBuckets, null, -1);
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int numVBuckets, String bucketSpec) throws IOException {
        this(hostname, port, numNodes, 0, numVBuckets, bucketSpec, -1);
    }

    public CouchbaseMock(int port, List<BucketConfiguration> configs) throws IOException {
        this.port = port;
        this.authenticator = new Authenticator("Administrator", "password");
        this.controlDispatcher = new MockCommandDispatcher(this);
        this.initialConfigs = new HashMap<String, BucketConfiguration>();
        this.harakiriMonitor = new HarakiriMonitor(this.controlDispatcher);
        this.httpServer = new HttpServer();
        for (BucketConfiguration config : configs) {
            this.initialConfigs.put(config.name, config);
        }
        this.poolsHandler = new PoolsHandler(this);
        this.poolsHandler.register(this.httpServer);
        this.userManagementHandler = new UserManagementHandler(this);
        this.userManagementHandler.register(this.httpServer);
        this.httpServer.register("/mock/*", new ControlHandler(this.controlDispatcher));
        this.httpServer.register("/query*", new QueryServer());
        this.httpServer.register("/admin/ping", new PingServer("{\"status\":\"OK\"}"));
        this.httpServer.register("/", new PingServer("{\"couchdb\":\"Welcome\"}"));
    }

    public void waitForStartup() throws InterruptedException {
        this.startupLatch.await();
    }

    public int getHttpPort() {
        return this.port;
    }

    public int getCarrierPort(String bucketName) {
        Bucket bucket = this.buckets.get(bucketName);
        if (null == bucket) {
            throw new RuntimeException("Bucket does not exist. Has the mock been started?");
        }
        return bucket.getCarrierPort();
    }

    public String getHttpHost() {
        return "127.0.0.1";
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBucket(BucketConfiguration config) throws BucketAlreadyExistsException, IOException {
        if (!config.validate()) {
            throw new IllegalArgumentException("Invalid bucket configuration");
        }
        Map<String, Bucket> map = this.buckets;
        synchronized (map) {
            if (this.buckets.containsKey(config.name)) {
                throw new BucketAlreadyExistsException(config.name);
            }
            Bucket bucket = Bucket.create(this, config);
            BucketAdminServer adminServer = new BucketAdminServer(bucket, this.httpServer, this);
            adminServer.register();
            bucket.setAdminServer(adminServer);
            HttpAuthVerifier verifier = new HttpAuthVerifier(bucket, this.authenticator);
            if (config.type == Bucket.BucketType.COUCHBASE) {
                CAPIServer capi = new CAPIServer(bucket, verifier);
                capi.register(this.httpServer);
                bucket.setCAPIServer(capi);
            }
            this.buckets.put(config.name, bucket);
            bucket.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBucket(String name) throws FileNotFoundException {
        BucketAdminServer adminServer;
        Bucket bucket;
        Map<String, Bucket> map = this.buckets;
        synchronized (map) {
            if (!this.buckets.containsKey(name)) {
                throw new FileNotFoundException("No such bucket: " + name);
            }
            bucket = this.buckets.remove(name);
        }
        CAPIServer capi = bucket.getCAPIServer();
        if (capi != null) {
            capi.shutdown();
        }
        if ((adminServer = bucket.getAdminServer()) != null) {
            adminServer.shutdown();
        }
        bucket.stop();
    }

    private void start(String docsFile, String monitorAddress, boolean useBeerSample) throws IOException {
        try {
            if (this.port == 0) {
                ServerSocketChannel ch = ServerSocketChannel.open();
                ch.socket().bind(new InetSocketAddress(0));
                this.port = ch.socket().getLocalPort();
                if (monitorAddress == null && debug) {
                    System.out.println("port=" + this.port);
                }
                this.httpServer.bind(ch);
            } else {
                this.httpServer.bind(new InetSocketAddress(this.port));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CouchbaseMock.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(-1);
        }
        for (BucketConfiguration config : this.initialConfigs.values()) {
            try {
                this.createBucket(config);
            }
            catch (BucketAlreadyExistsException ex) {
                throw new IOException(ex);
            }
        }
        this.httpServer.start();
        if (docsFile != null) {
            DocumentLoader loader = new DocumentLoader(this, "default");
            loader.loadDocuments(docsFile);
        } else if (useBeerSample) {
            RestAPIUtil.loadBeerSample(this);
        }
        if (monitorAddress != null) {
            this.startHarakiriMonitor(monitorAddress, true);
        } else if (debug) {
            StringBuilder wireshark = new StringBuilder("couchbase && (");
            System.out.println("\nConnection strings:");
            for (Bucket bucket : this.getBuckets().values()) {
                System.out.println("couchbase://127.0.0.1:" + this.port + "=http/" + bucket.getName());
                StringBuilder connstr = new StringBuilder("couchbase://");
                for (MemcachedServer server : bucket.getServers()) {
                    connstr.append(server.getHostname()).append(":").append(server.getPort()).append("=mcd,");
                    wireshark.append("tcp.port == ").append(server.getPort()).append(" || ");
                }
                connstr.replace(connstr.length() - 1, connstr.length(), "");
                connstr.append("/").append(bucket.getName());
                System.out.println(connstr);
            }
            wireshark.replace(wireshark.length() - 4, wireshark.length(), "");
            wireshark.append(")");
            System.out.println("\nWireshark filters:");
            System.out.println("http && tcp.port == " + this.port);
            System.out.println(wireshark);
        }
        this.startupLatch.countDown();
    }

    public void start() throws IOException {
        this.start(null, null, false);
    }

    public void stop() {
        this.httpServer.stopServer();
        for (Bucket bucket : this.buckets.values()) {
            bucket.stop();
        }
    }

    private static void printVersion() {
        System.out.println(Info.getFullVersion());
    }

    private static void printHelp() {
        PrintStream o = System.out;
        BucketConfiguration defaultConfig = new BucketConfiguration();
        o.printf("%s%n%n", Info.getFullVersion());
        o.printf("Options are:%n", new Object[0]);
        o.printf("-h --host             The hostname for the REST port. Default=8091%n", new Object[0]);
        o.printf("-b --buckets          (See description below%n", new Object[0]);
        o.printf("-n --nodes            The number of nodes each bucket should contain. Default=%d%n", defaultConfig.numNodes);
        o.printf("-v --vbuckets         The number of vbuckets each bucket should contain. Default=%d%n", defaultConfig.numVBuckets);
        o.printf("-R --replicas         The number of replica nodes for each bucket. Default=%d%n", defaultConfig.numReplicas);
        o.printf("   --harakiri-monitor The host:port on which the control socket should connect to%n", new Object[0]);
        o.printf("-p --port             The REST port to listen on. If 0, port will be sent via --harakiri-monitor%n", new Object[0]);
        o.printf("-S --with-beer-sample Initialize the cluster with the `beer-sample` bucket active%n", new Object[0]);
        o.printf("-D --docs             Specify a ZIP file that should contain documents to be loaded%n", new Object[0]);
        o.printf("                      into the `default` bucket%n", new Object[0]);
        o.printf("-E --empty            Initialize a blank cluster without any buckets. Buckets may then%n", new Object[0]);
        o.printf("                      be later added via the REST API%n", new Object[0]);
        o.printf("-c --cccp             Enable Carrier Publication bootstrap protocol by default%n", new Object[0]);
        o.printf("-d --debug            Enable debug mode%n", new Object[0]);
        o.printf("%n", new Object[0]);
        o.printf("=== -- bucket option ===%n", new Object[0]);
        o.printf("Buckets descriptions is a comma-separated list of {name}:{password}:{bucket type} pairs.%n", new Object[0]);
        o.printf("To allow unauthorized connections, omit password.%n", new Object[0]);
        o.printf("Third parameter could be either 'memcache' or 'couchbase' (default value is 'couchbase'). E.g.%n", new Object[0]);
        o.printf("    default:,test:,protected:secret,cache::memcache%n", new Object[0]);
        o.printf("The default is equivalent to `couchbase::`%n", new Object[0]);
    }

    public static void main(String[] args) {
        BucketConfiguration defaultConfig = new BucketConfiguration();
        int port = 8091;
        int nodes = defaultConfig.numNodes;
        int vbuckets = defaultConfig.numVBuckets;
        int replicaCount = defaultConfig.numReplicas;
        String harakiriMonitorAddress = null;
        String hostname = null;
        String bucketsSpec = null;
        String docsFile = null;
        boolean useBeerSample = false;
        boolean emptyCluster = false;
        Getopt getopt = new Getopt();
        getopt.addOption(new Getopt.CommandLineOption('h', "--host", true)).addOption(new Getopt.CommandLineOption('b', "--buckets", true)).addOption(new Getopt.CommandLineOption('p', "--port", true)).addOption(new Getopt.CommandLineOption('n', "--nodes", true)).addOption(new Getopt.CommandLineOption('v', "--vbuckets", true)).addOption(new Getopt.CommandLineOption('\u0000', "--harakiri-monitor", true)).addOption(new Getopt.CommandLineOption('R', "--replicas", true)).addOption(new Getopt.CommandLineOption('D', "--docs", true)).addOption(new Getopt.CommandLineOption('S', "--with-beer-sample", false)).addOption(new Getopt.CommandLineOption('E', "--empty", false)).addOption(new Getopt.CommandLineOption('c', "--cccp", false)).addOption(new Getopt.CommandLineOption('d', "--debug", false)).addOption(new Getopt.CommandLineOption('\u0000', "--version", false)).addOption(new Getopt.CommandLineOption('?', "--help", false));
        List<Getopt.Entry> options = getopt.parse(args);
        for (Getopt.Entry e : options) {
            if (e.key.equals("-h") || e.key.equals("--host")) {
                hostname = e.value;
                continue;
            }
            if (e.key.equals("-b") || e.key.equals("--buckets")) {
                bucketsSpec = e.value;
                continue;
            }
            if (e.key.equals("-p") || e.key.equals("--port")) {
                port = Integer.parseInt(e.value);
                continue;
            }
            if (e.key.equals("-n") || e.key.equals("--nodes")) {
                nodes = Integer.parseInt(e.value);
                continue;
            }
            if (e.key.equals("-v") || e.key.equals("--vbuckets")) {
                vbuckets = Integer.parseInt(e.value);
                continue;
            }
            if (e.key.equals("-R") || e.key.equals("--replicas")) {
                replicaCount = Integer.parseInt(e.value);
                continue;
            }
            if (e.key.equals("-D") || e.key.equals("--docs")) {
                docsFile = e.value;
                continue;
            }
            if (e.key.equals("-S") || e.key.equals("--with-beer-sample")) {
                useBeerSample = true;
                continue;
            }
            if (e.key.equals("-E") || e.key.equals("--empty")) {
                emptyCluster = true;
                continue;
            }
            if (e.key.equals("-c") || e.key.equals("--cccp")) {
                cccpBootstrap = true;
                continue;
            }
            if (e.key.equals("-d") || e.key.equals("--debug")) {
                debug = true;
                continue;
            }
            if (e.key.equals("--harakiri-monitor")) {
                int idx = e.value.indexOf(58);
                if (idx == -1) {
                    System.err.println("ERROR: --harakiri-monitor requires host:port");
                }
                harakiriMonitorAddress = e.value;
                continue;
            }
            if (e.key.equals("-?") || e.key.equals("--help")) {
                CouchbaseMock.printHelp();
                System.exit(0);
                continue;
            }
            if (!e.key.equals("--version")) continue;
            CouchbaseMock.printVersion();
            System.exit(0);
        }
        try {
            CouchbaseMock mock = new CouchbaseMock(hostname, port, nodes, 0, vbuckets, bucketsSpec, replicaCount);
            if (emptyCluster) {
                mock.clearInitialConfigs();
            }
            mock.start(docsFile, harakiriMonitorAddress, useBeerSample);
        }
        catch (Exception e) {
            Logger.getLogger(CouchbaseMock.class.getName()).log(Level.SEVERE, "Could not create cluster: ", e);
            System.exit(1);
        }
    }

    public Map<String, User> getUsers() {
        return this.users;
    }
}

