/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.views;

import com.couchbase.mock.JsonUtils;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.views.Configuration;
import com.couchbase.mock.views.Indexer;
import com.couchbase.mock.views.JavascriptRun;
import com.couchbase.mock.views.QueryExecutionException;
import com.couchbase.mock.views.QueryResult;
import com.couchbase.mock.views.Reducer;
import javax.script.ScriptException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJSON;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class View {
    private final String name;
    private final String mapSource;
    private final String reduceSource;
    private final Indexer indexer;
    private final Reducer reducer;
    private final JavascriptRun jsRun;

    public View(String name, String map) throws ScriptException {
        this(name, map, null);
    }

    public View(@NotNull String name, @NotNull String map, @Nullable String reduce) throws ScriptException {
        if (name == null) {
            View.$$$reportNull$$$0(0);
        }
        if (map == null) {
            View.$$$reportNull$$$0(1);
        }
        this.name = name;
        this.mapSource = map;
        this.reduceSource = reduce;
        this.jsRun = new JavascriptRun();
        this.indexer = Indexer.create(map);
        this.reducer = reduce != null ? Reducer.create(reduce) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getMapSource() {
        return this.mapSource;
    }

    public String getReduceSource() {
        return this.reduceSource;
    }

    public QueryResult execute(Iterable<Item> items) throws QueryExecutionException {
        return this.execute(items, null);
    }

    public QueryResult execute(Iterable<Item> items, Configuration config) throws QueryExecutionException {
        return new QueryResult(JsonUtils.decodeAsMap(this.executeRaw(items, config)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeRaw(Iterable<Item> items, Configuration config) throws QueryExecutionException {
        if (config == null) {
            config = new Configuration();
        }
        Context cx = Context.enter();
        ScriptableObject scope = cx.initStandardObjects();
        NativeObject configObject = config.toNativeObject();
        Function redFunc = null;
        if (this.reducer != null) {
            redFunc = this.reducer.getFunction();
        }
        try {
            NativeObject resultObject;
            this.indexer.run(items, cx);
            Scriptable indexResults = this.indexer.getLastResults();
            try {
                resultObject = this.jsRun.execute(configObject, indexResults, redFunc, cx);
            }
            catch (JavaScriptException ex) {
                Object thrownObject = ex.getValue();
                try {
                    String jsonException = (String)NativeJSON.stringify(cx, scope, thrownObject, null, null);
                    throw new QueryExecutionException(jsonException);
                }
                catch (EcmaError ex2) {
                    throw new QueryExecutionException(ex2.getErrorMessage());
                }
            }
            catch (EcmaError parseErr) {
                throw new QueryExecutionException(parseErr.getErrorMessage());
            }
            NativeArray rows = (NativeArray)resultObject.get("rows", (Scriptable)resultObject);
            resultObject.delete("rows");
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Object id : resultObject.getAllIds()) {
                if (!(id instanceof String)) {
                    throw new RuntimeException("ARGH: " + id);
                }
                sb.append('\"').append(id).append("\":");
                sb.append((String)NativeJSON.stringify(cx, scope, resultObject.get((String)id, (Scriptable)resultObject), null, null));
                sb.append(",");
            }
            sb.append("\"rows\":[\n");
            for (int i = 0; i < rows.size(); ++i) {
                Object o = rows.get(i, (Scriptable)rows);
                sb.append((String)NativeJSON.stringify(cx, scope, o, null, null));
                if (i < rows.size() - 1) {
                    sb.append(",");
                }
                sb.append("\n");
            }
            sb.append("]\n");
            sb.append("}\n");
            String string = sb.toString();
            return string;
        }
        finally {
            Context.exit();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "map";
                break;
            }
        }
        objectArray[1] = "com/couchbase/mock/views/View";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

