/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.subdoc;

import com.couchbase.mock.subdoc.PathParseException;

class Component {
    private final String value;
    private final int numval;
    private static final int STRING_VALUE = -2;

    Component(String input, boolean isIndex) throws PathParseException {
        if (input == null || input.isEmpty()) {
            throw new PathParseException("Component cannot be empty");
        }
        this.value = input;
        if (isIndex) {
            try {
                this.numval = Integer.parseInt(input);
            }
            catch (NumberFormatException e) {
                throw new PathParseException(e);
            }
            if (this.numval < -1) {
                throw new PathParseException("Negative path other than -1 not allowed");
            }
        } else {
            this.numval = -2;
        }
    }

    Component() {
        this.value = null;
        this.numval = -2;
    }

    int getIndex() {
        return this.numval;
    }

    String getString() {
        return this.value;
    }

    boolean isIndex() {
        return this.numval != -2;
    }
}

