/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.CompressionMode;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.Datatype;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import org.iq80.snappy.Snappy;

public class BinaryStoreCommand
extends BinaryCommand {
    public BinaryStoreCommand(ByteBuffer header) throws ProtocolException {
        super(header);
    }

    public Item getItem(CompressionMode snappyMode) throws ProtocolException {
        int flags = 0;
        int expiryTime = 0;
        if (this.extraLength == 8) {
            flags = this.bodyBuffer.getInt(0);
            expiryTime = this.bodyBuffer.getInt(4);
        }
        byte[] value = this.getValue();
        byte datatype = this.datatype;
        if ((datatype & Datatype.SNAPPY.value()) > 0) {
            if (snappyMode == CompressionMode.DISABLED) {
                throw new ProtocolException("Cannot handle compressed data");
            }
            if (snappyMode == CompressionMode.OFF) {
                datatype = (byte)(datatype & ~Datatype.SNAPPY.value());
            }
            value = Snappy.uncompress(value, 0, value.length);
        }
        return new Item(this.getKeySpec(), flags, expiryTime, value, null, this.cas, datatype);
    }
}

