/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.Info;
import com.couchbase.mock.memcached.BasicVBucketCoordinates;
import com.couchbase.mock.memcached.CoordKey;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.KeySpec;
import com.couchbase.mock.memcached.MutationStatus;
import com.couchbase.mock.memcached.StorageVBucketCoordinates;
import com.couchbase.mock.memcached.VBucketCoordinates;
import com.couchbase.mock.memcached.VBucketInfo;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class VBucketStore {
    private volatile long casCounter;
    private static final long THIRTY_DAYS = 2592000L;
    static final int DEFAULT_EXPIRY_TIME = 15;
    static final int MAXIMUM_EXPIRY_TIME = 29;
    private final Map<KeySpec, Item> kv = new ConcurrentHashMap<KeySpec, Item>();
    private final StorageVBucketCoordinates[] vbCoords;
    private final Map<CoordKey, VBucketCoordinates> allCoords = new HashMap<CoordKey, VBucketCoordinates>();
    public ItemAction onItemDelete;
    public ItemAction onItemMutated;

    public VBucketStore(VBucketInfo[] vbi) {
        this.vbCoords = new StorageVBucketCoordinates[vbi.length];
        this.setCurrentCoords(vbi);
    }

    private void logCoords(int vbid, VBucketCoordinates coords) {
        CoordKey key = new CoordKey(vbid, coords.getUuid());
        this.allCoords.put(key, coords);
    }

    public VBucketCoordinates findCoords(int vbid, long uuid) {
        return this.allCoords.get(new CoordKey(vbid, uuid));
    }

    private void setCurrentCoords(VBucketInfo[] vbi) {
        for (int i = 0; i < vbi.length; ++i) {
            StorageVBucketCoordinates curCoords;
            this.vbCoords[i] = curCoords = new StorageVBucketCoordinates(vbi[i].getUuid());
            this.logCoords(i, curCoords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCoords(VBucketInfo[] vbi) {
        for (int i = 0; i < this.vbCoords.length; ++i) {
            this.logCoords(i, this.vbCoords[i]);
        }
        StorageVBucketCoordinates[] storageVBucketCoordinatesArray = this.vbCoords;
        synchronized (this.vbCoords) {
            this.setCurrentCoords(vbi);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public VBucketCoordinates getCurrentCoords(int vbid) {
        return this.vbCoords[vbid];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationStatus incrCoords(KeySpec ks) {
        StorageVBucketCoordinates[] storageVBucketCoordinatesArray = this.vbCoords;
        synchronized (this.vbCoords) {
            StorageVBucketCoordinates curCoord = this.vbCoords[ks.vbId];
            // ** MonitorExit[var3_2] (shouldn't be in output)
            long seq = curCoord.incrSeqno();
            long uuid = curCoord.getUuid();
            BasicVBucketCoordinates coord = new BasicVBucketCoordinates(uuid, seq);
            return new MutationStatus(coord);
        }
    }

    private Item lookup(KeySpec ks) {
        Item ii = this.kv.get(ks);
        if (ii == null) {
            return null;
        }
        long now = new Date().getTime() + Info.getClockOffset() * 1000L;
        if (ii.getExpiryTime() == 0 || now < ii.getExpiryTimeInMillis()) {
            return ii;
        }
        MutationStatus ms = this.incrCoords(ii.getKeySpec());
        this.onItemDelete.onAction(this, ii, ms.getCoords());
        this.kv.remove(ks);
        return null;
    }

    public ErrorCode lock(Item item, int expiry) {
        if (item.isLocked()) {
            return ErrorCode.ETMPFAIL;
        }
        if (expiry == 0 || expiry > 29) {
            expiry = 15;
        }
        MutationStatus ms = this.incrCoords(item.getKeySpec());
        item.setLockExpiryTime(expiry);
        item.setCas(++this.casCounter);
        this.onItemMutated.onAction(this, item, ms.getCoords());
        return ErrorCode.SUCCESS;
    }

    public ErrorCode touch(Item item, int expiry, boolean xerrorEnabled) {
        if (item.isLocked()) {
            return this.lockedError(xerrorEnabled);
        }
        item.setExpiryTime(expiry);
        MutationStatus ms = this.incrCoords(item.getKeySpec());
        this.onItemMutated.onAction(this, item, ms.getCoords());
        return ErrorCode.SUCCESS;
    }

    public MutationStatus add(Item item, boolean xerrorEnabled) {
        Item old = this.lookup(item.getKeySpec());
        if (old != null && old.isLocked()) {
            return new MutationStatus(this.lockedError(xerrorEnabled));
        }
        if (old != null || item.getCas() != 0L) {
            return new MutationStatus(ErrorCode.KEY_EEXISTS);
        }
        item.setCas(++this.casCounter);
        this.kv.put(item.getKeySpec(), item);
        MutationStatus ms = this.incrCoords(item.getKeySpec());
        this.onItemMutated.onAction(this, item, ms.getCoords());
        return ms;
    }

    public MutationStatus replace(Item item, boolean xerrorEnabled) {
        Item old = this.lookup(item.getKeySpec());
        if (old == null) {
            return new MutationStatus(ErrorCode.KEY_ENOENT);
        }
        if (!old.ensureUnlocked(item.getCas())) {
            return new MutationStatus(this.lockedError(xerrorEnabled));
        }
        if (item.getCas() != old.getCas() && item.getCas() != 0L) {
            return new MutationStatus(ErrorCode.KEY_EEXISTS);
        }
        MutationStatus ms = this.incrCoords(item.getKeySpec());
        item.setCas(++this.casCounter);
        this.kv.put(item.getKeySpec(), item);
        this.onItemMutated.onAction(this, item, ms.getCoords());
        return ms;
    }

    public MutationStatus set(Item item, boolean xerrorEnabled) {
        if (item.getCas() == 0L) {
            Item old = this.lookup(item.getKeySpec());
            if (old != null && old.isLocked()) {
                return new MutationStatus(this.lockedError(xerrorEnabled));
            }
            MutationStatus ms = this.incrCoords(item.getKeySpec());
            item.setCas(++this.casCounter);
            this.kv.put(item.getKeySpec(), item);
            this.onItemMutated.onAction(this, item, ms.getCoords());
            return ms;
        }
        return this.replace(item, xerrorEnabled);
    }

    public MutationStatus delete(KeySpec ks, long cas, boolean xerrorEnabled) {
        Item i = this.lookup(ks);
        if (i == null) {
            return new MutationStatus(ErrorCode.KEY_ENOENT);
        }
        if (!i.ensureUnlocked(cas)) {
            return new MutationStatus(this.lockedError(xerrorEnabled));
        }
        if (cas == 0L || cas == i.getCas()) {
            MutationStatus ms = this.incrCoords(i.getKeySpec());
            this.kv.remove(ks);
            this.onItemDelete.onAction(this, i, ms.getCoords());
            return ms;
        }
        return new MutationStatus(ErrorCode.KEY_EEXISTS);
    }

    private MutationStatus modifyItemValue(Item i, boolean isAppend, boolean xerrorEnabled) {
        Item old = this.lookup(i.getKeySpec());
        if (old == null) {
            return new MutationStatus(ErrorCode.KEY_ENOENT);
        }
        if (!old.ensureUnlocked(i.getCas())) {
            return new MutationStatus(this.lockedError(xerrorEnabled));
        }
        if (isAppend) {
            old.append(i);
        } else {
            old.prepend(i);
        }
        MutationStatus ms = this.incrCoords(old.getKeySpec());
        old.setCas(++this.casCounter);
        this.onItemMutated.onAction(this, old, ms.getCoords());
        return ms;
    }

    public MutationStatus append(Item i, boolean xerrorEnabled) {
        return this.modifyItemValue(i, true, xerrorEnabled);
    }

    public MutationStatus prepend(Item i, boolean xerrorEnabled) {
        return this.modifyItemValue(i, false, xerrorEnabled);
    }

    public Item get(KeySpec ks) {
        return this.lookup(ks);
    }

    public Item getRandom() {
        Random r = new Random();
        while (!this.kv.isEmpty()) {
            Item itm;
            Collection<Item> c = this.kv.values();
            int max = r.nextInt(c.size());
            Iterator<Item> iter = c.iterator();
            for (int i = 0; i < max - 1 && iter.hasNext(); ++i) {
                iter.next();
            }
            if (!iter.hasNext() || (itm = this.lookup(iter.next().getKeySpec())) == null) continue;
            return itm;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceMutation(int vbid, Item itm, VBucketCoordinates coords, boolean isDelete) {
        StorageVBucketCoordinates[] storageVBucketCoordinatesArray = this.vbCoords;
        synchronized (this.vbCoords) {
            StorageVBucketCoordinates cur = this.vbCoords[vbid];
            if (cur.getUuid() != coords.getUuid()) {
                cur = this.vbCoords[vbid] = new StorageVBucketCoordinates(coords);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            cur.seekSeqno(coords.getSeqno());
            if (isDelete) {
                this.kv.remove(itm.getKeySpec());
                this.onItemDelete.onAction(this, itm, coords);
            } else {
                this.kv.put(itm.getKeySpec(), itm);
                this.onItemMutated.onAction(this, itm, coords);
            }
            return;
        }
    }

    void forceStorageMutation(Item itm, VBucketCoordinates coords) {
        this.forceMutation(itm.getKeySpec().vbId, itm, coords, false);
    }

    void forceDeleteMutation(Item itm, VBucketCoordinates coords) {
        this.forceMutation(itm.getKeySpec().vbId, itm, coords, true);
    }

    public Map<KeySpec, Item> getMap() {
        return this.kv;
    }

    public static int convertExpiryTime(int original) {
        if (original == 0) {
            return original;
        }
        if ((long)original > 2592000L) {
            return original + (int)Info.getClockOffset();
        }
        return (int)(new Date().getTime() / 1000L + (long)original + Info.getClockOffset());
    }

    private ErrorCode lockedError(boolean xerrorEnabled) {
        return xerrorEnabled ? ErrorCode.LOCKED : ErrorCode.KEY_EEXISTS;
    }

    public static interface ItemAction {
        public void onAction(VBucketStore var1, Item var2, VBucketCoordinates var3);
    }
}

