/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.memcached.BasicVBucketCoordinates;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.KeySpec;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.VBucketCoordinates;
import com.couchbase.mock.memcached.VBucketInfo;
import com.couchbase.mock.memcached.VBucketStore;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Storage {
    private final VBucketInfo[] vbInfo;
    private final VBucketStore cacheStore;
    private final PersistentStorage persistStore;
    private final MemcachedServer server;
    private boolean persistEnabled = true;
    private boolean replicationEnabled = true;
    private static final VBucketCoordinates EMPTY_COORDS = new BasicVBucketCoordinates(0L, 0L);

    public Storage(VBucketInfo[] vbi, MemcachedServer server) {
        this.vbInfo = vbi;
        DeleteActionCallback deleteCallback = new DeleteActionCallback(this);
        MutateActionCallback mutateCallback = new MutateActionCallback(this);
        this.cacheStore = new VBucketStore(vbi);
        this.persistStore = new PersistentStorage(vbi.length);
        this.cacheStore.onItemDelete = deleteCallback;
        this.cacheStore.onItemMutated = mutateCallback;
        this.server = server;
    }

    public void persistDeletedItem(KeySpec ks, VBucketCoordinates coords) {
        this.persistStore.remove(ks, coords);
    }

    public void persistMutatedItem(Item itm, VBucketCoordinates coords) {
        this.persistStore.put(new Item(itm), coords);
    }

    private void replicateMutatedItem(Item itm, VBucketCoordinates coords) {
        VBucketInfo vbi = this.vbInfo[itm.getKeySpec().vbId];
        if (vbi.getOwner() != this.server) {
            return;
        }
        for (MemcachedServer replica : vbi.getReplicas()) {
            Item newItem = new Item(itm);
            VBucketStore rStore = replica.getStorage().cacheStore;
            rStore.forceStorageMutation(newItem, coords);
        }
    }

    private void replicateDeletedItem(KeySpec ks, VBucketCoordinates coords) {
        VBucketInfo vbi = this.vbInfo[ks.vbId];
        if (vbi.getOwner() != this.server) {
            return;
        }
        Item itm = new Item(ks);
        for (MemcachedServer replica : vbi.getReplicas()) {
            VBucketStore rStore = replica.getStorage().cacheStore;
            PersistentStorage pStore = replica.getStorage().persistStore;
            rStore.forceDeleteMutation(itm, coords);
            pStore.put(itm, coords);
        }
    }

    public Item getCached(KeySpec ks) {
        return this.cacheStore.get(ks);
    }

    public Item getPersisted(KeySpec ks) {
        return this.persistStore.get(ks);
    }

    public void putCached(Item itm) {
        this.cacheStore.getMap().put(itm.getKeySpec(), itm);
    }

    public void putPersisted(Item itm) {
        this.persistStore.put(itm, EMPTY_COORDS);
    }

    public void removeCached(KeySpec ks) {
        this.cacheStore.getMap().remove(ks);
    }

    public void removePersisted(KeySpec ks) {
        this.persistStore.remove(ks, EMPTY_COORDS);
    }

    public VBucketInfo getVBucketInfo(short vb) {
        if (vb < 0 || vb > this.vbInfo.length) {
            throw new AccessControlException("Invalid vBucket");
        }
        return this.vbInfo[vb];
    }

    private void verifyOwnership(MemcachedServer server, short vBucketId) {
        if (server != null && server.getBucket().getType() == Bucket.BucketType.MEMCACHED) {
            return;
        }
        if (vBucketId < 0 || vBucketId > this.vbInfo.length) {
            throw new AccessControlException("Invalid vBucket");
        }
        VBucketInfo vbi = this.vbInfo[vBucketId];
        if (server != null && vbi.getOwner() != server) {
            throw new AccessControlException("Server is not master for this vb");
        }
    }

    public VBucketStore getCache(MemcachedServer server, short vBucketId) {
        this.verifyOwnership(server, vBucketId);
        return this.cacheStore;
    }

    public VBucketStore getCache(short vBucketId) {
        this.verifyOwnership(null, vBucketId);
        return this.cacheStore;
    }

    public Item getRandomItem() {
        return this.cacheStore.getRandom();
    }

    public long getPersistedSeqno(short vBucketId) {
        return this.persistStore.getCoords(vBucketId).getSeqno();
    }

    public Iterable<Item> getMasterStore(StorageType type) {
        ArrayList<Item> validItems = new ArrayList<Item>();
        Collection<Item> inputs = type == StorageType.CACHE ? this.cacheStore.getMap().values() : this.persistStore.values();
        for (Item itm : inputs) {
            short vbId = itm.getKeySpec().vbId;
            MemcachedServer owner = this.vbInfo[vbId].getOwner();
            if (owner != this.server) continue;
            validItems.add(itm);
        }
        return validItems;
    }

    public void flush() {
        this.cacheStore.getMap().clear();
        this.persistStore.clear();
    }

    public void updateCoordinateInfo(VBucketInfo[] vbi) {
        this.cacheStore.updateCoords(vbi);
        for (int i = 0; i < vbi.length; ++i) {
            this.persistStore.updateSingleCoords(i, this.cacheStore.getCurrentCoords(i));
        }
    }

    private class MutateActionCallback
    implements VBucketStore.ItemAction {
        private final Storage storage;

        public MutateActionCallback(Storage storage2) {
            this.storage = storage2;
        }

        @Override
        public void onAction(VBucketStore cacheStore, Item itm, VBucketCoordinates coords) {
            if (this.storage.persistEnabled) {
                this.storage.persistMutatedItem(itm, coords);
            }
            if (this.storage.replicationEnabled) {
                this.storage.replicateMutatedItem(itm, coords);
            }
        }
    }

    private class DeleteActionCallback
    implements VBucketStore.ItemAction {
        private final Storage storage;

        public DeleteActionCallback(Storage storage2) {
            this.storage = storage2;
        }

        @Override
        public void onAction(VBucketStore cacheStore, Item itm, VBucketCoordinates coords) {
            if (this.storage.persistEnabled) {
                this.storage.persistDeletedItem(itm.getKeySpec(), coords);
            }
            if (this.storage.replicationEnabled) {
                this.storage.replicateDeletedItem(itm.getKeySpec(), coords);
            }
        }
    }

    private class PersistentStorage {
        final Slot[] slots;

        PersistentStorage(int nvb) {
            this.slots = new Slot[nvb];
        }

        private Slot updateCommon(KeySpec ks, VBucketCoordinates coords) {
            Slot slot = this.slots[ks.vbId];
            if (slot == null) {
                slot = this.slots[ks.vbId] = new Slot();
            }
            if (coords.getUuid() != 0L && coords.getSeqno() != 0L) {
                slot.uuid = coords.getUuid();
                slot.seqno = coords.getSeqno();
            }
            return slot;
        }

        public void put(Item item, VBucketCoordinates coords) {
            this.updateCommon((KeySpec)item.getKeySpec(), (VBucketCoordinates)coords).mm.put(item.getKeySpec(), item);
        }

        public Item get(KeySpec ks) {
            Slot ss = this.slots[ks.vbId];
            if (ss != null) {
                return ss.mm.get(ks);
            }
            return null;
        }

        public Collection<Item> values() {
            ArrayList<Item> ret = new ArrayList<Item>();
            for (Slot s : this.slots) {
                if (s == null) continue;
                ret.addAll(s.mm.values());
            }
            return ret;
        }

        public void clear() {
            for (Slot s : this.slots) {
                if (s == null) continue;
                s.mm.clear();
            }
        }

        public void remove(KeySpec ks, VBucketCoordinates coords) {
            this.updateCommon((KeySpec)ks, (VBucketCoordinates)coords).mm.remove(ks);
        }

        VBucketCoordinates getCoords(int vbid) {
            Slot ss = this.slots[vbid];
            long seqno = 0L;
            long uuid = 0L;
            if (ss != null) {
                seqno = ss.seqno;
                uuid = ss.uuid;
            }
            return new BasicVBucketCoordinates(uuid, seqno);
        }

        public void updateSingleCoords(int vbid, VBucketCoordinates coords) {
            Slot s = this.slots[vbid];
            if (s != null) {
                s.uuid = coords.getUuid();
                s.seqno = coords.getSeqno();
            }
        }

        class Slot {
            long uuid = 0L;
            long seqno = 0L;
            Map<KeySpec, Item> mm = new HashMap<KeySpec, Item>();

            Slot() {
            }
        }
    }

    public static enum StorageType {
        CACHE,
        DISK;

    }
}

