/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.Info;
import com.couchbase.mock.memcached.AppendPrependCommandExecutor;
import com.couchbase.mock.memcached.ArithmeticCommandExecutor;
import com.couchbase.mock.memcached.BinaryProtocolHandler;
import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.CompressionMode;
import com.couchbase.mock.memcached.ConfigCommandExecutor;
import com.couchbase.mock.memcached.DeleteCommandExecutor;
import com.couchbase.mock.memcached.EvictCommandExecutor;
import com.couchbase.mock.memcached.FlushCommandExecutor;
import com.couchbase.mock.memcached.GetCommandExecutor;
import com.couchbase.mock.memcached.GetErrmapCommandExecutor;
import com.couchbase.mock.memcached.GetRandomCommandExecutor;
import com.couchbase.mock.memcached.HelloCommandExecutor;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.NoopCommandExecutor;
import com.couchbase.mock.memcached.ObserveCommandExecutor;
import com.couchbase.mock.memcached.ObserveSeqnoCommandExecutor;
import com.couchbase.mock.memcached.OutputContext;
import com.couchbase.mock.memcached.QuitCommandExecutor;
import com.couchbase.mock.memcached.SaslCommandExecutor;
import com.couchbase.mock.memcached.SelectBucketCommandExecutor;
import com.couchbase.mock.memcached.StatCommandExecutor;
import com.couchbase.mock.memcached.Storage;
import com.couchbase.mock.memcached.StoreCommandExecutor;
import com.couchbase.mock.memcached.SubdocCommandExecutor;
import com.couchbase.mock.memcached.SubdocMultiCommandExecutor;
import com.couchbase.mock.memcached.UnknownCommandExecutor;
import com.couchbase.mock.memcached.UnlockCommandExecutor;
import com.couchbase.mock.memcached.VBucketInfo;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.VerbosityCommandExecutor;
import com.couchbase.mock.memcached.VersionCommandExecutor;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryConfigResponse;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.CommandCode;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemcachedServer
extends Thread
implements BinaryProtocolHandler {
    private final Storage storage;
    private final long bootTime;
    private final String hostname;
    private final ServerSocketChannel server;
    private Selector selector;
    private final int port;
    private final CommandExecutor[] executors = new CommandExecutor[255];
    private static final CommandExecutor unknownHandler = new UnknownCommandExecutor();
    private final Bucket bucket;
    private boolean active = true;
    private int hiccupTime = 0;
    private int hiccupOffset = 0;
    private int truncateLimit = 0;
    private boolean cccpEnabled = false;
    private final List<CommandLogEntry> commandLog = new ArrayList<CommandLogEntry>();
    private boolean shouldLogCommands = false;
    private boolean enhancedErrorsEnabled = false;
    private CompressionMode compression = CompressionMode.DISABLED;
    private List<String> saslMechanisms;
    private FailMaker failmaker = new FailMaker();

    public void setEnhancedErrorsEnabled(boolean enhancedErrorsEnabled) {
        this.enhancedErrorsEnabled = enhancedErrorsEnabled;
    }

    public boolean isEnhancedErrorsEnabled() {
        return this.enhancedErrorsEnabled;
    }

    public void setCompression(CompressionMode compression) {
        this.compression = compression;
    }

    public CompressionMode getCompression() {
        return this.compression;
    }

    public void setSaslMechanisms(List<String> saslMechanisms) {
        this.saslMechanisms = saslMechanisms;
    }

    public List<String> getSaslMechanisms() {
        return this.saslMechanisms;
    }

    public boolean supportsSaslMechanism(String mechanism) {
        return this.saslMechanisms.indexOf(mechanism) >= 0;
    }

    public MemcachedServer(Bucket bucket, String hostname, int port, VBucketInfo[] vbi, boolean cccpEnabled) throws IOException {
        this.bucket = bucket;
        this.storage = new Storage(vbi, this);
        this.cccpEnabled = cccpEnabled;
        this.saslMechanisms = new ArrayList<String>();
        this.saslMechanisms.add("PLAIN");
        for (int ii = 0; ii < this.executors.length; ++ii) {
            this.executors[ii] = unknownHandler;
        }
        this.executors[CommandCode.QUIT.cc()] = new QuitCommandExecutor();
        this.executors[CommandCode.QUITQ.cc()] = new QuitCommandExecutor();
        this.executors[CommandCode.FLUSH.cc()] = new FlushCommandExecutor();
        this.executors[CommandCode.FLUSHQ.cc()] = new FlushCommandExecutor();
        this.executors[CommandCode.NOOP.cc()] = new NoopCommandExecutor();
        this.executors[CommandCode.VERSION.cc()] = new VersionCommandExecutor();
        this.executors[CommandCode.STAT.cc()] = new StatCommandExecutor();
        this.executors[CommandCode.VERBOSITY.cc()] = new VerbosityCommandExecutor();
        this.executors[CommandCode.ADD.cc()] = new StoreCommandExecutor();
        this.executors[CommandCode.ADDQ.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.APPEND.cc()] = new AppendPrependCommandExecutor();
        this.executors[CommandCode.APPENDQ.cc()] = new AppendPrependCommandExecutor();
        this.executors[CommandCode.PREPEND.cc()] = new AppendPrependCommandExecutor();
        this.executors[CommandCode.PREPENDQ.cc()] = new AppendPrependCommandExecutor();
        this.executors[CommandCode.SET.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.SETQ.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.REPLACE.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.REPLACEQ.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.DELETE.cc()] = new DeleteCommandExecutor();
        this.executors[CommandCode.DELETEQ.cc()] = this.executors[CommandCode.DELETE.cc()];
        this.executors[CommandCode.GET.cc()] = new GetCommandExecutor();
        this.executors[CommandCode.GETQ.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GETK.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GETKQ.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.TOUCH.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GAT.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GATQ.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.INCREMENT.cc()] = new ArithmeticCommandExecutor();
        this.executors[CommandCode.INCREMENTQ.cc()] = this.executors[CommandCode.INCREMENT.cc()];
        this.executors[CommandCode.DECREMENT.cc()] = this.executors[CommandCode.INCREMENT.cc()];
        this.executors[CommandCode.DECREMENTQ.cc()] = this.executors[CommandCode.INCREMENT.cc()];
        this.executors[CommandCode.SASL_LIST_MECHS.cc()] = new SaslCommandExecutor();
        this.executors[CommandCode.SASL_AUTH.cc()] = this.executors[CommandCode.SASL_LIST_MECHS.cc()];
        this.executors[CommandCode.SASL_STEP.cc()] = this.executors[CommandCode.SASL_LIST_MECHS.cc()];
        this.executors[CommandCode.EVICT.cc()] = new EvictCommandExecutor();
        this.executors[CommandCode.HELLO.cc()] = new HelloCommandExecutor();
        this.executors[CommandCode.SELECT_BUCKET.cc()] = new SelectBucketCommandExecutor();
        this.executors[CommandCode.SUBDOC_GET.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_EXISTS.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_DICT_ADD.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_DICT_UPSERT.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_DELETE.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_REPLACE.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_ARRAY_PUSH_LAST.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_ARRAY_PUSH_FIRST.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_ARRAY_ADD_UNIQUE.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_ARRAY_INSERT.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_COUNTER.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_GET_COUNT.cc()] = new SubdocCommandExecutor();
        this.executors[CommandCode.SUBDOC_MULTI_MUTATION.cc()] = new SubdocMultiCommandExecutor();
        this.executors[CommandCode.SUBDOC_MULTI_LOOKUP.cc()] = new SubdocMultiCommandExecutor();
        this.executors[CommandCode.GET_ERRMAP.cc()] = new GetErrmapCommandExecutor();
        if (bucket.getType() == Bucket.BucketType.COUCHBASE) {
            this.executors[CommandCode.GETL.cc()] = this.executors[CommandCode.GET.cc()];
            this.executors[CommandCode.UNL.cc()] = new UnlockCommandExecutor();
            this.executors[CommandCode.GET_CLUSTER_CONFIG.cc()] = new ConfigCommandExecutor();
            this.executors[CommandCode.GET_REPLICA.cc()] = this.executors[CommandCode.GET.cc()];
            this.executors[CommandCode.OBSERVE.cc()] = new ObserveCommandExecutor();
            this.executors[CommandCode.OBSERVE_SEQNO.cc()] = new ObserveSeqnoCommandExecutor();
            this.executors[CommandCode.GET_RANDOM.cc()] = new GetRandomCommandExecutor();
        }
        this.bootTime = System.currentTimeMillis() / 1000L;
        this.selector = Selector.open();
        this.server = ServerSocketChannel.open();
        this.server.configureBlocking(false);
        if (hostname != null && !hostname.equals("*")) {
            this.server.socket().bind(new InetSocketAddress(hostname, port));
            this.hostname = hostname;
        } else {
            this.server.socket().bind(new InetSocketAddress(port));
            InetAddress address = this.server.socket().getInetAddress();
            if (address.isAnyLocalAddress()) {
                String name;
                try {
                    name = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException ex) {
                    name = "localhost";
                }
                this.hostname = name;
            } else {
                this.hostname = address.getHostName();
            }
        }
        this.port = this.server.socket().getLocalPort();
        this.server.register(this.selector, 16);
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void updateFailMakerContext(ErrorCode code, int count) {
        this.failmaker.update(code, count);
    }

    public Map<String, Object> toNodeConfigInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CouchbaseMock mock = this.bucket.getCluster();
        map.put("uptime", Long.toString(System.currentTimeMillis() - this.bootTime));
        map.put("replication", 1);
        map.put("clusterMembership", "active");
        map.put("status", "healthy");
        map.put("hostname", this.hostname + ":" + (mock == null ? "0" : Integer.valueOf(mock.getHttpPort())));
        map.put("clusterCompatibility", 1);
        map.put("version", "9.9.9");
        StringBuilder sb = new StringBuilder(System.getProperty("os.arch"));
        sb.append("-");
        sb.append(System.getProperty("os.name"));
        sb.append("-");
        sb.append(System.getProperty("os.version"));
        map.put("os", sb.toString().replaceAll(" ", "_"));
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        ports.put("direct", this.port);
        ports.put("proxy", 0);
        map.put("ports", ports);
        return map;
    }

    private Map<String, String> getDefaultStats() {
        HashMap<String, String> stats = new HashMap<String, String>();
        stats.put("pid", Long.toString(Thread.currentThread().getId()));
        stats.put("time", Long.toString(new Date().getTime()));
        stats.put("version", "9.9.9");
        stats.put("uptime", "15554");
        stats.put("accepting_conns", "1");
        stats.put("auth_cmds", "0");
        stats.put("auth_errors", "0");
        stats.put("bucket_active_conns", "1");
        stats.put("bucket_conns", "3");
        stats.put("bytes_read", "1108621");
        stats.put("bytes_written", "205374436");
        stats.put("cas_badval", "0");
        stats.put("cas_hits", "0");
        stats.put("cas_misses", "0");
        stats.put("mem_used", "100000000000000000000");
        stats.put("curr_connections", "-1");
        return stats;
    }

    public Map<String, String> getStats(String about) {
        if (about == null || about.isEmpty()) {
            return this.getDefaultStats();
        }
        if (about.equals("memory")) {
            HashMap<String, String> memStats = new HashMap<String, String>();
            Runtime rt = Runtime.getRuntime();
            memStats.put("mem_used", Long.toString(rt.totalMemory()));
            memStats.put("mem_free", Long.toString(rt.freeMemory()));
            memStats.put("mem_max", Long.toString(rt.maxMemory()));
            return memStats;
        }
        if (about.equals("tap")) {
            HashMap<String, String> tapStats = new HashMap<String, String>();
            tapStats.put("ep_tap_count", "0");
            return tapStats;
        }
        if (about.equals("__MOCK__")) {
            HashMap<String, String> mockInfo = new HashMap<String, String>();
            mockInfo.put("implementation", "java");
            mockInfo.put("version", Info.getVersion());
            return mockInfo;
        }
        return null;
    }

    public String getSocketName() {
        return this.hostname + ":" + this.port;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostname() {
        return this.hostname;
    }

    private void writeResponse(SocketChannel channel, OutputContext ctx) throws IOException {
        while (ctx.hasRemaining()) {
            ByteBuffer[] bufs = ctx.getIov();
            long nw = channel.write(bufs);
            if (nw < 0L) {
                channel.close();
                throw new ClosedChannelException();
            }
            if (nw == 0L) {
                return;
            }
            ctx.updateBytesSent(nw);
        }
    }

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.selector.select();
                    if (!this.active) {
                        this.selector.selectedKeys().clear();
                    }
                }
                catch (IOException ex) {}
                continue;
                try {
                    Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                    while (iterator.hasNext()) {
                        SelectionKey key = iterator.next();
                        iterator.remove();
                        this.handleClient(key);
                    }
                }
                catch (IOException e) {
                    Logger.getLogger(MemcachedServer.class.getName()).log(Level.SEVERE, null, e);
                }
            }
        }
        finally {
            try {
                this.server.close();
                this.selector.close();
            }
            catch (IOException e) {
                Logger.getLogger(MemcachedServer.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    private void handleClientWrite(SocketChannel channel, OutputContext ctx) throws IOException {
        OutputContext effectiveCtx = ctx;
        if (this.truncateLimit > 0) {
            effectiveCtx = ctx.getSlice(this.truncateLimit);
        } else if (this.hiccupOffset > 0) {
            effectiveCtx = ctx.getSlice(this.hiccupOffset);
        }
        this.writeResponse(channel, effectiveCtx);
        if (this.hiccupOffset > 0) {
            try {
                Thread.sleep(this.hiccupTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.writeResponse(channel, ctx);
        }
    }

    private void handleClientRead(SocketChannel channel, MemcachedConnection client) throws IOException {
        if (channel.read(client.getInputBuffer()) == -1) {
            channel.close();
            throw new ClosedChannelException();
        }
        client.step();
    }

    private void handleNewClient() throws IOException {
        SocketChannel cc = this.server.accept();
        cc.configureBlocking(false);
        cc.socket().setTcpNoDelay(false);
        cc.socket().setSendBufferSize(0x100000);
        cc.socket().setReceiveBufferSize(0x100000);
        cc.register(this.selector, 1, new MemcachedConnection(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClient(SelectionKey key) throws IOException {
        SocketChannel channel;
        MemcachedConnection client;
        block15: {
            client = (MemcachedConnection)key.attachment();
            if (client == null) {
                this.handleNewClient();
                return;
            }
            channel = (SocketChannel)key.channel();
            try {
                OutputContext ctx;
                if (key.isReadable()) {
                    this.handleClientRead(channel, client);
                }
                if (!key.isWritable() || (ctx = client.borrowOutputContext()) == null) break block15;
                try {
                    this.handleClientWrite(channel, ctx);
                }
                finally {
                    client.returnOutputContext(ctx);
                }
            }
            catch (IOException ex) {
                try {
                    channel.close();
                }
                finally {
                    key.cancel();
                }
                try {
                    String message = ex.getMessage();
                    if (message == null) {
                        throw ex;
                    }
                    if (!message.contains("reset") && !message.contains("forcibly")) {
                        throw ex;
                    }
                }
                catch (ClosedChannelException closedChannelException) {
                    // empty catch block
                }
                return;
            }
        }
        int ioEvents = 1;
        if (client.hasOutput()) {
            ioEvents |= 4;
        }
        channel.register(this.selector, ioEvents, client);
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    private boolean authOk(BinaryCommand cmd, MemcachedConnection client) {
        if (client.isAuthenticated()) {
            return true;
        }
        switch (cmd.getComCode()) {
            case SASL_AUTH: 
            case SASL_LIST_MECHS: 
            case SASL_STEP: 
            case HELLO: 
            case GET_ERRMAP: {
                return true;
            }
        }
        return false;
    }

    private CommandExecutor getExecutor(CommandCode code) {
        if (code == CommandCode.ILLEGAL) {
            return unknownHandler;
        }
        return this.executors[code.cc()];
    }

    @Override
    public void execute(BinaryCommand cmd, MemcachedConnection client) throws IOException {
        try {
            ErrorCode failcode;
            if (this.enhancedErrorsEnabled) {
                cmd.generateEventId();
            }
            if (this.shouldLogCommands) {
                this.commandLog.add(new CommandLogEntry(cmd.getOpcode()));
            }
            if ((failcode = this.failmaker.getFailCode()) != ErrorCode.SUCCESS) {
                client.sendResponse(new BinaryResponse(cmd, failcode));
            } else if (this.authOk(cmd, client)) {
                long start = System.nanoTime();
                BinaryResponse response = this.getExecutor(cmd.getComCode()).execute(cmd, this, client);
                long end = System.nanoTime();
                if (response != null) {
                    if (client.supportsTracing()) {
                        long elapsedMicros = (end - start) / 1000L;
                        long maxVal = 120125042L;
                        elapsedMicros = Math.min(elapsedMicros, maxVal);
                        short encodedMicros = (short)Math.round(Math.pow(elapsedMicros * 2L, 0.5747126436781609));
                        response.getBuffer().get();
                        byte opcode = response.getBuffer().get();
                        short keyLength = response.getBuffer().getShort();
                        byte extraLength = response.getBuffer().get();
                        byte datatype = response.getBuffer().get();
                        short errorCode = response.getBuffer().getShort();
                        int bodyLength = response.getBuffer().getInt();
                        int opaque = response.getBuffer().getInt();
                        long cas = response.getBuffer().getLong();
                        byte framingExtrasLength = 3;
                        ByteBuffer message = ByteBuffer.allocate(24 + (bodyLength += framingExtrasLength));
                        message.put((byte)24);
                        message.put(opcode);
                        message.put(framingExtrasLength);
                        message.put((byte)keyLength);
                        message.put(extraLength);
                        message.put(datatype);
                        message.putShort(errorCode);
                        message.putInt(bodyLength);
                        message.putInt(opaque);
                        message.putLong(cas);
                        byte tracing_framing_id = 2;
                        message.put(tracing_framing_id);
                        message.putShort(encodedMicros);
                        message.put(response.getBuffer());
                        message.rewind();
                        response.setBuffer(message);
                    }
                    client.sendResponse(response);
                }
            } else {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.AUTH_ERROR));
            }
        }
        catch (AccessControlException ex) {
            client.sendResponse(BinaryConfigResponse.createNotMyVbucket(cmd, this));
        }
    }

    BinaryProtocolHandler getProtocolHandler() {
        return this;
    }

    public void shutdown() {
        this.active = false;
    }

    public void startup() {
        this.active = true;
    }

    public void setHiccup(int milliSeconds, int offset) {
        if (milliSeconds < 0 || offset < 0) {
            throw new IllegalArgumentException("Time and offset must be >= 0");
        }
        this.hiccupTime = milliSeconds;
        this.hiccupOffset = offset;
    }

    public void setTruncateLimit(int limit) {
        this.truncateLimit = limit;
    }

    public void flushNode() {
        this.storage.flush();
    }

    public void flushAll() {
        this.flushNode();
        for (MemcachedServer other : this.bucket.getServers()) {
            if (other == this) continue;
            other.flushNode();
        }
    }

    public VBucketStore getCache(BinaryCommand cmd) {
        return this.storage.getCache(this, cmd.getVBucketId());
    }

    public static void main(String[] args) {
        try {
            VBucketInfo[] vbi = new VBucketInfo[1024];
            for (int ii = 0; ii < vbi.length; ++ii) {
                vbi[ii] = new VBucketInfo();
            }
            MemcachedServer server = new MemcachedServer(null, null, 11211, vbi, false);
            for (VBucketInfo aVbi : vbi) {
                aVbi.setOwner(server);
            }
            server.run();
        }
        catch (IOException e) {
            Logger.getLogger(MemcachedServer.class.getName()).log(Level.SEVERE, "Fatal error! failed to create socket: ", e);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isCccpEnabled() {
        return this.cccpEnabled && this.bucket.getType() != Bucket.BucketType.MEMCACHED;
    }

    public void setCccpEnabled(boolean enabled) {
        this.cccpEnabled = enabled;
    }

    public Bucket.BucketType getType() {
        return this.bucket.getType();
    }

    public MemcachedConnection findConnection(SocketAddress address) throws IOException {
        for (SelectionKey key : this.selector.keys()) {
            SocketChannel ch;
            Object o = key.attachment();
            if (o == null || !(o instanceof MemcachedConnection) || !(ch = (SocketChannel)key.channel()).socket().getRemoteSocketAddress().equals(address)) continue;
            return (MemcachedConnection)o;
        }
        return null;
    }

    public void startLog() {
        this.shouldLogCommands = true;
    }

    public void stopLog() {
        this.shouldLogCommands = false;
        this.commandLog.clear();
    }

    public List<CommandLogEntry> getLogs() {
        return this.commandLog;
    }

    public class FailMaker {
        private ErrorCode code = ErrorCode.SUCCESS;
        private int remaining = 0;

        public void update(ErrorCode code, int count) {
            this.code = code;
            this.remaining = count;
        }

        public ErrorCode getFailCode() {
            if (this.remaining == 0) {
                return ErrorCode.SUCCESS;
            }
            if (this.remaining > 0) {
                --this.remaining;
            }
            return this.code;
        }
    }

    public static class CommandLogEntry {
        private final int opcode;
        private final long timestamp;

        CommandLogEntry(int opcode) {
            this.opcode = opcode;
            this.timestamp = System.currentTimeMillis();
        }

        public CommandLogEntry(int opcode, long timestamp) {
            this.opcode = opcode;
            this.timestamp = timestamp;
        }

        public long getMsTimestamp() {
            return this.timestamp;
        }

        public int getOpcode() {
            return this.opcode;
        }
    }
}

