/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.http;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.http.AuthContext;
import com.couchbase.mock.http.Authenticator;
import com.couchbase.mock.httpio.HandlerUtil;
import java.io.IOException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

public class HttpAuthVerifier {
    private final Authenticator authenticator;
    private final Bucket bucket;

    public HttpAuthVerifier(Bucket bucket, Authenticator authenticator) {
        this.authenticator = authenticator;
        this.bucket = bucket;
    }

    public boolean verify(HttpRequest request, HttpResponse response, HttpContext context) throws IOException {
        AuthContext ctx = HandlerUtil.getAuth(context, request);
        if (!this.authenticator.isAuthorizedForBucket(ctx, this.bucket)) {
            response.setStatusCode(401);
            return false;
        }
        return true;
    }
}

