/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.http;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.http.AuthContext;

public class Authenticator {
    private final String adminName;
    private final String adminPass;

    public Authenticator(String username, String password) {
        this.adminName = username;
        this.adminPass = password;
    }

    public boolean isAuthorizedForBucket(AuthContext ctx, Bucket bucket) {
        if (ctx.getUsername().equals(this.adminName)) {
            return ctx.getPassword().equals(this.adminPass);
        }
        if (bucket.getName().equals(ctx.getUsername())) {
            return bucket.getPassword().equals(ctx.getPassword());
        }
        return bucket.getPassword().isEmpty() && ctx.getPassword().isEmpty();
    }

    public boolean isAdministrator(AuthContext ctx) {
        return ctx.getUsername() != null && ctx.getUsername().equals(this.adminName) && ctx.getPassword() != null && ctx.getPassword().equals(this.adminPass);
    }

    public String getAdminName() {
        return this.adminName;
    }

    public String getAdminPass() {
        return this.adminPass;
    }
}

