/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control.handlers;

import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.couchbase.mock.control.MockCommand;
import com.couchbase.mock.control.handlers.KeyCommandHandler;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.Storage;
import com.couchbase.mock.memcached.protocol.Datatype;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.security.AccessControlException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class PersistenceCommandHandler
extends KeyCommandHandler {
    private String error = null;

    private void executeReal(JsonObject payload, MockCommand.Command command) {
        Item source;
        JsonElement eOnReplicas;
        long cas = 0L;
        ArrayList<Storage> stores = new ArrayList<Storage>();
        boolean onMaster = payload.get("OnMaster").getAsBoolean();
        if (payload.has("CAS")) {
            cas = payload.get("CAS").getAsLong();
        }
        String value = payload.has("Value") ? payload.get("Value").getAsString() : "";
        Storage masterStore = this.vbi.getOwner().getStorage();
        if (onMaster) {
            stores.add(masterStore);
        }
        if ((eOnReplicas = payload.get("OnReplicas")).isJsonArray()) {
            for (JsonElement ix : eOnReplicas.getAsJsonArray()) {
                MemcachedServer mc = this.vbi.getReplicas().get(ix.getAsInt());
                Storage s = mc.getStorage();
                if (stores.contains(s)) continue;
                stores.add(s);
            }
        } else {
            int maxReplicas = eOnReplicas.getAsInt();
            int replicasSelected = 0;
            for (MemcachedServer server : this.vbi.getReplicas()) {
                if (replicasSelected != maxReplicas) {
                    if (!server.isActive()) continue;
                    stores.add(server.getStorage());
                    ++replicasSelected;
                    continue;
                }
                break;
            }
        }
        if ((source = masterStore.getCached(this.keySpec)) == null) {
            assert (value != null);
            assert (value.getBytes() != null);
            source = new Item(this.keySpec, 0, 0, value.getBytes(), null, cas, Datatype.RAW.value());
        }
        if (cas < 0L) {
            cas = (source.getCas() + 1L) * 2L;
        }
        Item newItem = cas != 0L ? new Item(source.getKeySpec(), source.getFlags(), source.getExpiryTime(), value.getBytes(), source.getXattr(), cas, Datatype.RAW.value()) : new Item(source);
        if (stores.size() == 0) {
            System.err.println("No stores available for key");
        }
        for (Storage curStore : stores) {
            switch (command) {
                case PERSIST: 
                case ENDURE: {
                    curStore.putPersisted(newItem);
                    if (command == MockCommand.Command.PERSIST) break;
                }
                case CACHE: {
                    curStore.putCached(newItem);
                    break;
                }
                case PURGE: 
                case UNPERSIST: {
                    curStore.removePersisted(this.keySpec);
                    if (command == MockCommand.Command.UNPERSIST) break;
                }
                case UNCACHE: {
                    curStore.removeCached(this.keySpec);
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized command");
                }
            }
        }
    }

    @Override
    @NotNull
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        if (mock == null) {
            PersistenceCommandHandler.$$$reportNull$$$0(0);
        }
        if (command == null) {
            PersistenceCommandHandler.$$$reportNull$$$0(1);
        }
        if (payload == null) {
            PersistenceCommandHandler.$$$reportNull$$$0(2);
        }
        super.execute(mock, command, payload);
        try {
            this.executeReal(payload, command);
        }
        catch (AccessControlException e) {
            this.error = e.getMessage();
        }
        CommandStatus commandStatus = this.getResponse();
        if (commandStatus == null) {
            PersistenceCommandHandler.$$$reportNull$$$0(3);
        }
        return commandStatus;
    }

    @Override
    @NotNull
    protected CommandStatus getResponse() {
        if (this.error == null) {
            CommandStatus commandStatus = super.getResponse();
            if (commandStatus == null) {
                PersistenceCommandHandler.$$$reportNull$$$0(4);
            }
            return commandStatus;
        }
        CommandStatus commandStatus = new CommandStatus().fail(this.error);
        if (commandStatus == null) {
            PersistenceCommandHandler.$$$reportNull$$$0(5);
        }
        return commandStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/couchbase/mock/control/handlers/PersistenceCommandHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/couchbase/mock/control/handlers/PersistenceCommandHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

