/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control.handlers;

import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.couchbase.mock.control.MockCommand;
import com.couchbase.mock.control.handlers.KeyCommandHandler;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.KeySpec;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.VBucketInfo;
import com.couchbase.mock.memcached.protocol.Datatype;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class KeyInfoCommandHandler
extends KeyCommandHandler {
    private String result;

    private static Map<String, Object> itemToString(Item itm) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (itm != null) {
            byte[] value = itm.getValue();
            String valueString = null;
            if (value != null) {
                valueString = new String(value);
            }
            ret.put("Value", valueString);
            ret.put("CAS", itm.getCas());
            ret.put("Snappy", (itm.getDatatype() & Datatype.SNAPPY.value()) > 0);
        }
        return ret;
    }

    private static Map<String, Object> configToString(MemcachedServer server, KeySpec ks) {
        VBucketInfo vbi = server.getStorage().getVBucketInfo(ks.vbId);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (vbi.getOwner() == server) {
            ret.put("Index", 0);
            ret.put("Type", "master");
        } else {
            ret.put("Index", vbi.getReplicas().indexOf(server) + 1);
            ret.put("Type", "replica");
        }
        return ret;
    }

    private static Map<String, Object> serverKeyStatus(MemcachedServer server, KeySpec ks) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("Cache", KeyInfoCommandHandler.itemToString(server.getStorage().getCached(ks)));
        ret.put("Disk", KeyInfoCommandHandler.itemToString(server.getStorage().getPersisted(ks)));
        ret.put("Conf", KeyInfoCommandHandler.configToString(server, ks));
        return ret;
    }

    @Override
    @NotNull
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        if (mock == null) {
            KeyInfoCommandHandler.$$$reportNull$$$0(0);
        }
        if (command == null) {
            KeyInfoCommandHandler.$$$reportNull$$$0(1);
        }
        if (payload == null) {
            KeyInfoCommandHandler.$$$reportNull$$$0(2);
        }
        super.execute(mock, command, payload);
        ArrayList<Map<String, Object>> infoList = new ArrayList<Map<String, Object>>();
        List<MemcachedServer> vbiServers = this.vbi.getAllServers();
        for (MemcachedServer server : this.bucket.getServers()) {
            if (!vbiServers.contains(server)) {
                infoList.add(null);
                continue;
            }
            Map<String, Object> skInfo = KeyInfoCommandHandler.serverKeyStatus(server, this.keySpec);
            infoList.add(skInfo);
        }
        CommandStatus ret = new CommandStatus();
        ret.setPayload(infoList);
        CommandStatus commandStatus = ret;
        if (commandStatus == null) {
            KeyInfoCommandHandler.$$$reportNull$$$0(3);
        }
        return commandStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/couchbase/mock/control/handlers/KeyInfoCommandHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/couchbase/mock/control/handlers/KeyInfoCommandHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

