/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control.handlers;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.couchbase.mock.control.MissingRequiredFieldException;
import com.couchbase.mock.control.MockCommand;
import com.couchbase.mock.memcached.KeySpec;
import com.couchbase.mock.memcached.VBucketInfo;
import com.google.gson.JsonObject;
import java.security.AccessControlException;
import org.jetbrains.annotations.NotNull;

public abstract class KeyCommandHandler
extends MockCommand {
    KeySpec keySpec;
    Bucket bucket;
    VBucketInfo vbi;

    @Override
    @NotNull
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        if (mock == null) {
            KeyCommandHandler.$$$reportNull$$$0(0);
        }
        if (command == null) {
            KeyCommandHandler.$$$reportNull$$$0(1);
        }
        if (payload == null) {
            KeyCommandHandler.$$$reportNull$$$0(2);
        }
        short vbIndex = -1;
        String bucketString = "default";
        if (payload.has("Bucket")) {
            bucketString = payload.get("Bucket").getAsString();
        }
        this.bucket = mock.getBuckets().get(bucketString);
        if (this.bucket == null) {
            throw new AccessControlException("No such bucket: " + bucketString);
        }
        if (!payload.has("Key")) {
            throw new MissingRequiredFieldException("Key");
        }
        String key = payload.get("Key").getAsString();
        if (!payload.has("vBucket")) {
            vbIndex = this.bucket.getVbIndexForKey(key);
        }
        if (vbIndex < 0 || vbIndex >= this.bucket.getVBucketInfo().length) {
            throw new AccessControlException("Invalid vBucket " + vbIndex);
        }
        this.keySpec = new KeySpec(key, vbIndex);
        this.vbi = this.bucket.getVBucketInfo()[this.keySpec.vbId];
        CommandStatus commandStatus = new CommandStatus().fail();
        if (commandStatus == null) {
            KeyCommandHandler.$$$reportNull$$$0(3);
        }
        return commandStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/couchbase/mock/control/handlers/KeyCommandHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/couchbase/mock/control/handlers/KeyCommandHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

